/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_SuperBus_Output
extends GT_MetaTileEntity_Hatch_OutputBus {
    public GT_MetaTileEntity_SuperBus_Output(int id, String name, String nameRegional, int tier) {
        super(id, name, nameRegional, tier, GT_MetaTileEntity_SuperBus_Output.getSlots(tier));
    }

    public GT_MetaTileEntity_SuperBus_Output(String name, int tier, String[] description, ITexture[][][] textures) {
        super(name, tier, GT_MetaTileEntity_SuperBus_Output.getSlots(tier), description, textures);
    }

    public static int getSlots(int aTier) {
        return (1 + aTier) * 16;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_SuperBus_Output(this.mName, this.mTier, (String[])ArrayExt.of((Object[])new String[]{this.mDescription}), this.mTextures);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            for (int j = i + 1; j < this.mInventory.length; ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GT_Utility.areStacksEqual((ItemStack)this.mInventory[i], (ItemStack)this.mInventory[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), (int)j, (int)i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    public String[] getDescription() {
        String[] aDesc = new String[]{"Item Output for Multiblocks", "This bus has no GUI", "" + GT_MetaTileEntity_SuperBus_Output.getSlots(this.mTier) + " Slots", CORE.GT_Tooltip};
        return aDesc;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.displayBusContents(aPlayer);
        return true;
    }

    public void displayBusContents(EntityPlayer aPlayer) {
        String STRIP = "Item Array: ";
        String aNameString = ItemUtils.getArrayStackNames(this.getRealInventory());
        String[] aNames = (aNameString = aNameString.replace(STRIP, "")).length() < 1 ? null : aNameString.split(",");
        if (aNames == null || aNames.length <= 0) {
            PlayerUtils.messagePlayer(aPlayer, "This Super Bus (O) is Empty. Total Slots: " + GT_MetaTileEntity_SuperBus_Output.getSlots(this.mTier));
            return;
        }
        PlayerUtils.messagePlayer(aPlayer, "This Super Bus (O) contains:");
        for (String s : aNames) {
            if (s.startsWith(" ")) {
                s = s.substring(1);
            }
            PlayerUtils.messagePlayer(aPlayer, s);
        }
    }

    public int getMaxItemCount() {
        return super.getMaxItemCount();
    }

    public int func_70302_i_() {
        return super.func_70302_i_();
    }

    public ItemStack func_70301_a(int aIndex) {
        return super.func_70301_a(aIndex);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return super.func_102007_a(aIndex, aStack, aSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return super.func_102008_b(aIndex, aStack, aSide);
    }

    public ItemStack[] getRealInventory() {
        return super.getRealInventory();
    }
}

