/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUIDialogSelectItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_SetConfigurationCircuit;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_SuperBus_Input
extends GT_MetaTileEntity_Hatch_InputBus {
    public GT_MetaTileEntity_SuperBus_Input(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, GT_MetaTileEntity_SuperBus_Input.getSlots(aTier) + 1);
    }

    public GT_MetaTileEntity_SuperBus_Input(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, GT_MetaTileEntity_SuperBus_Input.getSlots(aTier) + 1, aDescription, aTextures);
    }

    public static int getSlots(int aTier) {
        return (1 + aTier) * 16;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_SuperBus_Input(this.mName, this.mTier, (String[])ArrayExt.of((Object[])new String[]{this.mDescription}), this.mTextures);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public String[] getDescription() {
        return new String[]{"Item Input for Multiblocks", "This bus has no GUI, but can have items extracted", "" + (GT_MetaTileEntity_SuperBus_Input.getSlots(this.mTier) + 1) + " Slots", "To set circuit slot, left click with empty hand", CORE.GT_Tooltip};
    }

    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide() && aPlayer.func_71045_bC() == null) {
            this.openCircuitSelector();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void openCircuitSelector() {
        List circuits = this.getConfigurationCircuits();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GT_GUIDialogSelectItem(StatCollector.func_74838_a((String)"GT5U.machines.select_circuit"), this.getStackForm(0L), null, this::onCircuitSelected, circuits, GT_Utility.findMatchingStackInList((List)circuits, (ItemStack)this.func_70301_a(this.getCircuitSlot()))));
    }

    @SideOnly(value=Side.CLIENT)
    private void onCircuitSelected(ItemStack selected) {
        GT_Values.NW.sendToServer((GT_Packet)new GT_Packet_SetConfigurationCircuit(this.getBaseMetaTileEntity(), selected));
        this.func_70299_a(this.getCircuitSlot(), selected);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.displayBusContents(aPlayer);
        return true;
    }

    public void displayBusContents(EntityPlayer aPlayer) {
        String STRIP = "Item Array: ";
        String aNameString = ItemUtils.getArrayStackNames(this.mInventory);
        String[] aNames = (aNameString = aNameString.replace(STRIP, "")).length() < 1 ? null : aNameString.split(",");
        if (aNames == null || aNames.length == 0) {
            PlayerUtils.messagePlayer(aPlayer, "This Super Bus (I) is Empty. Total Slots: " + this.mInventory.length);
            return;
        }
        PlayerUtils.messagePlayer(aPlayer, "This Super Bus (I) contains: [" + this.mInventory.length + "]");
        if (aNames.length <= 12) {
            for (String s : aNames) {
                if (s.startsWith(" ")) {
                    s = s.substring(1);
                }
                PlayerUtils.messagePlayer(aPlayer, s);
            }
        } else {
            StringBuilder superString = new StringBuilder();
            for (String s : aNames) {
                if (s.startsWith(" ")) {
                    s = s.substring(1);
                }
                superString.append(s).append(", ");
            }
            PlayerUtils.messagePlayer(aPlayer, superString.toString());
        }
    }

    public int getCircuitSlot() {
        return GT_MetaTileEntity_SuperBus_Input.getSlots(this.mTier);
    }
}

