/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.google.common.collect.BiMap;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Hatch_Plasma
extends GT_MetaTileEntity_Hatch_Output {
    public final AutoMap<Fluid> mFluidsToUse = new AutoMap();
    public final int mFluidCapacity;
    private int mTotalPlasmaSupported = -1;
    private Field F1;
    private Field F2;

    public GT_MetaTileEntity_Hatch_Plasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
        this.mFluidCapacity = 256000;
        this.initHatch();
    }

    public GT_MetaTileEntity_Hatch_Plasma(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription, aTextures);
        this.mFluidCapacity = 256000;
        this.initHatch();
    }

    public GT_MetaTileEntity_Hatch_Plasma(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription[0], aTextures);
        this.mFluidCapacity = 256000;
        this.initHatch();
    }

    private void initHatch() {
        AutoMap<String> mValidPlasmaNameCache;
        block11: {
            Field fluidNameCache = ReflectionUtils.getField(FluidRegistry.class, "fluidNames");
            mValidPlasmaNameCache = new AutoMap<String>();
            if (fluidNameCache != null) {
                try {
                    Object fluidNames = fluidNameCache.get(null);
                    if (fluidNames == null) break block11;
                    try {
                        BiMap fluidNamesMap = (BiMap)fluidNames;
                        if (fluidNamesMap != null) {
                            for (String g : fluidNamesMap.values()) {
                                if (!g.toLowerCase().contains("plasma")) continue;
                                mValidPlasmaNameCache.put(g);
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException fluidNames) {
                    // empty catch block
                }
            }
        }
        AutoMap<Fluid> mPlasmaCache = new AutoMap<Fluid>();
        if (!mValidPlasmaNameCache.isEmpty()) {
            for (String y : mValidPlasmaNameCache) {
                Fluid t = FluidRegistry.getFluid((String)y);
                if (t == null || t.getTemperature() <= 1000) continue;
                mPlasmaCache.put(t);
            }
        }
        if (!mPlasmaCache.isEmpty()) {
            for (Fluid w : mPlasmaCache) {
                this.mFluidsToUse.put(w);
            }
        }
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture};
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            for (Fluid f : this.mFluidsToUse) {
                if (f == null || GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true).getFluid() != f) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        for (Fluid f : this.mFluidsToUse) {
            if (f == null || aFluid.getFluid() != f) continue;
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.mFluidCapacity;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Plasma(this.mName, this.mDescription, this.mTextures);
    }

    public String[] getDescription() {
        if (this.mTotalPlasmaSupported < 0) {
            this.mTotalPlasmaSupported = this.mFluidsToUse.isEmpty() ? 0 : this.mFluidsToUse.size();
        }
        String aX = EnumChatFormatting.GRAY + "";
        String a1 = EnumChatFormatting.GOLD + "Refined containment" + aX;
        String a2 = EnumChatFormatting.GOLD + "Capacity: " + EnumChatFormatting.DARK_AQUA + this.getCapacity() + "L" + aX;
        String a3 = EnumChatFormatting.GOLD + "Supports " + EnumChatFormatting.DARK_RED + this.mTotalPlasmaSupported + EnumChatFormatting.GOLD + " types of plasma" + aX;
        String[] s2 = new String[]{a1, a2, a3, CORE.GT_Tooltip};
        return s2;
    }

    public boolean doesFillContainers() {
        return true;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return super.getTextureSet(aTextures);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        int a1 = 0;
        int a2 = 0;
        try {
            if (this.F1 == null) {
                this.F1 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "actualTexture");
            }
            if (this.F2 == null) {
                this.F2 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "mTexturePage");
            }
            if (this.F1 != null) {
                a1 = this.F1.getByte((Object)this);
            }
            if (this.F2 != null) {
                a2 = this.F2.getByte((Object)this);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        int textureIndex = a1 | a2 << 7;
        byte texturePointer = (byte)(a1 & 0x7F);
        if (aSide == 1 || aSide == 0) {
            ITexture g = textureIndex > 0 ? StaticFields59.getCasingTexturePages(a2, texturePointer) : Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            return new ITexture[]{g};
        }
        if (aSide != aFacing) {
            if (textureIndex > 0) {
                ITexture[] iTextureArray2 = new ITexture[1];
                iTextureArray = iTextureArray2;
                iTextureArray2[0] = StaticFields59.getCasingTexturePages(a2, texturePointer);
            } else {
                ITexture[] iTextureArray3 = new ITexture[1];
                iTextureArray = iTextureArray3;
                iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            }
        } else {
            iTextureArray = textureIndex > 0 ? (aActive ? this.getTexturesActive(StaticFields59.getCasingTexturePages(a2, texturePointer)) : this.getTexturesInactive(StaticFields59.getCasingTexturePages(a2, texturePointer))) : (aActive ? this.getTexturesActive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]) : this.getTexturesInactive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]));
        }
        return iTextureArray;
    }
}

