/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.general.ItemAirFilter;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_Hatch_Muffler_Advanced;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_Hatch_Muffler_Advanced;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_Muffler_Adv
extends GT_MetaTileEntity_Hatch_Muffler {
    protected int SLOT_FILTER = 0;
    private int mPollutionSmogLimit = 500000;

    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK || CORE.GTNH) {
            try {
                Integer a1 = (int)((Integer)StaticFields59.getFieldFromGregtechProxy("mPollutionSmogLimit"));
                if (a1 != null && a1 > 0) {
                    this.mPollutionSmogLimit = a1;
                }
            }
            catch (Throwable t) {
                this.mPollutionSmogLimit = 500000;
            }
        }
    }

    public GT_MetaTileEntity_Hatch_Muffler_Adv(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
        ReflectionUtils.setField((Object)this, "mInventory", (Object)new ItemStack[1]);
    }

    public GT_MetaTileEntity_Hatch_Muffler_Adv(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        ReflectionUtils.setField((Object)this, "mInventory", (Object)new ItemStack[1]);
    }

    public GT_MetaTileEntity_Hatch_Muffler_Adv(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription[0], aTextures);
        ReflectionUtils.setField((Object)this, "mInventory", (Object)new ItemStack[1]);
    }

    public String[] getDescription() {
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            String[] mDescArray = StaticFields59.getDescriptionArray((GT_MetaTileEntity_TieredMachineBlock)this);
            String[] desc = new String[mDescArray.length + 7];
            System.arraycopy(mDescArray, 0, desc, 0, mDescArray.length);
            desc[mDescArray.length] = "DO NOT OBSTRUCT THE OUTPUT!";
            desc[mDescArray.length + 1] = "Requires 3 Air on the exhaust face";
            desc[mDescArray.length + 2] = "Requires Air Filters";
            desc[mDescArray.length + 3] = "Mufflers require T2 Filters from IV-" + GT_Values.VN[9];
            desc[mDescArray.length + 4] = "Reduces Pollution to " + this.calculatePollutionReductionForTooltip(100) + "%";
            desc[mDescArray.length + 5] = "Recovers " + (105 - this.calculatePollutionReductionForTooltip(100)) + "% of CO2/CO/SO2";
            desc[mDescArray.length + 6] = CORE.GT_Tooltip;
            return desc;
        }
        return new String[0];
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Hatch_Muffler_Adv)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Hatch_Muffler_Adv)};
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex == this.SLOT_FILTER;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Muffler_Adv(this.mName, (int)this.mTier, StaticFields59.getDescriptionArray((GT_MetaTileEntity_TieredMachineBlock)this), this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new CONTAINER_Hatch_Muffler_Advanced(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GUI_Hatch_Muffler_Advanced(aPlayerInventory, aBaseMetaTileEntity, "Advanced Muffler", "machine_Charger.png");
    }

    private boolean airCheck() {
        return this.getBaseMetaTileEntity().getAirAtSide(this.getBaseMetaTileEntity().getFrontFacing()) && this.getBaseMetaTileEntity().getAirAtSideAndDistance(this.getBaseMetaTileEntity().getFrontFacing(), 1) && this.getBaseMetaTileEntity().getAirAtSideAndDistance(this.getBaseMetaTileEntity().getFrontFacing(), 2);
    }

    public boolean polluteEnvironment() {
        if (this.airCheck() && this.damageAirFilter()) {
            int aEmission = this.calculatePollutionReduction(10000);
            PollutionUtils.addPollution(this.getBaseMetaTileEntity(), aEmission);
            return true;
        }
        return false;
    }

    public int calculatePollutionReductionForTooltip(int aPollution) {
        return (int)((double)aPollution * Math.pow(0.64, this.mTier - 1));
    }

    public int calculatePollutionReduction(int aPollution) {
        double aVal1 = (double)aPollution * Math.pow(0.64, this.mTier - 1);
        int aVal2 = (int)aVal1;
        if (!this.hasValidFilter()) {
            aVal2 = (int)((double)aPollution * Math.pow(0.7, this.mTier - 1));
        }
        return aVal2;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == this.SLOT_FILTER && this.isAirFilter(aStack);
    }

    private ItemStack getInventoryStack() {
        if (this.mInventory != null && this.mInventory.length > 0 && this.mInventory.length - 1 >= this.SLOT_FILTER) {
            return this.mInventory[this.SLOT_FILTER];
        }
        return null;
    }

    private void breakAirFilter() {
        if (this.mInventory != null && this.mInventory.length > 0 && this.mInventory.length - 1 >= this.SLOT_FILTER) {
            Logger.INFO("Breaking Filter");
            this.mInventory[this.SLOT_FILTER] = null;
        }
    }

    public boolean hasValidFilter() {
        return this.isAirFilter(this.getInventoryStack());
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        String aParticleName = aTick % 2L == 0L ? "cloud" : "smoke";
        if (aBaseMetaTileEntity.isClientSide()) {
            if (this.getBaseMetaTileEntity().isActive()) {
                this.pollutionParticles(this.getBaseMetaTileEntity().getWorld(), aParticleName);
            }
        } else if (this.getInventoryStack() == null) {
            // empty if block
        }
    }

    public boolean isAirFilter(ItemStack filter) {
        if (filter == null) {
            return false;
        }
        if (filter.func_77973_b() instanceof ItemAirFilter) {
            if (this.mTier < 5) {
                return true;
            }
            if (filter.func_77960_j() == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean damageAirFilter() {
        ItemStack filter = this.getInventoryStack();
        if (filter == null) {
            return false;
        }
        if (this.isAirFilter(filter)) {
            long currentUse = ItemAirFilter.getFilterDamage(filter);
            Logger.INFO("Filter Damage: " + currentUse);
            if (filter.func_77960_j() == 0 && currentUse >= 49L || filter.func_77960_j() == 1 && currentUse >= 2499L) {
                this.breakAirFilter();
                return true;
            }
            ItemAirFilter.setFilterDamage(filter, currentUse + 1L);
            Logger.INFO("Filter Damage now: " + currentUse);
            return true;
        }
        return false;
    }

    public void pollutionParticles(World aWorld, String name) {
        float zSpd;
        float xSpd;
        boolean chk3;
        boolean chk2;
        float ran1 = CORE.RANDOM.nextFloat();
        float ran2 = 0.0f;
        float ran3 = 0.0f;
        boolean chk1 = ran1 * 100.0f < (float)this.calculatePollutionReduction(100);
        int aPollutionAmount = PollutionUtils.getPollution(this.getBaseMetaTileEntity());
        if (aPollutionAmount >= this.mPollutionSmogLimit) {
            ran2 = CORE.RANDOM.nextFloat();
            ran3 = CORE.RANDOM.nextFloat();
            chk2 = ran2 * 100.0f < (float)this.calculatePollutionReduction(100);
            boolean bl = chk3 = ran3 * 100.0f < (float)this.calculatePollutionReduction(100);
            if (!(chk1 || chk2 || chk3)) {
                return;
            }
        } else {
            if (!chk1) {
                return;
            }
            chk3 = false;
            chk2 = false;
        }
        IGregTechTileEntity aMuffler = this.getBaseMetaTileEntity();
        ForgeDirection aDir = ForgeDirection.getOrientation((int)aMuffler.getFrontFacing());
        float xPos = (float)aDir.offsetX * 0.76f + (float)aMuffler.getXCoord() + 0.25f;
        float yPos = (float)aDir.offsetY * 0.76f + (float)aMuffler.getYCoord() + 0.25f;
        float zPos = (float)aDir.offsetZ * 0.76f + (float)aMuffler.getZCoord() + 0.25f;
        float ySpd = (float)aDir.offsetY * 0.1f + 0.2f + 0.1f * CORE.RANDOM.nextFloat();
        if (aDir.offsetY == -1) {
            float temp = CORE.RANDOM.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)aDir.offsetX * (0.1f + 0.2f * CORE.RANDOM.nextFloat());
            zSpd = (float)aDir.offsetZ * (0.1f + 0.2f * CORE.RANDOM.nextFloat());
        }
        if (chk1) {
            aWorld.func_72869_a(name, (double)(xPos + ran1 * 0.5f), (double)(yPos + CORE.RANDOM.nextFloat() * 0.5f), (double)(zPos + CORE.RANDOM.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
        if (chk2) {
            aWorld.func_72869_a(name, (double)(xPos + ran2 * 0.5f), (double)(yPos + CORE.RANDOM.nextFloat() * 0.5f), (double)(zPos + CORE.RANDOM.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
        if (chk3) {
            aWorld.func_72869_a(name, (double)(xPos + ran3 * 0.5f), (double)(yPos + CORE.RANDOM.nextFloat() * 0.5f), (double)(zPos + CORE.RANDOM.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
    }
}

