/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.gui.computer;

import gregtech.api.gui.GT_ContainerMetaTile_Machine;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.computer.GT_Container_ComputerCube;
import gtPlusPlus.xmod.gregtech.common.computer.GT_Computercube_Description;
import gtPlusPlus.xmod.gregtech.common.tileentities.misc.GT_TileEntity_ComputerCube;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GT_GUIContainer_ComputerCube
extends GT_GUIContainerMetaTile_Machine {
    public final GT_Container_ComputerCube mPowerContainer;
    public static ResourceLocation[] mGUIbackground = new ResourceLocation[8];

    public GT_GUIContainer_ComputerCube(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aBaseMetaTileEntity, int aID) {
        super((GT_ContainerMetaTile_Machine)new GT_Container_ComputerCube(aInventoryPlayer, aBaseMetaTileEntity, aID), "miscutils:textures/gui/computer/" + aID + ".png");
        this.mPowerContainer = (GT_Container_ComputerCube)this.mContainer;
        if (this.mPowerContainer.mID == 5) {
            this.field_146999_f += 50;
        }
    }

    protected void func_146979_b(int par1, int par2) {
        GT_Container_ComputerCube tContainer = (GT_Container_ComputerCube)this.mContainer;
        if (tContainer != null) {
            switch (tContainer.mID) {
                case 0: {
                    this.field_146289_q.func_78276_b("Solaris 1.7.10", 56, 70, Utils.rgbtoHexValue(100, 190, 255));
                    break;
                }
                case 1: {
                    this.field_146289_q.func_78276_b("Reactorstats:", 7, 108, 0xFAFAFF);
                    this.field_146289_q.func_78276_b(this.toNumber(tContainer.mEU) + "EU at " + tContainer.mEUOut + "EU/t", 7, 120, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("HEM: " + (float)tContainer.mHEM / 10000.0f, 7, 128, 0xFAFAFF);
                    this.field_146289_q.func_78276_b(this.toNumber(tContainer.mHeat) + "/" + this.toNumber(tContainer.mMaxHeat) + "Heat", 7, 136, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("Explosionpower: " + (float)tContainer.mExplosionStrength / 100.0f, 7, 144, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("Runtime: " + (tContainer.mProgress > 0 ? tContainer.mProgress / 20 : 0) + "secs", 7, 152, 0xFAFAFF);
                    break;
                }
                case 2: {
                    this.field_146289_q.func_78276_b("Scanner", 51, 7, 0xFAFAFF);
                    if (tContainer.mProgress == 0) {
                        this.field_146289_q.func_78276_b("Can be used to", 51, 24, 0xFAFAFF);
                        this.field_146289_q.func_78276_b("scan things", 51, 32, 0xFAFAFF);
                        this.field_146289_q.func_78276_b("Currently", 51, 48, Utils.rgbtoHexValue(200, 20, 20));
                        this.field_146289_q.func_78276_b("Disabled", 51, 56, Utils.rgbtoHexValue(200, 20, 20));
                    } else {
                        this.field_146289_q.func_78276_b("Progress:", 51, 24, 0xFAFAFF);
                        this.field_146289_q.func_78276_b(MathUtils.findPercentage(tContainer.mProgress, tContainer.mMaxProgressTime) + " %", 51, 32, 0xFAFAFF);
                    }
                    this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
                    break;
                }
                case 3: {
                    this.field_146289_q.func_78276_b("Centrifuge", 7, 7, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("Recipe: " + (tContainer.mMaxHeat + 1) + "/" + GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.size(), 7, 23, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("EU: " + this.toNumber(tContainer.mEU), 7, 31, 0xFAFAFF);
                    break;
                }
                case 4: {
                    this.field_146289_q.func_78276_b("Fusionreactor", 7, 7, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("Recipe: " + (tContainer.mMaxHeat + 1) + "/" + GT_TileEntity_ComputerCube.sFusionReactorRecipes.size(), 7, 15, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("Start: " + this.toNumber(tContainer.mEU) + "EU", 7, 23, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("EU/t: " + this.toNumber(tContainer.mEUOut), 7, 31, 0xFAFAFF);
                    this.field_146289_q.func_78276_b(this.toNumber(tContainer.mHeat) + " Ticks", 7, 39, 0xFAFAFF);
                    GT_Recipe tRecipe = GT_TileEntity_ComputerCube.sFusionReactorRecipes.get(tContainer.mMaxHeat);
                    this.field_146289_q.func_78276_b("" + tRecipe.mFluidOutputs[0].getLocalizedName(), 7, 55, 0xFAFAFF);
                    if (tContainer.mEUOut < 0L) {
                        this.field_146289_q.func_78276_b("IN: " + this.toNumber(-tContainer.mEUOut * (long)tContainer.mHeat) + "EU", 7, 47, 0xFAFAFF);
                        break;
                    }
                    this.field_146289_q.func_78276_b("OUT: " + this.toNumber(tContainer.mEUOut * (long)tContainer.mHeat) + "EU", 7, 47, 0xFAFAFF);
                    break;
                }
                case 5: {
                    if (tContainer.mID == 5 && this.field_146999_f == 176) {
                        this.field_146999_f += 50;
                    }
                    if (tContainer.mMaxHeat < 0 || tContainer.mMaxHeat >= GT_Computercube_Description.sDescriptions.size()) break;
                    for (int i = 0; i < GT_Computercube_Description.sDescriptions.get((int)tContainer.mMaxHeat).mDescription.length; ++i) {
                        if (i == 0) {
                            this.field_146289_q.func_78276_b(GT_Computercube_Description.sDescriptions.get((int)tContainer.mMaxHeat).mDescription[i], 7, 7, 0xFAFAFF);
                            continue;
                        }
                        this.field_146289_q.func_78276_b(GT_Computercube_Description.sDescriptions.get((int)tContainer.mMaxHeat).mDescription[i], 7, 7 + 8 * i, 0xFAFAFF);
                    }
                    break;
                }
                case 6: {
                    this.field_146289_q.func_78276_b("Electrolyzer", 7, 7, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("Recipe: " + (tContainer.mMaxHeat + 1) + "/" + GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList.size(), 7, 23, 0xFAFAFF);
                    this.field_146289_q.func_78276_b("EU: " + this.toNumber(tContainer.mEU), 7, 31, 0xFAFAFF);
                }
            }
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        if (this.mContainer != null) {
            GT_Container_ComputerCube tContainer = (GT_Container_ComputerCube)this.mContainer;
            this.field_146297_k.field_71446_o.func_110577_a(mGUIbackground[((GT_Container_ComputerCube)this.mContainer).mID]);
            int x = (this.field_146294_l - this.field_146999_f) / 2;
            int y = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
            switch (tContainer.mID) {
                case 0: {
                    if (this.mPowerContainer.mStoredEU <= 0L || this.mPowerContainer.mMaxStoredEU <= 0L) break;
                    double tScale = MathUtils.findPercentage(this.mPowerContainer.mStoredEU, this.mPowerContainer.mMaxStoredEU);
                    this.func_73729_b(x + 44, y + 8, 0, 166, Math.min(MathUtils.roundToClosestInt(tScale), 95), 5);
                    break;
                }
                case 5: {
                    if (tContainer.mExplosionStrength == 0) break;
                    this.func_73729_b(x + 152, y + 6, 0, 166, 50, 50);
                }
            }
        }
    }

    public String toNumber(long mEU) {
        String tString = "";
        boolean temp = true;
        boolean negative = false;
        if (mEU < 0L) {
            mEU *= -1L;
            negative = true;
        }
        for (int i = 1000000000; i > 0; i /= 10) {
            long tDigit = mEU / (long)i % 10L;
            if (temp && tDigit != 0L) {
                temp = false;
            }
            if (temp) continue;
            tString = tString + tDigit;
            if (i == 1) continue;
            for (int j = i; j > 0; j /= 1000) {
                if (j != 1) continue;
                tString = tString + ",";
            }
        }
        if (tString.equals("")) {
            tString = "0";
        }
        return negative ? "-" + tString : tString;
    }

    static {
        GT_GUIContainer_ComputerCube.mGUIbackground[0] = new ResourceLocation("miscutils:textures/gui/computer/0.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[1] = new ResourceLocation("miscutils:textures/gui/computer/1.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[2] = new ResourceLocation("miscutils:textures/gui/computer/2.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[3] = new ResourceLocation("miscutils:textures/gui/computer/3.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[4] = new ResourceLocation("miscutils:textures/gui/computer/4.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[5] = new ResourceLocation("miscutils:textures/gui/computer/5.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[6] = new ResourceLocation("miscutils:textures/gui/computer/6.png");
        GT_GUIContainer_ComputerCube.mGUIbackground[7] = new ResourceLocation("miscutils:textures/gui/computer/Redstone.png");
    }
}

