/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.gui;

import gtPlusPlus.xmod.gregtech.api.gui.SyncedValueManager;

class SyncedLong {
    private final int index;
    private long value;
    private final short[] pieces = new short[4];
    private int received;
    private boolean dirty = true;

    SyncedLong(int index) {
        this.index = index;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        if (this.value != value) {
            this.dirty = true;
            this.value = value;
        }
    }

    void detectAndSendChanges(SyncedValueManager.SendChanges func, int timer) {
        if (this.dirty || (timer & 0xFF) == 0) {
            for (int i = 0; i < 4; ++i) {
                func.sendProgressBarUpdate(this.index + i, (int)(this.value >> 16 * i & 0xFFFFL));
            }
            this.dirty = false;
        }
    }

    private long getPiece(int index) {
        return (long)this.pieces[index] & 0xFFFFL;
    }

    boolean updateProgressBar(int short1, int short2) {
        int offset = short1 - this.index;
        if (offset >= 0 && offset < 4) {
            this.pieces[offset] = (short)short2;
            this.received |= 1 << offset;
            if (this.received == 15) {
                this.value = this.getPiece(0) | this.getPiece(1) << 16 | this.getPiece(2) << 32 | this.getPiece(3) << 48;
                this.received = 0;
            }
            return true;
        }
        return false;
    }
}

