/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.galacticraft.util;

import gregtech.api.enums.Materials;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.chemistry.RocketFuels;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraftforge.fluids.FluidStack;

public class GalacticUtils {
    private static final Class<?> aTieredRocket;
    private static final Class<?> aLandingPad;
    private static final Class<?> aBuggyPad;
    private static final Class<?> aIDockable;
    private static final Class<?> aIFuelable;
    private static final Method getRocketTier;
    private static final Method getRocket;
    private static final Method getBuggy;

    public static int getRocketTier(Entity aEntity) {
        if (aTieredRocket.isInstance(aEntity) && getRocketTier != null) {
            try {
                return (Integer)getRocketTier.invoke((Object)aEntity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getRocketTier(Object aEntity) {
        if (aIFuelable.isInstance(aEntity)) {
            if (aLandingPad.isInstance(aEntity)) {
                try {
                    Object rocket = getRocket.invoke(aLandingPad, new Object[0]);
                    if (aIDockable.isInstance(rocket) && rocket != null) {
                        return GalacticUtils.getRocketTier((Entity)rocket);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
            } else if (aBuggyPad.isInstance(aEntity)) {
                try {
                    Object buggy = getBuggy.invoke(aBuggyPad, new Object[0]);
                    if (aIDockable.isInstance(buggy) && buggy != null) {
                        return 0;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    public static boolean isFuelValidForTier(int aTier, FluidStack aFuel) {
        FluidStack aValidForThisTier = GalacticUtils.getValidFuelForTier(aTier);
        return aFuel.isFluidEqual(aValidForThisTier);
    }

    public static FluidStack getValidFuelForTier(Entity aEntity) {
        if (aTieredRocket.isInstance(aEntity)) {
            return GalacticUtils.getValidFuelForTier(GalacticUtils.getRocketTier(aEntity));
        }
        Logger.SPACE("Failed to get valid rocket fuel for " + aEntity.getClass().getCanonicalName());
        return GalacticUtils.getValidFuelForTier(0);
    }

    public static FluidStack getValidFuelForTier(int aTier) {
        if (aTier > 0 && aTier <= 2) {
            return FluidUtils.getFluidStack(RocketFuels.RP1_Plus_Liquid_Oxygen, 1000);
        }
        if (aTier >= 3 && aTier <= 5) {
            return FluidUtils.getFluidStack(RocketFuels.Dense_Hydrazine_Mix, 1000);
        }
        if (aTier >= 6 && aTier <= 7) {
            return FluidUtils.getFluidStack(RocketFuels.Monomethylhydrazine_Plus_Nitric_Acid, 1000);
        }
        if (aTier >= 8 && aTier <= 10) {
            return FluidUtils.getFluidStack(RocketFuels.Unsymmetrical_Dimethylhydrazine_Plus_Nitrogen_Tetroxide, 1000);
        }
        if (aTier == 0) {
            return Materials.Fuel.getFluid(1000L);
        }
        return null;
    }

    static {
        Method m3;
        Method m2;
        Method m1;
        Class<?> a5;
        Class<?> a4;
        Class<?> a3;
        Class<?> a2;
        Class<?> a1;
        try {
            a1 = ReflectionUtils.getClass("micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket");
            a2 = ReflectionUtils.getClass("micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad");
            a3 = ReflectionUtils.getClass("micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFueler");
            a4 = ReflectionUtils.getClass("micdoodle8.mods.galacticraft.api.entity.IDockable");
            a5 = ReflectionUtils.getClass("micdoodle8.mods.galacticraft.api.entity.IFuelable");
            m1 = ReflectionUtils.getMethod(a1, "getRocketTier", new Class[0]);
            m2 = ReflectionUtils.getMethod(a2, "getDockedEntity", new Class[0]);
            m3 = ReflectionUtils.getMethod(a3, "getDockedEntity", new Class[0]);
        }
        catch (Throwable t) {
            a1 = null;
            a2 = null;
            a3 = null;
            a4 = null;
            a5 = null;
            m1 = null;
            m2 = null;
            m3 = null;
        }
        aTieredRocket = a1;
        aLandingPad = a2;
        aBuggyPad = a3;
        aIDockable = a4;
        aIFuelable = a5;
        getRocketTier = m1;
        getRocket = m2;
        getBuggy = m3;
        if (a1 != null && a2 != null && a3 != null && a4 != null && a5 != null && m1 != null && m2 != null && m3 != null) {
            Logger.SPACE("Successfully relfected into 5 classes and 3 methods.");
        } else {
            Logger.SPACE("Failed to relfect into Galacticraft classes and methods.");
            if (a1 == null) {
                Logger.SPACE("micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket was null..");
            }
            if (a2 == null) {
                Logger.SPACE("micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad was null..");
            }
            if (a3 == null) {
                Logger.SPACE("micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFueler was null..");
            }
            if (a4 == null) {
                Logger.SPACE("micdoodle8.mods.galacticraft.api.entity.IDockable was null..");
            }
            if (a5 == null) {
                Logger.SPACE("micdoodle8.mods.galacticraft.api.entity.IFuelable was null..");
            }
            if (m1 == null) {
                Logger.SPACE("getRocketTier was null..");
            }
            if (m2 == null) {
                Logger.SPACE("getDockedEntity was null..");
            }
            if (m3 == null) {
                Logger.SPACE("getDockedEntity(buggy) was null..");
            }
        }
    }
}

