/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.villagers.entity;

import cpw.mods.fml.common.registry.VillagerRegistry;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.plugin.villagers.NameLists;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Tuple;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class EntityBaseVillager
extends EntityVillager {
    private final int mRoleID;

    public EntityBaseVillager(World aWorld) {
        this(aWorld, 0);
    }

    public EntityBaseVillager(World aWorld, int aID) {
        super(aWorld, aID);
        this.mRoleID = aID;
    }

    public void func_70014_b(NBTTagCompound aNBT) {
        if (this.func_94056_bM() && !aNBT.func_74764_b("aCustomName")) {
            aNBT.func_74778_a("aCustomName", this.func_70005_c_());
        }
        super.func_70014_b(aNBT);
    }

    public void func_70037_a(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("aCustomName") && !this.func_94057_bL().equals(aNBT.func_74779_i("aCustomName"))) {
            this.func_94058_c(aNBT.func_74779_i("aCustomName"));
        }
        super.func_70037_a(aNBT);
    }

    public void func_70109_d(NBTTagCompound aNBT) {
        super.func_70109_d(aNBT);
    }

    public void func_70020_e(NBTTagCompound aNBT) {
        super.func_70020_e(aNBT);
    }

    protected boolean func_70692_ba() {
        return !this.func_94056_bM();
    }

    public void func_70938_b(int p_70938_1_) {
        super.func_70938_b(p_70938_1_);
    }

    public int func_70946_n() {
        int prof = super.func_70946_n();
        return prof < 7735 ? 7738 : prof;
    }

    public void func_70933_a(MerchantRecipe p_70933_1_) {
        super.func_70933_a(p_70933_1_);
    }

    public void func_70930_a(MerchantRecipeList p_70930_1_) {
        super.func_70930_a(p_70930_1_);
    }

    public boolean shouldAlwaysSprint() {
        return false;
    }

    public void func_70636_d() {
        if (!this.func_94056_bM()) {
            this.func_94058_c(NameLists.generateRandomName());
        }
        super.func_70636_d();
        if (this.shouldAlwaysSprint()) {
            if (!this.func_70051_ag()) {
                this.func_70031_b(true);
            }
        } else if (this.func_70051_ag()) {
            this.func_70031_b(false);
        }
    }

    public Entity func_70777_m() {
        return super.func_70777_m();
    }

    public boolean func_94062_bN() {
        return this.func_94056_bM();
    }

    public Random func_70681_au() {
        return CORE.RANDOM;
    }

    public void func_70031_b(boolean bool) {
        super.func_70031_b(bool);
    }

    protected float getField_82191_bN() {
        Field v82191 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "field_82191_bN");
        try {
            return v82191 != null ? v82191.getFloat((Object)this) : 0.0f;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return 0.0f;
        }
    }

    protected void setField_82191_bN(float f) {
        try {
            ReflectionUtils.setField((Object)this, "field_82191_bN", (Object)Float.valueOf(f));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean getNeedsInitilization() {
        Field v82191 = ReflectionUtils.getField(EntityVillager.class, "needsInitilization");
        try {
            return v82191 != null ? v82191.getBoolean((Object)this) : false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return false;
        }
    }

    protected void setNeedsInitilization(boolean f) {
        try {
            ReflectionUtils.setField((Object)this, "needsInitilization", (Object)f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected MerchantRecipeList getBuyingList() {
        MerchantRecipeList o = null;
        Field v82191 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "buyingList");
        try {
            if (v82191 != null) {
                o = (MerchantRecipeList)v82191.get((Object)this);
            }
            Logger.WARNING("Is BuyingList Valid? " + (v82191 != null));
            return v82191 != null ? o : null;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setBuyingList(MerchantRecipeList f) {
        try {
            Logger.WARNING("set BuyingList? " + ReflectionUtils.setField((Object)this, "buyingList", (Object)f));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    protected Village getVillageObject() {
        Field v82191 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "villageObj");
        try {
            return v82191 != null ? (Village)v82191.get((Object)this) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }

    protected String getLastBuyingPlayer() {
        Field v82191 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "lastBuyingPlayer");
        try {
            return v82191 != null ? (String)v82191.get((Object)this) : "";
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return "";
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer p_70934_1_) {
        if (this.getBuyingList() == null) {
            this.addDefaultEquipmentAndRecipies(1);
        }
        return this.getBuyingList();
    }

    private float adjustProbability(float p_82188_1_) {
        float f1 = p_82188_1_ + this.getField_82191_bN();
        return f1 > 0.9f ? 0.9f - (f1 - 0.9f) : f1;
    }

    private void addDefaultEquipmentAndRecipies(int p_70950_1_) {
        if (this.getBuyingList() != null) {
            this.setField_82191_bN(MathHelper.func_76129_c((float)this.getBuyingList().size()) * 0.2f);
        } else {
            this.setField_82191_bN(0.0f);
        }
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        VillagerRegistry.manageVillagerTrades((MerchantRecipeList)merchantrecipelist, (EntityVillager)this, (int)this.func_70946_n(), (Random)this.field_70146_Z);
        switch (this.func_70946_n()) {
            case 0: {
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151015_O, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Item.func_150898_a((Block)Blocks.field_150325_L), this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151076_bf, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151101_aQ, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151025_P, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151127_ba, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151034_e, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151106_aX, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151097_aZ, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151033_d, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151077_bg, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151032_g, this.field_70146_Z, this.adjustProbability(0.5f));
                if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.5f))) break;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150351_n, 10), new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151145_ak, 4 + this.field_70146_Z.nextInt(2), 0)));
                break;
            }
            case 1: {
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151121_aF, this.field_70146_Z, this.adjustProbability(0.8f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151122_aG, this.field_70146_Z, this.adjustProbability(0.8f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151164_bB, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Item.func_150898_a((Block)Blocks.field_150342_X), this.field_70146_Z, this.adjustProbability(0.8f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Item.func_150898_a((Block)Blocks.field_150359_w), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151111_aL, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151113_aN, this.field_70146_Z, this.adjustProbability(0.2f));
                if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.07f))) break;
                Enchantment enchantment = Enchantment.field_92090_c[this.field_70146_Z.nextInt(Enchantment.field_92090_c.length)];
                int i1 = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
                ItemStack itemstack = Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, i1));
                int k = 2 + this.field_70146_Z.nextInt(5 + i1 * 10) + 3 * i1;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, k), itemstack));
                break;
            }
            case 2: {
                Item[] aitem;
                int k;
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151061_bv, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151062_by, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151137_ax, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Item.func_150898_a((Block)Blocks.field_150426_aN), this.field_70146_Z, this.adjustProbability(0.3f));
                Item[] aitem1 = aitem = new Item[]{Items.field_151040_l, Items.field_151048_u, Items.field_151030_Z, Items.field_151163_ad, Items.field_151036_c, Items.field_151056_x, Items.field_151035_b, Items.field_151046_w};
                int j = aitem.length;
                for (k = 0; k < j; ++k) {
                    Item item = aitem1[k];
                    if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.05f))) continue;
                    merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(item, 1, 0), new ItemStack(Items.field_151166_bC, 2 + this.field_70146_Z.nextInt(3), 0), EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)new ItemStack(item, 1, 0), (int)(5 + this.field_70146_Z.nextInt(15)))));
                }
                break;
            }
            case 3: {
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151042_j, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151043_k, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151045_i, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151040_l, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151048_u, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151036_c, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151056_x, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151035_b, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151046_w, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151037_a, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151047_v, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151019_K, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151012_L, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151167_ab, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151175_af, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151028_Y, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151161_ac, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151030_Z, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151163_ad, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151165_aa, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151173_ae, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151029_X, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151020_U, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151023_V, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151022_W, this.field_70146_Z, this.adjustProbability(0.1f));
                break;
            }
            case 4: {
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151147_al, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151082_bd, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151141_av, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151027_R, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151021_T, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151024_Q, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, (Item)Items.field_151026_S, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151157_am, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityBaseVillager.addEmeraldTrade(merchantrecipelist, Items.field_151083_be, this.field_70146_Z, this.adjustProbability(0.3f));
            }
        }
        if (merchantrecipelist.isEmpty()) {
            EntityBaseVillager.addPurchaseRecipe(merchantrecipelist, Items.field_151043_k, this.field_70146_Z, 1.0f);
        }
        Collections.shuffle(merchantrecipelist);
        if (this.getBuyingList() == null) {
            this.setBuyingList(new MerchantRecipeList());
        }
        for (int l = 0; l < p_70950_1_ && l < merchantrecipelist.size(); ++l) {
            try {
                this.getBuyingList().func_77205_a((MerchantRecipe)merchantrecipelist.get(l));
                continue;
            }
            catch (Throwable t) {
                Logger.INFO("Villager with ID " + this.field_96093_i.toString() + " at  |  X: " + this.field_70165_t + "   Y: " + this.field_70163_u + "   Z: " + this.field_70161_v + " may have corrupt trades, it is advised to remove/kill it.");
            }
        }
        try {
            if (this.getBuyingList() != null) {
                for (Object g : this.getBuyingList()) {
                    if (g == null) continue;
                    if (g instanceof MerchantRecipe) {
                        MerchantRecipe m = (MerchantRecipe)g;
                        ItemStack selling = m.func_77397_d();
                        ItemStack[] buying = new ItemStack[]{m.func_77394_a(), m.func_77396_b() != null ? m.func_77396_b() : null};
                        if (selling == null) {
                            Logger.WARNING("Villager is Selling an invalid item");
                            continue;
                        }
                        if (buying[0] == null && buying[1] == null) {
                            Logger.WARNING("Villager is buying two invalid items");
                            continue;
                        }
                        Logger.WARNING("Villager is Selling x" + selling.field_77994_a + selling.func_82833_r() + " for x" + buying[0].field_77994_a + " " + buying[0].func_82833_r() + buying[1] != null ? " and for x" + buying[1].field_77994_a + " " + buying[1].func_82833_r() : "");
                        continue;
                    }
                    Logger.WARNING("Found: " + g.getClass().getName());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void func_70629_bd() {
        if (!this.func_70940_q() && this.getNeedsInitilization()) {
            if (this.getBuyingList().size() > 1) {
                for (MerchantRecipe merchantrecipe : this.getBuyingList()) {
                    if (!merchantrecipe.func_82784_g()) continue;
                    merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                }
            }
            this.addDefaultEquipmentAndRecipies(1);
            this.setNeedsInitilization(false);
            if (this.getVillageObject() != null && this.getLastBuyingPlayer() != null) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                this.getVillageObject().func_82688_a(this.getLastBuyingPlayer(), 1);
            }
        }
        super.func_70629_bd();
    }

    public static void addEmeraldTrade(MerchantRecipeList aRecipeList, Item aItem, Random aRand, float aChance) {
        if (aRand.nextFloat() < aChance) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = EntityBaseVillager.getLootAmount_BlacksmithSellingList(aItem, aRand);
            if (i < 0) {
                itemstack = new ItemStack(Items.field_151166_bC, 1, 0);
                itemstack1 = new ItemStack(aItem, -i, 0);
            } else {
                itemstack = new ItemStack(Items.field_151166_bC, i, 0);
                itemstack1 = new ItemStack(aItem, 1, 0);
            }
            aRecipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    public static void addCustomTrade(MerchantRecipeList aRecipeList, ItemStack aItem1, ItemStack aItem2, ItemStack aItem3, Random aRand, float aChance) {
        if (aRand.nextFloat() < aChance) {
            aRecipeList.add((Object)new MerchantRecipe(aItem1, aItem2, aItem3));
        }
    }

    private static int getLootAmount_BlacksmithSellingList(Item aItem, Random aRand) {
        Tuple tuple = (Tuple)field_70960_bC.get(aItem);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + aRand.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }

    public static void addPurchaseRecipe(MerchantRecipeList aTradeList, Item aItem, Random aRand, float aChance) {
        if (aRand.nextFloat() < aChance) {
            aTradeList.add((Object)new MerchantRecipe(EntityBaseVillager.getSimpleLootStack(aItem, aRand), Items.field_151166_bC));
        }
    }

    private static ItemStack getSimpleLootStack(Item aItem, Random aRand) {
        return new ItemStack(aItem, EntityBaseVillager.getLootAmount_VillagerSellingList(aItem, aRand), 0);
    }

    public static void addPurchaseRecipe(MerchantRecipeList aTradeList, Item aItem, int aMeta, Random aRand, float aChance) {
        if (aRand.nextFloat() < aChance) {
            aTradeList.add((Object)new MerchantRecipe(EntityBaseVillager.getComplexLootStack(aItem, aMeta, aRand), Items.field_151166_bC));
        }
    }

    private static ItemStack getComplexLootStack(Item aItem, int aMeta, Random aRand) {
        return new ItemStack(aItem, EntityBaseVillager.getLootAmount_VillagerSellingList(aItem, aRand), aMeta);
    }

    private static int getLootAmount_VillagerSellingList(Item aItem, Random aRand) {
        Tuple tuple = (Tuple)field_70958_bB.get(aItem);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + aRand.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }
}

