/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.villagers;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gtPlusPlus.api.interfaces.IPlugin;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.plugin.manager.Core_Manager;
import gtPlusPlus.plugin.villagers.VillagerObject;
import gtPlusPlus.plugin.villagers.VillagerUtils;
import gtPlusPlus.plugin.villagers.entity.EntityBaseVillager;
import gtPlusPlus.plugin.villagers.entity.EntityNativeAustralian;
import gtPlusPlus.plugin.villagers.trade.TradeHandlerAboriginal;
import gtPlusPlus.plugin.villagers.trade.TradeHandlerBanker;
import gtPlusPlus.plugin.villagers.trade.TradeHandlerTechnician;
import gtPlusPlus.plugin.villagers.trade.TradeHandlerTrader;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;

public class Core_VillagerAdditions
implements IPlugin {
    public static final Core_VillagerAdditions mInstance;
    private static boolean shouldLoad;
    public static final HashMap<Integer, ResourceLocation> mVillagerSkins;
    public static final AutoMap<Pair<Integer, VillagerRegistry.IVillageTradeHandler>> mVillagerTrades;

    @Override
    public boolean preInit() {
        if (CORE.DEVENV) {
            shouldLoad = true;
        }
        if (shouldLoad) {
            EntityRegistry.registerGlobalEntityID(EntityBaseVillager.class, (String)"WiseVillager", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Utils.rgbtoHexValue(180, 120, 120), (int)Utils.rgbtoHexValue(0, 0, 0));
            EntityRegistry.registerGlobalEntityID(EntityNativeAustralian.class, (String)"Aboriginal", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)Utils.rgbtoHexValue(50, 50, 50), (int)Utils.rgbtoHexValue(25, 25, 25));
            VillagerUtils.registerNewVillager(0, "Banker", "Banker", "Banker", "banker", new TradeHandlerBanker());
            VillagerUtils.registerNewVillager(1, "Technician", "Technician", "Technician", "technician", new TradeHandlerTechnician());
            VillagerUtils.registerNewVillager(2, "Trader", "Trader", "Trader", "trader", new TradeHandlerTrader());
            VillagerUtils.registerNewVillager(3, "Aboriginal", "Aboriginal", "Aboriginal", "aboriginal", new TradeHandlerAboriginal());
            if (VillagerUtils.mVillagerMap.size() > 0) {
                for (VillagerObject villagerObject : VillagerUtils.mVillagerMap.values()) {
                    if (villagerObject == null || villagerObject.mID < 0) continue;
                    VillagerRegistry.instance().registerVillagerId(7735 + villagerObject.mID);
                    this.log("Registered a Custom Villager with ID of " + villagerObject.mID + ".");
                    if (mVillagerSkins.get(villagerObject.mID) == null) continue;
                    VillagerRegistry.instance().registerVillagerSkin(7735 + villagerObject.mID, mVillagerSkins.get(villagerObject.mID));
                    this.log("Registered a Custom Skin for Villager with ID of " + villagerObject.mID + ".");
                }
            }
            if (mVillagerTrades.size() > 0) {
                for (Pair pair : mVillagerTrades) {
                    if (pair == null || pair.getKey() == null || pair.getValue() == null) continue;
                    VillagerRegistry.instance().registerVillageTradeHandler(((Integer)pair.getKey()).intValue(), (VillagerRegistry.IVillageTradeHandler)pair.getValue());
                    this.log("Registered a Custom Trade for Villager with ID of " + pair.getKey() + ".");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean init() {
        return shouldLoad;
    }

    @Override
    public boolean postInit() {
        return shouldLoad;
    }

    @Override
    public boolean serverStart() {
        return shouldLoad;
    }

    @Override
    public boolean serverStop() {
        return shouldLoad;
    }

    @Override
    public String getPluginName() {
        return "GT++ Enhanced Villagers";
    }

    @Override
    public String getPluginAbbreviation() {
        return "Bank";
    }

    static {
        shouldLoad = false;
        mVillagerSkins = new HashMap();
        mVillagerTrades = new AutoMap();
        mInstance = new Core_VillagerAdditions();
        Core_Manager.registerPlugin(mInstance);
        mInstance.log("Preparing " + mInstance.getPluginName() + " for use.");
    }
}

