/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.network.CustomPacket;
import gtPlusPlus.core.util.minecraft.network.PacketHandler;
import gtPlusPlus.preloader.DevHelper;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.WorldServer;

public class PacketDispatcher {
    private static final Class playerInstanceClass;
    private static final Method getOrCreateChunkWatcher;
    private static final Method sendToAllPlayersWatchingChunk;

    public static void sendToServer(CustomPacket packet) {
        PacketHandler.INSTANCE.channel.sendToServer(packet.getPacket());
    }

    public static void sendToPlayer(CustomPacket packet, EntityPlayerMP player) {
        PacketHandler.INSTANCE.channel.sendTo(packet.getPacket(), player);
    }

    public static void sendToAll(CustomPacket packet) {
        PacketHandler.INSTANCE.channel.sendToAll(packet.getPacket());
    }

    public static void sendToAllAround(CustomPacket packet, NetworkRegistry.TargetPoint zone) {
        PacketHandler.INSTANCE.channel.sendToAllAround(packet.getPacket(), zone);
    }

    public static void sendToDimension(CustomPacket packet, int dimensionId) {
        PacketHandler.INSTANCE.channel.sendToDimension(packet.getPacket(), dimensionId);
    }

    public static void sendToWatchers(CustomPacket packet, WorldServer world, int worldX, int worldZ) {
        try {
            Object playerInstance = getOrCreateChunkWatcher.invoke((Object)world.func_73040_p(), worldX >> 4, worldZ >> 4, false);
            if (playerInstance != null) {
                sendToAllPlayersWatchingChunk.invoke(playerInstance, packet.getPacket());
            }
        }
        catch (Exception var5) {
            Logger.ERROR("Reflection Failure in PacketDispatcher.sendToWatchers() {0} {1}20" + var5 + new Object[]{getOrCreateChunkWatcher.getName() + sendToAllPlayersWatchingChunk.getName()});
            throw new RuntimeException(var5);
        }
    }

    static {
        try {
            Method b;
            Method a;
            playerInstanceClass = PlayerManager.class.getDeclaredClasses()[0];
            try {
                a = DevHelper.getForgeMethod(PlayerManager.class, "getOrCreateChunkWatcher", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            catch (Throwable t) {
                a = ReflectionHelper.findMethod((Class)playerInstanceClass, null, (String[])new String[]{"func_72690_a", "getOrCreateChunkWatcher"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
            }
            try {
                b = DevHelper.getForgeMethod(PlayerManager.class, "sendToAllPlayersWatchingChunk", Packet.class);
            }
            catch (Throwable t) {
                b = ReflectionHelper.findMethod((Class)playerInstanceClass, null, (String[])new String[]{"func_151251_a", "sendToAllPlayersWatchingChunk"}, (Class[])new Class[]{Packet.class});
            }
            getOrCreateChunkWatcher = a;
            sendToAllPlayersWatchingChunk = b;
            getOrCreateChunkWatcher.setAccessible(true);
            sendToAllPlayersWatchingChunk.setAccessible(true);
        }
        catch (Exception var1) {
            Logger.ERROR("Reflection Failure in PacketDispatcher initalization {0} {1}" + var1);
            throw new RuntimeException(var1);
        }
    }
}

