/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.base;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_Block_Event;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gtPlusPlus.api.interfaces.ILazyCoverable;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BTF_Inventory;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import ic2.api.Direction;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBase
extends TileEntity
implements ILazyCoverable,
IGregTechDeviceInformation,
IDescribable {
    private String customName;
    public String mOwnerName = "null";
    public String mOwnerUUID = "null";
    private boolean mIsOwnerOP = false;
    public final BTF_Inventory mInventory;
    private final GT_CoverBehavior[] mCoverBehaviors = new GT_CoverBehavior[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    protected TileEntityBase mMetaTileEntity;
    protected long mStoredEnergy = 0L;
    protected int mAverageEUInputIndex = 0;
    protected int mAverageEUOutputIndex = 0;
    protected boolean mReleaseEnergy = false;
    protected int[] mAverageEUInput = new int[11];
    protected int[] mAverageEUOutput = new int[11];
    private boolean[] mActiveEUInputs = new boolean[]{false, false, false, false, false, false};
    private boolean[] mActiveEUOutputs = new boolean[]{false, false, false, false, false, false};
    private byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    private int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mCoverData = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mTimeStatistics = new int[GregTech_API.TICKS_FOR_LAG_AVERAGING];
    private boolean mHasEnoughEnergy = true;
    protected boolean mRunningThroughTick = false;
    protected boolean mInputDisabled = false;
    protected boolean mOutputDisabled = false;
    private boolean mMuffler = false;
    private boolean mLockUpgrade = false;
    private boolean mActive = false;
    private boolean mRedstone = false;
    private boolean mWorkUpdate = false;
    private boolean mSteamConverter = false;
    private boolean mInventoryChanged = false;
    private boolean mWorks = true;
    private boolean mNeedsUpdate = true;
    private boolean mNeedsBlockUpdate = true;
    private boolean mSendClientData = false;
    private boolean oRedstone = false;
    private boolean mEnergyStateReady = false;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte mStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte oTexturePage = 0;
    private byte oLightValueClient = (byte)-1;
    private byte oLightValue = (byte)-1;
    private byte mLightValue = 0;
    private byte mOtherUpgrades = 0;
    private byte mFacing = 0;
    private byte oFacing = 0;
    private byte mWorkData = 0;
    private int mDisplayErrorCode = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    private int mLagWarningCount = 0;
    private short mID = 0;
    protected long mTickTimer = 0L;
    private long oOutput = 0L;
    private long mAcceptedAmperes = Long.MAX_VALUE;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    private boolean firstTicked = false;

    public TileEntityBase(int aCapacity) {
        this.mInventory = new BTF_Inventory(aCapacity, this);
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        nbt.func_74757_a("mIsOwnerOP", this.mIsOwnerOP);
        nbt.func_74778_a("mOwnerName", this.mOwnerName);
        nbt.func_74778_a("mOwnerUUID", this.mOwnerUUID);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
        this.mIsOwnerOP = nbt.func_74767_n("mIsOwnerOP");
        this.mOwnerName = nbt.func_74779_i("mOwnerName");
        this.mOwnerUUID = nbt.func_74779_i("mOwnerUUID");
    }

    public void func_145845_h() {
        long aTick = System.currentTimeMillis();
        this.isDead = false;
        if (!this.firstTicked) {
            this.onFirstTick();
        }
        try {
            if (this.isServerSide()) {
                this.onPreTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's pre-tick stage.");
            t.printStackTrace();
        }
        try {
            if (this.isServerSide()) {
                this.onTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's tick stage.");
            t.printStackTrace();
        }
        try {
            if (this.isServerSide()) {
                this.onPostTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's post-tick stage.");
            t.printStackTrace();
        }
    }

    public boolean onPreTick(long aTick) {
        return true;
    }

    public boolean onTick(long aTick) {
        try {
            if (this.isServerSide()) {
                this.processRecipe();
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's processing of a recipe stage.");
            t.printStackTrace();
        }
        return true;
    }

    public boolean onPostTick(long aTick) {
        return true;
    }

    public boolean processRecipe() {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public String getOwner() {
        if (this.mOwnerName == null) {
            return "null";
        }
        return this.mOwnerName;
    }

    public UUID getOwnerUUID() {
        return UUID.fromString(this.mOwnerUUID);
    }

    public boolean isOwnerOP() {
        return this.mIsOwnerOP;
    }

    public void setOwnerInformation(String mName, String mUUID, boolean mOP) {
        if (this.isServerSide() && (this.mOwnerName == null || this.mOwnerUUID == null || this.mOwnerName.equals("null") || this.mOwnerUUID.equals("null"))) {
            this.mOwnerName = mName;
            this.mOwnerUUID = mUUID;
            this.mIsOwnerOP = mOP;
        }
    }

    public boolean isServerSide() {
        return this.func_145830_o() && !this.func_145831_w().field_72995_K;
    }

    public final boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.tileentity.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public int func_70302_i_() {
        return this.mInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int aIndex) {
        return this.mInventory.func_70301_a(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mInventory.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return this.mInventory.func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.mInventory.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public int func_70297_j_() {
        return this.mInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.mInventory.func_70300_a(p_70300_1_);
    }

    public void func_70295_k_() {
        this.mInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.mInventory.func_70305_f();
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mInventory.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int aSide) {
        if (this.canAccessData() && (this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, (ICoverable)this) || this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, (ICoverable)this))) {
            return this.mInventory.func_94128_d(aSide);
        }
        return new int[0];
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, (ICoverable)this) && this.mInventory.func_102007_a(aIndex, aStack, aSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, (ICoverable)this) && this.mInventory.func_102008_b(aIndex, aStack, aSide);
    }

    public boolean isValidSlot(int aIndex) {
        return this.canAccessData() ? this.mInventory.isValidSlot(aIndex) : false;
    }

    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    protected final boolean canAccessData() {
        return !this.isDead() && !this.func_145837_r();
    }

    public void issueBlockUpdate() {
        super.func_70296_d();
    }

    public void issueCoverUpdate(byte aSide) {
        this.issueClientUpdate();
    }

    public void receiveCoverData(byte coverSide, int coverID, int coverData) {
        if (coverSide >= 0 && coverSide < 6 && this.mCoverSides[coverSide] == coverID) {
            this.setCoverDataAtSide(coverSide, coverData);
        }
    }

    public long getTimer() {
        return this.mTickTimer;
    }

    public long getOutputAmperage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxAmperesOut() : 0L;
    }

    public long getOutputVoltage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput() ? this.mMetaTileEntity.maxEUOutput() : 0L;
    }

    public long getInputAmperage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxAmperesIn() : 0L;
    }

    public long getInputVoltage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxEUInput() : Integer.MAX_VALUE;
    }

    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return !this.canAccessData() ? false : (this.mHasEnoughEnergy = this.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy));
    }

    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.getStoredEU() >= this.getEUCapacity() && !aIgnoreTooMuchEnergy) {
            return false;
        }
        this.setStoredEU(this.mMetaTileEntity.getEUVar() + aEnergy);
        return true;
    }

    public boolean inputEnergyFrom(byte aSide) {
        return aSide == 6 ? true : (!this.isServerSide() ? this.isEnergyInputSide(aSide) : aSide >= 0 && aSide < 6 && this.mActiveEUInputs[aSide] && !this.mReleaseEnergy);
    }

    public boolean outputsEnergyTo(byte aSide) {
        return aSide == 6 ? true : (!this.isServerSide() ? this.isEnergyOutputSide(aSide) : aSide >= 0 && aSide < 6 && this.mActiveEUOutputs[aSide] || this.mReleaseEnergy);
    }

    private boolean isEnergyInputSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (!this.getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), (ICoverable)this)) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return false;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetInput()) {
                return this.mMetaTileEntity.isInputFacing(aSide);
            }
        }
        return false;
    }

    private boolean isEnergyOutputSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (!this.getCoverBehaviorAtSide(aSide).letsEnergyOut(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), (ICoverable)this)) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return this.mReleaseEnergy;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
                return this.mMetaTileEntity.isOutputFacing(aSide);
            }
        }
        return false;
    }

    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return false;
    }

    private final void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            this.mBufferedTileEntities[i] = null;
        }
    }

    public final World getWorld() {
        return this.field_145850_b;
    }

    public final int getXCoord() {
        return this.field_145851_c;
    }

    public final short getYCoord() {
        return (short)this.field_145848_d;
    }

    public final int getZCoord() {
        return this.field_145849_e;
    }

    public final int getOffsetX(byte aSide, int aMultiplier) {
        return this.field_145851_c + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    public final short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.field_145848_d + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    public final int getOffsetZ(byte aSide, int aMultiplier) {
        return this.field_145849_e + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    public final boolean openGUI(EntityPlayer aPlayer) {
        return this.openGUI(aPlayer, 0);
    }

    public final boolean openGUI(EntityPlayer aPlayer, int aID) {
        if (aPlayer == null) {
            return false;
        }
        aPlayer.openGui((Object)GT_Values.GT, aID, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public final int getRandomNumber(int aRange) {
        return this.field_145850_b.field_73012_v.nextInt(aRange);
    }

    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    public final Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getMetaIDAtSide(byte aSide) {
        return this.getMetaIDAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getMetaIDAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaID(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    public final byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    public final boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    public final boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    public final boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        return aDistance == 1 ? this.getTileEntityAtSide(aSide) : this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final IInventory getIInventory(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IInventory getIInventoryAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IInventory getIInventoryAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    public final IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    public final IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    public final IFluidHandler getITankContainerAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    public final IFluidHandler getITankContainerAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    public final Block getBlock(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? Blocks.field_150350_a : this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    @Override
    public final byte getMetaID(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? (byte)0 : (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    public final byte getLightLevel(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? (byte)0 : (byte)(this.field_145850_b.func_72801_o(aX, aY, aZ) * 15.0f);
    }

    public final boolean getSky(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? true : this.field_145850_b.func_72937_j(aX, aY, aZ);
    }

    public final boolean getOpacity(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? false : GT_Utility.isOpaqueBlock((World)this.field_145850_b, (int)aX, (int)aY, (int)aZ);
    }

    public final boolean getAir(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? true : GT_Utility.isBlockAir((World)this.field_145850_b, (int)aX, (int)aY, (int)aZ);
    }

    public final TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? null : this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    public final TileEntity getTileEntityAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6 && this.mBufferedTileEntities[aSide] != this) {
            int tX = this.getOffsetX(aSide, 1);
            short tY = this.getOffsetY(aSide, 1);
            int tZ = this.getOffsetZ(aSide, 1);
            if (this.crossedChunkBorder(tX, tZ)) {
                this.mBufferedTileEntities[aSide] = null;
                if (this.ignoreUnloadedChunks && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ)) {
                    return null;
                }
            }
            if (this.mBufferedTileEntities[aSide] == null) {
                this.mBufferedTileEntities[aSide] = this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
                if (this.mBufferedTileEntities[aSide] == null) {
                    this.mBufferedTileEntities[aSide] = this;
                    return null;
                }
                return this.mBufferedTileEntities[aSide];
            }
            if (this.mBufferedTileEntities[aSide].func_145837_r()) {
                this.mBufferedTileEntities[aSide] = null;
                return this.getTileEntityAtSide(aSide);
            }
            return this.mBufferedTileEntities[aSide].field_145851_c == tX && this.mBufferedTileEntities[aSide].field_145848_d == tY && this.mBufferedTileEntities[aSide].field_145849_e == tZ ? this.mBufferedTileEntities[aSide] : null;
        }
        return null;
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void func_145829_t() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public final void onAdjacentBlockChange(int aX, int aY, int aZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    public final void sendBlockEvent(byte aID, byte aValue) {
        GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, (GT_Packet)new GT_Packet_Block_Event(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    private boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }

    public final void setOnFire() {
        GT_Utility.setCoordsOnFire((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (boolean)false);
    }

    public final void setToFire() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization((String)("Interaction_DESCRIPTION_Index_" + aKey), (String)aEnglish, (boolean)false);
    }

    public byte getInternalInputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSide(aSide).getRedstoneInput(aSide, this.getInputRedstoneSignal(aSide), this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), (ICoverable)this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(byte aSide) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(aSide, 1), (int)this.getOffsetY(aSide, 1), this.getOffsetZ(aSide, 1), (int)aSide) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(byte aSide) {
        return this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), (ICoverable)this) ? this.mSidedRedstone[aSide] : this.getGeneralRS(aSide);
    }

    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    public byte getGeneralRS(byte aSide) {
        return this.allowGeneralRedstoneOutput() ? this.mSidedRedstone[aSide] : (byte)0;
    }

    public void setInternalOutputRedstoneSignal(byte aSide, byte aStrength) {
        if (!this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), (ICoverable)this)) {
            this.setOutputRedstoneSignal(aSide, aStrength);
        }
    }

    @Override
    public void setOutputRedstoneSignal(byte aSide, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (aSide >= 0 && aSide < 6 && this.mSidedRedstone[aSide] != aStrength) {
            this.mSidedRedstone[aSide] = aStrength;
            this.issueBlockUpdate();
        }
    }

    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        return aSide >= 0 && aSide < this.mCoverBehaviors.length ? this.mCoverBehaviors[aSide] : GregTech_API.sNoBehavior;
    }

    public void setCoverIDAtSide(byte aSide, int aID) {
        if (this.setCoverIDAtSideNoUpdate(aSide, aID)) {
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    public boolean setCoverIDAtSideNoUpdate(byte aSide, int aID) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverSides[aSide] = aID;
            this.mCoverData[aSide] = 0;
            this.mCoverBehaviors[aSide] = GregTech_API.getCoverBehavior((int)aID);
            return true;
        }
        return false;
    }

    public void setCoverIdAndDataAtSide(byte aSide, int aId, ISerializableObject aData) {
        this.setCoverIDAtSide(aSide, aId);
        this.setCoverDataAtSide(aSide, aData);
    }

    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehavior((ItemStack)aCover).placeCover(aSide, aCover, (ICoverable)this);
    }

    public int getCoverIDAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverSides[aSide];
        }
        return 0;
    }

    public ItemStack getCoverItemAtSide(byte aSide) {
        return GT_Utility.intToStack((int)this.getCoverIDAtSide(aSide));
    }

    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    public void setCoverDataAtSide(byte aSide, int aData) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverData[aSide] = aData;
        }
    }

    public int getCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverData[aSide];
        }
        return 0;
    }

    public byte getLightValue() {
        return this.mLightValue;
    }

    @Override
    public void setLightValue(byte aLightValue) {
        this.mLightValue = (byte)(aLightValue & 0xF);
    }

    public long getAverageElectricInput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUInput.length; ++i) {
            if (i == this.mAverageEUInputIndex) continue;
            rEU += this.mAverageEUInput[i];
        }
        return rEU / (this.mAverageEUInput.length - 1);
    }

    public long getAverageElectricOutput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUOutput.length; ++i) {
            if (i == this.mAverageEUOutputIndex) continue;
            rEU += this.mAverageEUOutput[i];
        }
        return rEU / (this.mAverageEUOutput.length - 1);
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return false;
    }

    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSide(aSide).onCoverRemoval(aSide, this.getCoverIDAtSide(aSide), this.mCoverData[aSide], (ICoverable)this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSide(aSide).getDrop(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), (ICoverable)this);
            if (tStack != null) {
                tStack.func_77982_d(null);
                EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
                tEntity.field_70159_w = 0.0;
                tEntity.field_70181_x = 0.0;
                tEntity.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)tEntity);
            }
            this.setCoverIDAtSide(aSide, 0);
            if (this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                this.setOutputRedstoneSignal(aSide, (byte)0);
            } else {
                this.setOutputRedstoneSignal(aSide, (byte)15);
            }
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        if (GT_Utility.isStringInvalid((Object)this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    public String setOwnerName(String aName) {
        if (GT_Utility.isStringInvalid((Object)aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(aSide) : (byte)0;
    }

    @Override
    public byte getStrongOutputRedstoneSignal(byte aSide) {
        return aSide >= 0 && aSide < 6 && (this.mStrongRedstone & 1 << aSide) != 0 ? (byte)(this.mSidedRedstone[aSide] & 0xF) : (byte)0;
    }

    @Override
    public void setStrongOutputRedstoneSignal(byte aSide, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << aSide);
        this.setOutputRedstoneSignal(aSide, aStrength);
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(aSide) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() > this.mAcceptedAmperes)) {
            return 0L;
        }
        if (aVoltage > this.getInputVoltage()) {
            this.doExplosion(aVoltage);
            return 0L;
        }
        if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.mMetaTileEntity.maxAmperesIn() - this.mAcceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
            int n = this.mAverageEUInputIndex;
            this.mAverageEUInput[n] = (int)((long)this.mAverageEUInput[n] + aVoltage * aAmperage);
            this.mAcceptedAmperes += aAmperage;
            return aAmperage;
        }
        return 0L;
    }

    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(aSide) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU())) {
            return false;
        }
        if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
            int n = this.mAverageEUOutputIndex;
            this.mAverageEUOutput[n] = (int)((long)this.mAverageEUOutput[n] + aVoltage * aAmperage);
            return true;
        }
        return false;
    }

    public double getOutputEnergyUnitsPerTick() {
        return this.oOutput;
    }

    public boolean isTeleporterCompatible(ForgeDirection aSide) {
        return false;
    }

    public double demandedEnergyUnits() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0.0;
        }
        return this.getEUCapacity() - this.getStoredEU();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return this.injectEnergyUnits((byte)aDirection.ordinal(), (int)aAmount, 1L) > 0L ? 0.0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return this.inputEnergyFrom((byte)aDirection.ordinal());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return this.outputsEnergyTo((byte)aDirection.ordinal());
    }

    public double getOfferedEnergy() {
        return this.canAccessData() && this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU() >= this.oOutput ? (double)Math.max(0L, this.oOutput) : 0.0;
    }

    public void drawEnergy(double amount) {
        int n = this.mAverageEUOutputIndex;
        this.mAverageEUOutput[n] = (int)((double)this.mAverageEUOutput[n] + amount);
        this.decreaseStoredEU((int)amount, true);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return this.injectEnergyUnits((byte)aForgeDirection.ordinal(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public int addEnergy(int aEnergy) {
        if (!this.canAccessData()) {
            return 0;
        }
        if (aEnergy > 0) {
            this.increaseStoredEnergyUnits(aEnergy, true);
        } else {
            this.decreaseStoredEU(-aEnergy, true);
        }
        return (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getEUVar());
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0;
        }
        return this.getCapacity() - this.getStored();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity());
    }

    public int getStored() {
        return (int)Math.min(Integer.MAX_VALUE, Math.min(this.getStoredEU(), (long)this.getCapacity()));
    }

    public void setStored(int aEU) {
        if (this.canAccessData()) {
            this.setStoredEU(aEU);
        }
    }

    public int getMaxSafeInput() {
        return (int)Math.min(Integer.MAX_VALUE, this.getInputVoltage());
    }

    public int getMaxEnergyOutput() {
        if (this.mReleaseEnergy) {
            return Integer.MAX_VALUE;
        }
        return this.getOutput();
    }

    public int getOutput() {
        return (int)Math.min(Integer.MAX_VALUE, this.oOutput);
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return this.injectEnergyUnits((byte)aDirection.toSideValue(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aReceiver, Direction aDirection) {
        return this.inputEnergyFrom((byte)aDirection.toSideValue());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, Direction aDirection) {
        return this.outputsEnergyTo((byte)aDirection.toSideValue());
    }

    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (GT_Utility.isStackInvalid((Object)tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)tStack, (ItemStack)(aStack = GT_OreDictUnificator.get((ItemStack)aStack))) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(aStack.func_77976_d(), this.func_70297_j_())) {
            tStack.field_77994_a += aStack.field_77994_a;
            return true;
        }
        return false;
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{aStack}));
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public void doEnergyExplosion() {
        if (this.getUniversalEnergyCapacity() > 0L && this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 5L) {
            this.doExplosion(this.oOutput * (long)(this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() ? 4 : (this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 2L ? 2 : 1)));
            GT_Mod arg9999 = GT_Mod.instance;
            GT_Mod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "electricproblems");
        }
    }

    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            if (GregTech_API.sMachineWireFire && this.mMetaTileEntity.isElectric()) {
                try {
                    this.mReleaseEnergy = true;
                    IEnergyConnected.Util.emitEnergyToNetwork((long)GT_Values.V[5], (long)Math.max(1L, this.getStoredEU() / GT_Values.V[5]), (IEnergyConnected)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mReleaseEnergy = false;
            this.onExplosion();
            PollutionUtils.addPollution((IHasWorldObjectAndCoords)this, 100000);
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    public void onExplosion() {
    }

    public String[] getDescription() {
        return this.canAccessData() ? this.mMetaTileEntity.getDescription() : new String[]{};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return null;
    }

    public long getEUVar() {
        return this.mStoredEnergy;
    }

    public void setEUVar(long aEnergy) {
        this.mStoredEnergy = aEnergy;
    }

    public long getStoredEU() {
        return this.canAccessData() ? Math.min(this.mMetaTileEntity.getEUVar(), this.getEUCapacity()) : 0L;
    }

    public long getEUCapacity() {
        return this.canAccessData() ? this.mMetaTileEntity.maxEUStore() : 0L;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public boolean setStoredEU(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setEUVar(aEnergy);
        return true;
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getEUVar() - aEnergy < 0L && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setStoredEU(this.mMetaTileEntity.getEUVar() - aEnergy);
        if (this.mMetaTileEntity.getEUVar() < 0L) {
            this.setStoredEU(0L);
            return false;
        }
        return true;
    }

    public boolean energyStateReady() {
        return false;
    }

    public boolean onFirstTick() {
        if (!this.firstTicked) {
            this.firstTicked = true;
            if (this.mInventory != null) {
                this.mInventory.purgeNulls();
                return true;
            }
        }
        return false;
    }

    public boolean inputEnergyFrom(byte arg0, boolean arg1) {
        return false;
    }

    public boolean outputsEnergyTo(byte arg0, boolean arg1) {
        return false;
    }
}

