/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.base;

import gregtech.api.interfaces.tileentity.ICoverable;
import gtPlusPlus.api.objects.minecraft.BTF_FluidTank;
import gtPlusPlus.core.tileentities.base.TileEntityBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileBasicTank
extends TileEntityBase
implements IFluidHandler,
IFluidTank {
    public final BTF_FluidTank mTank;

    public TileBasicTank(int aMaxSlots, int aFluidCapacity) {
        super(aMaxSlots);
        this.mTank = new BTF_FluidTank(aFluidCapacity);
    }

    @Override
    public boolean onPreTick(long aTick) {
        if (this.isServerSide() && this.mTank.isFluidChangingAllowed() && this.mTank.getFillableStack() != null && this.mTank.getFillableStack().amount <= 0) {
            this.mTank.setFillableStack(null);
        }
        return super.onPreTick(aTick);
    }

    private final boolean canFillEx(ForgeDirection aSide, Fluid aFluid) {
        return this.fill(aSide, new FluidStack(aFluid, 1), false) == 1;
    }

    private final boolean canDrainEx(ForgeDirection aSide, Fluid aFluid) {
        return this.drain(aSide, new FluidStack(aFluid, 1), false) != null;
    }

    private final FluidTankInfo[] getTankInfoEx(ForgeDirection aSide) {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.mTank.getCapacity() <= 0) {
            fluidTankInfoArray = new FluidTankInfo[]{};
        } else {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.mTank.getInfo();
        }
        return fluidTankInfoArray;
    }

    private final int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return this.mTank.fill(aFluid, doFill);
    }

    private final int fillEx(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return this.fill_default(aSide, aFluid, doFill);
    }

    private final FluidStack drainEx(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        return this.mTank.getFluid() != null && aFluid != null && this.mTank.getFluid().isFluidEqual(aFluid) ? this.mTank.drain(aFluid.amount, doDrain) : null;
    }

    private final FluidStack drainEx(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        return this.mTank.drain(maxDrain, doDrain);
    }

    public boolean isLiquidInput(byte aSide) {
        return true;
    }

    public boolean isLiquidOutput(byte aSide) {
        return true;
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid == null ? null : aFluid.getFluid(), (ICoverable)this))) {
            return this.fillEx(aSide, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), this.getFluid() == null ? null : this.getFluid().getFluid(), (ICoverable)this))) {
            return this.drainEx(aSide, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid == null ? null : aFluid.getFluid(), (ICoverable)this))) {
            return this.drainEx(aSide, aFluid, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, (ICoverable)this))) {
            return this.canFillEx(aSide, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, (ICoverable)this))) {
            return this.canDrainEx(aSide, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.canAccessData() && (aSide == ForgeDirection.UNKNOWN || this.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, (ICoverable)this) || this.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, (ICoverable)this))) {
            return this.getTankInfoEx(aSide);
        }
        return new FluidTankInfo[0];
    }

    public FluidStack getFluid() {
        return this.mTank.getFluid();
    }

    public int getFluidAmount() {
        return this.mTank.getFluidAmount();
    }

    public FluidTankInfo getInfo() {
        return this.mTank.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.mTank.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.mTank.drain(maxDrain, doDrain);
    }
}

