/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe;

import cpw.mods.fml.common.Loader;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.item.ItemStack;

public class RECIPES_Old_Circuits
implements IOreRecipeRegistrator {
    public RECIPES_Old_Circuits() {
        OrePrefixes.crafting.add((IOreRecipeRegistrator)this);
    }

    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aOreDictName.equals(OreDictNames.craftingLensRed.toString())) {
            Logger.INFO("[Old Feature - Circuits] Adding recipes for old circuits. (Part 2)");
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Copper, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Wiring_Basic.get(1L, new Object[0]), 64, 30);
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.AnnealedCopper, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Wiring_Basic.get(1L, new Object[0]), 64, 30);
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Gold, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Wiring_Advanced.get(1L, new Object[0]), 64, 120);
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Electrum, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Wiring_Advanced.get(1L, new Object[0]), 64, 120);
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Platinum, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Wiring_Elite.get(1L, new Object[0]), 64, 480);
        } else if (aOreDictName.equals(OreDictNames.craftingLensGreen.toString())) {
            Logger.INFO("[Old Feature - Circuits] Adding recipes for old circuits. (Part 3)");
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Olivine, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Elite.get(1L, new Object[0]), 256, 480);
            GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Emerald, (long)1L), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Elite.get(1L, new Object[0]), 256, 480);
        } else if (aOreDictName.equals(OreDictNames.craftingLensBlue.toString()) || aOreDictName.equals(OreDictNames.craftingLensCyan.toString()) || aOreDictName.equals(OreDictNames.craftingLensLightBlue.toString())) {
            Logger.INFO("[Old Feature - Circuits] Adding recipes for old circuits. (Part 4)");
            GT_Values.RA.addLaserEngraverRecipe(ItemList.IC2_LapotronCrystal.getWildcard(1L, new Object[0]), GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack}), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Master.get(3L, new Object[0]), 256, 480);
        }
    }

    private static boolean addCircuitRecipes() {
        Logger.INFO("[Old Feature - Circuits] Adding recipes for old circuits. (Part 1)");
        GT_ModHandler.addShapelessCraftingRecipe((ItemStack)GregtechItemList.Old_Circuit_Primitive.get(1L, new Object[0]), (Object[])new Object[]{GT_ModHandler.getIC2Item((String)"casingadviron", (long)1L), OrePrefixes.wireGt01.get((Object)Materials.RedAlloy), OrePrefixes.wireGt01.get((Object)Materials.RedAlloy), OrePrefixes.wireGt01.get((Object)Materials.Tin)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Old_Circuit_Basic.get(1L, new Object[0]), (Object[])new Object[]{"WWW", "CPC", "WWW", Character.valueOf('C'), OrePrefixes.circuit.get((Object)Materials.Primitive), Character.valueOf('W'), OreDictNames.craftingWireCopper, Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Steel)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Old_Circuit_Basic.get(1L, new Object[0]), (Object[])new Object[]{"WCW", "WPW", "WCW", Character.valueOf('C'), OrePrefixes.circuit.get((Object)Materials.Primitive), Character.valueOf('W'), OreDictNames.craftingWireCopper, Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Steel)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Old_Circuit_Basic.get(1L, new Object[0]), (Object[])new Object[]{"WWW", "CPC", "WWW", Character.valueOf('C'), OrePrefixes.circuit.get((Object)Materials.Primitive), Character.valueOf('W'), OrePrefixes.cableGt01.get((Object)Materials.RedAlloy), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Steel)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Old_Circuit_Basic.get(1L, new Object[0]), (Object[])new Object[]{"WCW", "WPW", "WCW", Character.valueOf('C'), OrePrefixes.circuit.get((Object)Materials.Primitive), Character.valueOf('W'), OrePrefixes.cableGt01.get((Object)Materials.RedAlloy), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Steel)});
        GT_Values.RA.addFormingPressRecipe(GregtechItemList.Old_Empty_Board_Basic.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Wiring_Basic.get(4L, new Object[0]), GregtechItemList.Old_Circuit_Board_Basic.get(1L, new Object[0]), 32, 16);
        GT_Values.RA.addFormingPressRecipe(GregtechItemList.Old_Empty_Board_Basic.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Wiring_Advanced.get(4L, new Object[0]), GregtechItemList.Old_Circuit_Board_Advanced.get(1L, new Object[0]), 32, 64);
        GT_Values.RA.addFormingPressRecipe(GregtechItemList.Old_Empty_Board_Elite.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Wiring_Elite.get(4L, new Object[0]), GregtechItemList.Old_Circuit_Board_Elite.get(1L, new Object[0]), 32, 256);
        GT_Values.RA.addFormingPressRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Lapis, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Glowstone, (long)1L), GregtechItemList.Old_Circuit_Parts_Advanced.get(2L, new Object[0]), 32, 64);
        GT_Values.RA.addFormingPressRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Lazurite, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Glowstone, (long)1L), GregtechItemList.Old_Circuit_Parts_Advanced.get(2L, new Object[0]), 32, 64);
        for (Materials tMat : Materials.values()) {
            if (tMat.mStandardMoltenFluid == null || !tMat.contains(SubTag.SOLDERING_MATERIAL)) continue;
            int tMultiplier = tMat.contains(SubTag.SOLDERING_MATERIAL_BAD) ? 4 : (tMat.contains(SubTag.SOLDERING_MATERIAL_GOOD) ? 1 : 2);
            GT_Values.RA.addAssemblerRecipe(ItemList.IC2_Item_Casing_Steel.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.RedAlloy, (long)2L), tMat.getMolten(144L * (long)tMultiplier / 8L), GregtechItemList.Old_Circuit_Primitive.get(1L, new Object[0]), 16, 8);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Plastic, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.RedAlloy, (long)1L), tMat.getMolten(144L * (long)tMultiplier / 8L), GregtechItemList.Old_Circuit_Primitive.get(1L, new Object[0]), 16, 8);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Board_Basic.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Primitive.get(2L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 4L), GregtechItemList.Old_Circuit_Basic.get(1L, new Object[0]), 32, 16);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Basic.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Primitive.get(2L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 4L), GregtechItemList.Old_Circuit_Good.get(1L, new Object[0]), 32, 16);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Board_Advanced.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Advanced.get(2L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 2L), GregtechItemList.Old_Circuit_Advanced.get(1L, new Object[0]), 32, 64);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Board_Advanced.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Elite.get(1L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 2L), GregtechItemList.Old_Circuit_Data.get(1L, new Object[0]), 32, 64);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Board_Elite.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Data.get(3L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 1L), GregtechItemList.Old_Circuit_Elite.get(1L, new Object[0]), 32, 256);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Board_Elite.get(1L, new Object[0]), ItemList.Circuit_Parts_Crystal_Chip_Master.get(3L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 1L), GregtechItemList.Old_Circuit_Master.get(1L, new Object[0]), 32, 256);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Board_Elite.get(1L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Master.get(3L, new Object[0]), tMat.getMolten(144L * (long)tMultiplier / 1L), GregtechItemList.Old_Circuit_Master.get(1L, new Object[0]), 32, 256);
            GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Data.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Plastic, (long)2L), tMat.getMolten(144L * (long)tMultiplier / 2L), GregtechItemList.Old_Tool_DataStick.get(1L, new Object[0]), 128, 64);
        }
        GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Elite.get(2L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Elite.get(18L, new Object[0]), GT_Values.NF, GregtechItemList.Old_Tool_DataOrb.get(1L, new Object[0]), 512, 256);
        GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Master.get(2L, new Object[0]), ItemList.Circuit_Parts_Crystal_Chip_Master.get(18L, new Object[0]), GT_Values.NF, ItemList.Energy_LapotronicOrb.get(1L, new Object[0]), 512, 1024);
        GT_Values.RA.addAssemblerRecipe(GregtechItemList.Old_Circuit_Master.get(2L, new Object[0]), GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Master.get(18L, new Object[0]), GT_Values.NF, ItemList.Energy_LapotronicOrb.get(1L, new Object[0]), 512, 1024);
        GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Silicon, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Plastic, (long)1L), GregtechItemList.Old_Empty_Board_Basic.get(1L, new Object[0]), 32, 16);
        Materials plasticType = Materials.get((String)"Polytetrafluoroethylene") != null ? Materials.get((String)"Polytetrafluoroethylene") : Materials.Plastic;
        GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Silicon, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)plasticType, (long)1L), GregtechItemList.Old_Empty_Board_Elite.get(1L, new Object[0]), 32, 256);
        return true;
    }

    public static boolean handleCircuits() {
        RECIPES_Old_Circuits.hideCircuitsNEI();
        RECIPES_Old_Circuits.addCircuitRecipes();
        RECIPES_Old_Circuits.removeNewCircuits();
        RECIPES_Old_Circuits.generateTradeRecipes();
        return true;
    }

    private static boolean setItemList(ItemList Set2, GregtechItemList Get) {
        try {
            Set2.set(Get.get(1L, new Object[0]));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean removeNewCircuits() {
        Logger.INFO("[Old Feature - Circuits] Overriding .28+ circuit values in the GT5u Itemlist with values from GT++.");
        boolean newVersion = CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK && Utils.getGregtechSubVersion() >= 30;
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Primitive, GregtechItemList.Old_Circuit_Primitive);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Basic, GregtechItemList.Old_Circuit_Basic);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Good, GregtechItemList.Old_Circuit_Good);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Advanced, GregtechItemList.Old_Circuit_Advanced);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Elite, GregtechItemList.Old_Circuit_Elite);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Master, GregtechItemList.Old_Circuit_Master);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Ultimate, GregtechItemList.Old_Circuit_Ultimate);
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Microprocessor"), GregtechItemList.Old_Circuit_Basic);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Integrated_Good"), GregtechItemList.Old_Circuit_Good);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Nanoprocessor"), GregtechItemList.Old_Circuit_Advanced);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Quantumprocessor"), GregtechItemList.Old_Circuit_Data);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Nanocomputer"), GregtechItemList.Old_Circuit_Data);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Crystalprocessor"), GregtechItemList.Old_Circuit_Elite);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Quantumcomputer"), GregtechItemList.Old_Circuit_Elite);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Elitenanocomputer"), GregtechItemList.Old_Circuit_Elite);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Neuroprocessor"), GregtechItemList.Old_Circuit_Master);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Masterquantumcomputer"), GregtechItemList.Old_Circuit_Master);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Wetwarecomputer"), GregtechItemList.Old_Circuit_Ultimate);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Ultimatecrystalcomputer"), GregtechItemList.Old_Circuit_Ultimate);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Quantummainframe"), GregtechItemList.Old_Circuit_Ultimate);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Wetwaresupercomputer"), GregtechItemList.Circuit_IV);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Crystalmainframe"), GregtechItemList.Circuit_IV);
        }
        if (newVersion) {
            RECIPES_Old_Circuits.setItemList(ItemList.valueOf((String)"Circuit_Wetwaremainframe"), GregtechItemList.Circuit_LuV);
        }
        RECIPES_Old_Circuits.setItemList(ItemList.Tool_DataStick, GregtechItemList.Old_Tool_DataStick);
        RECIPES_Old_Circuits.setItemList(ItemList.Tool_DataOrb, GregtechItemList.Old_Tool_DataOrb);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Board_Basic, GregtechItemList.Old_Circuit_Board_Basic);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Board_Advanced, GregtechItemList.Old_Circuit_Board_Advanced);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Board_Elite, GregtechItemList.Old_Circuit_Board_Elite);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Parts_Advanced, GregtechItemList.Old_Circuit_Parts_Advanced);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Parts_Wiring_Basic, GregtechItemList.Old_Circuit_Parts_Wiring_Basic);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Parts_Wiring_Advanced, GregtechItemList.Old_Circuit_Parts_Wiring_Advanced);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Parts_Wiring_Elite, GregtechItemList.Old_Circuit_Parts_Wiring_Elite);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Parts_Crystal_Chip_Elite, GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Elite);
        RECIPES_Old_Circuits.setItemList(ItemList.Circuit_Parts_Crystal_Chip_Master, GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Master);
        return true;
    }

    private static boolean generateTradeRecipes() {
        RecipeUtils.recipeBuilder(CI.craftingToolScrewdriver, null, null, ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32708", 32708, 1), null, null, null, null, null, GregtechItemList.Old_Tool_DataStick.get(1L, new Object[0]));
        RecipeUtils.recipeBuilder(CI.craftingToolScrewdriver, null, null, ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32707", 32707, 1), null, null, null, null, null, GregtechItemList.Old_Tool_DataOrb.get(1L, new Object[0]));
        RecipeUtils.recipeBuilder(CI.craftingToolScrewdriver, null, null, GregtechItemList.Old_Tool_DataStick.get(1L, new Object[0]), null, null, null, null, null, ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32708", 32708, 1));
        RecipeUtils.recipeBuilder(CI.craftingToolScrewdriver, null, null, GregtechItemList.Old_Tool_DataOrb.get(1L, new Object[0]), null, null, null, null, null, ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32707", 32707, 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32700", 32700, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitPrimitive", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32701", 32701, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitBasic", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.03:32078", 32078, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitBasic", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32702", 32702, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitGood", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32702", 32702, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitGood", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32703", 32703, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitAdvanced", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32703", 32703, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitAdvanced", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32704", 32704, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitData", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32705", 32705, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitElite", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32706", 32706, 1)}, ItemUtils.getItemStackOfAmountFromOreDict("circuitMaster", 1));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32713", 32713, 1)}, GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Elite.get(1L, new Object[0]));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32714", 32714, 1)}, GregtechItemList.Old_Circuit_Parts_Crystal_Chip_Master.get(1L, new Object[0]));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32710", 32710, 1)}, GregtechItemList.Old_Circuit_Board_Basic.get(1L, new Object[0]));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32711", 32711, 1)}, GregtechItemList.Old_Circuit_Board_Advanced.get(1L, new Object[0]));
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32712", 32712, 1)}, GregtechItemList.Old_Circuit_Board_Elite.get(1L, new Object[0]));
        return true;
    }

    private static boolean hideCircuitsNEI() {
        Boolean isNEILoaded = Loader.isModLoaded((String)"NotEnoughItems");
        if (isNEILoaded.booleanValue() && !CORE.ConfigSwitches.showHiddenNEIItems) {
            String[] CircuitToHide;
            Logger.INFO("[Old Feature - Circuits] Hiding .28+ circuits in NEI.");
            for (String component : CircuitToHide = new String[]{"Circuit_Board_Basic", "Circuit_Board_Advanced", "Circuit_Board_Elite", "Circuit_Parts_Advanced", "Circuit_Parts_Wiring_Basic", "Circuit_Parts_Wiring_Advanced", "Circuit_Parts_Wiring_Elite", "Circuit_Parts_Crystal_Chip_Elite", "Circuit_Parts_Crystal_Chip_Master", "Circuit_Primitive", "Circuit_Basic", "Circuit_Integrated_Good", "Circuit_Good", "Circuit_Advanced", "Circuit_Data", "Circuit_Elite", "Circuit_Master", "Circuit_Ultimate", "Circuit_Board_Coated", "Circuit_Board_Phenolic", "Circuit_Board_Epoxy", "Circuit_Board_Fiberglass", "Circuit_Board_Multifiberglass", "Circuit_Board_Wetware", "Circuit_Parts_Resistor", "Circuit_Parts_ResistorSMD", "Circuit_Parts_Glass_Tube", "Circuit_Parts_Vacuum_Tube", "Circuit_Parts_Coil", "Circuit_Parts_Diode", "Circuit_Parts_DiodeSMD", "Circuit_Parts_Transistor", "Circuit_Parts_TransistorSMD", "Circuit_Parts_Capacitor", "Circuit_Parts_CapacitorSMD", "Circuit_Silicon_Ingot", "Circuit_Silicon_Ingot2", "Circuit_Silicon_Ingot3", "Circuit_Silicon_Wafer", "Circuit_Silicon_Wafer2", "Circuit_Silicon_Wafer3", "Circuit_Wafer_ILC", "Circuit_Chip_ILC", "Circuit_Wafer_Ram", "Circuit_Chip_Ram", "Circuit_Wafer_NAND", "Circuit_Chip_NAND", "Circuit_Wafer_NOR", "Circuit_Chip_NOR", "Circuit_Wafer_CPU", "Circuit_Chip_CPU", "Circuit_Wafer_SoC", "Circuit_Chip_SoC", "Circuit_Wafer_SoC2", "Circuit_Chip_SoC2", "Circuit_Wafer_PIC", "Circuit_Chip_PIC", "Circuit_Wafer_HPIC", "Circuit_Chip_HPIC", "Circuit_Wafer_NanoCPU", "Circuit_Chip_NanoCPU", "Circuit_Wafer_QuantumCPU", "Circuit_Chip_QuantumCPU", "Circuit_Chip_CrystalCPU", "Circuit_Chip_CrystalSoC", "Circuit_Chip_NeuroCPU", "Circuit_Chip_Stemcell", "Circuit_Processor", "Circuit_Computer", "Circuit_Nanoprocessor", "Circuit_Nanocomputer", "Circuit_Elitenanocomputer", "Circuit_Quantumprocessor", "Circuit_Quantumcomputer", "Circuit_Masterquantumcomputer", "Circuit_Quantummainframe", "Circuit_Crystalprocessor", "Circuit_Crystalcomputer", "Circuit_Ultimatecrystalcomputer", "Circuit_Crystalmainframe", "Circuit_Neuroprocessor", "Circuit_Wetwarecomputer", "Circuit_Wetwaresupercomputer", "Circuit_Wetwaremainframe", "Circuit_Parts_RawCrystalChip", "Circuit_Board_Plastic", "Circuit_Parts_GlassFiber", "Circuit_Parts_PetriDish", "Circuit_Microprocessor"}) {
                try {
                    ItemUtils.hideItemFromNEI(ItemUtils.getValueOfItemList(component, null).get(1L, new Object[0]));
                }
                catch (IllegalArgumentException I) {
                    Logger.INFO("Could not find " + component + " in the Gregtech item list.");
                    Logger.INFO("This is NOT an error, simply a notification.");
                }
            }
        }
        return true;
    }
}

