/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.xmod.gregtech.common.helpers.ChargingHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.FoodStats;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles"), @Optional.Interface(iface="baubles.api.BaubleType", modid="Baubles")})
public class ItemHealingDevice
extends Item
implements IElectricItem,
IElectricItemManager,
IBauble {
    private final String unlocalizedName = "personalHealingDevice";
    private static final int maxValueEU = 1000000000;
    protected double chargeEU = 0.0;

    public ItemHealingDevice() {
        this.func_77637_a(AddToCreativeTab.tabMachines);
        this.func_77655_b(this.unlocalizedName);
        this.func_77625_d(1);
        this.func_111206_d("miscutils:personalCloakingDevice");
        GameRegistry.registerItem((Item)this, (String)this.unlocalizedName);
    }

    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        if (worldObj.field_72995_K) {
            return;
        }
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(1000000000);
        return x.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(0);
        return x.func_77973_b();
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 1.0E9;
    }

    public int getTier(ItemStack itemStack) {
        return 5;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return GT_Values.V[7];
    }

    public String func_77653_i(ItemStack p_77653_1_) {
        return EnumChatFormatting.BLUE + "Personal Healing NanoBooster" + EnumChatFormatting.RESET;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double secondsLeft(ItemStack stack) {
        double r = 0.0;
        r = this.getCharge(stack) / 409600.0;
        return (int)r;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        String aString1 = StatCollector.func_74838_a((String)"GTPP.nanohealer.tooltip.1");
        String aString2 = StatCollector.func_74838_a((String)"GTPP.nanohealer.tooltip.2");
        String aString3 = StatCollector.func_74838_a((String)"GTPP.nanohealer.tooltip.3");
        String aString4 = StatCollector.func_74838_a((String)"GTPP.nanohealer.tooltip.4");
        String aString5 = StatCollector.func_74838_a((String)"GTPP.nanohealer.tooltip.5");
        String aStringTooltip = StatCollector.func_74838_a((String)"GTPP.nanohealer.hidden");
        String aEuInfo = StatCollector.func_74838_a((String)"GTPP.info.euInfo");
        String aTier = StatCollector.func_74838_a((String)"GTPP.machines.tier");
        String aInputLimit = StatCollector.func_74838_a((String)"GTPP.info.inputLimit");
        String aCurrentPower = StatCollector.func_74838_a((String)"GTPP.info.currentPower");
        String aEU = StatCollector.func_74838_a((String)"GTPP.info.eu");
        String aEUT = aEU + "/t";
        boolean isShowing = ItemHealingDevice.getShowMessages(stack);
        list.add("");
        list.add(EnumChatFormatting.GREEN + aString1 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString2 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString3 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.RED + aString4 + EnumChatFormatting.GRAY);
        list.add("");
        list.add(EnumChatFormatting.GOLD + aEuInfo + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GRAY + aTier + ": [" + EnumChatFormatting.YELLOW + this.getTier(stack) + EnumChatFormatting.GRAY + "] " + aInputLimit + ": [" + EnumChatFormatting.YELLOW + this.getTransferLimit(stack) + EnumChatFormatting.GRAY + aEUT + "]");
        list.add(EnumChatFormatting.GRAY + aCurrentPower + ": [" + EnumChatFormatting.YELLOW + (long)this.getCharge(stack) + EnumChatFormatting.GRAY + aEU + "] [" + EnumChatFormatting.YELLOW + MathUtils.findPercentage(this.getCharge(stack), this.getMaxCharge(stack)) + EnumChatFormatting.GRAY + "%]");
        list.add(EnumChatFormatting.GOLD + aString5 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GOLD + aStringTooltip + " " + (!isShowing ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED) + !isShowing + EnumChatFormatting.GRAY);
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!simulate) {
            ElectricItem.manager.charge(stack, amount, tier, true, simulate);
        }
        return ElectricItem.manager.charge(stack, amount, tier, true, simulate);
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return ElectricItem.manager.discharge(stack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    public double getCharge(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack);
    }

    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.canUse(stack, amount);
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return ElectricItem.manager.use(stack, amount, entity);
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        ElectricItem.manager.chargeFromArmor(stack, entity);
    }

    public String getToolTip(ItemStack stack) {
        return ElectricItem.manager.getToolTip(stack);
    }

    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    public void onWornTick(ItemStack aBaubleStack, EntityLivingBase arg1) {
        if (arg1 != null && arg1.field_70170_p != null && !arg1.field_70170_p.field_72995_K) {
            for (ItemStack aInvStack : ((EntityPlayer)arg1).field_71071_by.field_70462_a) {
                IElectricItem electricItem;
                if (aInvStack == aBaubleStack) continue;
                if (this.getCharge(aBaubleStack) == this.getMaxCharge(aBaubleStack)) break;
                if (aInvStack != null && ChargingHelper.isItemValid(aInvStack) && (electricItem = (IElectricItem)aInvStack.func_77973_b()) != null) {
                    double aTransferRate = electricItem.getTransferLimit(aInvStack);
                    int mTier = electricItem.getTier(aInvStack);
                    double aCurrentChargeForThisBauble = ElectricItem.manager.getCharge(aBaubleStack);
                    if (aCurrentChargeForThisBauble < 1.0E9 && ElectricItem.manager.getCharge(aInvStack) >= aTransferRate && electricItem.canProvideEnergy(aInvStack)) {
                        double d = ElectricItem.manager.discharge(aInvStack, aTransferRate, mTier, false, true, false);
                        ElectricItem.manager.charge(aBaubleStack, d, mTier, true, false);
                    }
                }
                if (!(this.getCharge(aBaubleStack) <= this.getMaxCharge(aBaubleStack) - this.getTransferLimit(aBaubleStack))) break;
            }
            if (this.getCharge(aBaubleStack) > 0.0) {
                if (!(arg1 instanceof EntityPlayer)) {
                    return;
                }
                EntityPlayer g = (EntityPlayer)arg1;
                float hp = 0.0f;
                if (arg1.func_110143_aJ() < arg1.func_110138_aP()) {
                    float rx = arg1.func_110138_aP() - arg1.func_110143_aJ();
                    Logger.INFO("rx:" + rx);
                    arg1.func_70691_i(rx * 2.0f);
                    hp = rx;
                    this.discharge(aBaubleStack, 1638400.0f * rx, 6, true, true, false);
                }
                int hunger = 0;
                float saturation = 0.0f;
                FoodStats aFood = g.func_71024_bL();
                if (aFood != null && (hunger = 20 - aFood.func_75116_a()) > 0) {
                    saturation = 20.0f - aFood.func_75115_e();
                    this.discharge(aBaubleStack, 1638400.0f * ((float)hunger + (saturation /= (float)hunger * 2.0f)), 6, true, true, false);
                    aFood.func_75122_a(hunger, saturation);
                }
                if (ItemHealingDevice.getShowMessages(aBaubleStack)) {
                    if (hp > 0.0f || hunger > 0 || saturation > 0.0f) {
                        PlayerUtils.messagePlayer((EntityPlayer)arg1, "Your NanoBooster Whirs! Leaving you feeling stronger.");
                    }
                    if (hp > 0.0f) {
                        PlayerUtils.messagePlayer((EntityPlayer)arg1, "Healed " + hp + " hp.");
                    }
                    if (hunger > 0) {
                        PlayerUtils.messagePlayer((EntityPlayer)arg1, "Healed " + hunger + " hunger.");
                    }
                    if (saturation > 0.0f) {
                        PlayerUtils.messagePlayer((EntityPlayer)arg1, "Satured Hunger by " + saturation + ".");
                    }
                    if (hp > 0.0f || hunger > 0 || saturation > 0.0f) {
                        PlayerUtils.messagePlayer((EntityPlayer)arg1, "You check it's remaining uses, it has " + (int)this.secondsLeft(aBaubleStack) + ".");
                    }
                }
            }
        }
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        tagMain.func_74757_a("ShowMSG", false);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static final boolean getShowMessages(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT == null) {
            if (!ItemHealingDevice.createNBT(aStack)) {
                return false;
            }
            aNBT = aStack.func_77978_p();
        }
        return aNBT.func_74767_n("ShowMSG");
    }

    public static final boolean setShowMessages(ItemStack aStack, boolean aShow) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT == null) {
            if (!ItemHealingDevice.createNBT(aStack)) {
                return false;
            }
            aNBT = aStack.func_77978_p();
        }
        aNBT.func_74757_a("ShowMSG", aShow);
        return true;
    }

    public boolean func_77648_a(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return super.func_77648_a(p_77648_1_, p_77648_2_, p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_8_, p_77648_9_, p_77648_10_);
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        ItemStack superStack = super.func_77659_a(aStack, aWorld, aPlayer);
        boolean isShiftHeld = KeyboardUtils.isShiftKeyDown();
        if (isShiftHeld) {
            boolean oldState = ItemHealingDevice.getShowMessages(superStack);
            boolean newState = Utils.invertBoolean(oldState);
            ItemHealingDevice.setShowMessages(superStack, newState);
            PlayerUtils.messagePlayer(aPlayer, !oldState ? "Showing info messages" : "Hiding info messages");
        }
        return superStack;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }
}

