/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gtPlusPlus.api.helpers.MaterialHelper;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.plugin.agrichem.BioRecipes;
import gtPlusPlus.plugin.agrichem.item.algae.ItemAgrichemBase;
import gtPlusPlus.plugin.agrichem.item.algae.ItemAlgaeBase;
import gtPlusPlus.plugin.agrichem.item.algae.ItemBioChip;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class AgriculturalChem
extends ItemPackage {
    private static boolean aBOP;
    private static boolean aTiCon;
    private static AutoMap<FluidStack> mBloodFluids;
    public static Fluid PoopJuice;
    public static Fluid ManureSlurry;
    public static Fluid FertileManureSlurry;
    public static Fluid CustomBlood;
    public static Fluid RedMud;
    public static Item dustManureByproducts;
    public static Item dustOrganicFertilizer;
    public static Item dustDirt;
    public static Item mAlgae;
    public static Item mBioCircuit;
    public static Item mAgrichemItem1;
    public static ItemStack mAlgaeBiosmass;
    public static ItemStack mGreenAlgaeBiosmass;
    public static ItemStack mBrownAlgaeBiosmass;
    public static ItemStack mGoldenBrownAlgaeBiosmass;
    public static ItemStack mRedAlgaeBiosmass;
    public static ItemStack mCelluloseFiber;
    public static ItemStack mGoldenBrownCelluloseFiber;
    public static ItemStack mRedCelluloseFiber;
    public static ItemStack mCompost;
    public static ItemStack mWoodPellet;
    public static ItemStack mWoodBrick;
    public static ItemStack mCellulosePulp;
    public static ItemStack mRawBioResin;
    public static ItemStack mCatalystCarrier;
    public static ItemStack mGreenCatalyst;
    public static ItemStack mAlginicAcid;
    public static ItemStack mAlumina;
    public static ItemStack mAluminiumPellet;
    public static ItemStack mSodiumAluminate;
    public static ItemStack mSodiumHydroxide;
    public static ItemStack mSodiumCarbonate;
    public static ItemStack mLithiumChloride;
    public static ItemStack mPelletMold;
    public static ItemStack mCleanAluminiumMix;
    public static ItemStack mPinecone;
    public static ItemStack mCrushedPine;
    private static final AutoMap<ItemStack> mMeats;
    private static final AutoMap<ItemStack> mFish;
    private static final AutoMap<ItemStack> mFruits;
    private static final AutoMap<ItemStack> mVege;
    private static final AutoMap<ItemStack> mNuts;
    private static final AutoMap<ItemStack> mSeeds;
    private static final AutoMap<ItemStack> mPeat;
    private static final AutoMap<ItemStack> mBones;
    private static final AutoMap<ItemStack> mBoneMeal;
    private static final AutoMap<ItemStack> mList_Master_Meats;
    private static final AutoMap<ItemStack> mList_Master_FruitVege;
    private static final AutoMap<ItemStack> mList_Master_Seeds;
    private static final AutoMap<ItemStack> mList_Master_Bones;
    public static ItemStack aFertForestry;
    public static ItemStack aFertIC2;

    @Override
    public void items() {
        List NaOHTiny;
        dustManureByproducts = ItemUtils.generateSpecialUseDusts("ManureByproducts", "Manure Byproduct", "(N2H4O3)N2P2Ca3CuC8", Utils.rgbtoHexValue(110, 75, 25))[0];
        dustOrganicFertilizer = ItemUtils.generateSpecialUseDusts("OrganicFertilizer", "Organic Fertilizer", "Ca5(PO4)3(OH)", Utils.rgbtoHexValue(240, 240, 240))[0];
        dustDirt = ItemUtils.generateSpecialUseDusts("Dirt", "Dried Earth", Utils.rgbtoHexValue(65, 50, 15))[0];
        mAlgae = new ItemAlgaeBase();
        mAgrichemItem1 = new ItemAgrichemBase();
        mBioCircuit = new ItemBioChip();
        GregtechItemList.Circuit_BioRecipeSelector.set(mBioCircuit);
        mAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 0, 1);
        mGreenAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 1, 1);
        mBrownAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 2, 1);
        mGoldenBrownAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 3, 1);
        mRedAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 4, 1);
        mCelluloseFiber = ItemUtils.simpleMetaStack(mAgrichemItem1, 5, 1);
        mGoldenBrownCelluloseFiber = ItemUtils.simpleMetaStack(mAgrichemItem1, 6, 1);
        mRedCelluloseFiber = ItemUtils.simpleMetaStack(mAgrichemItem1, 7, 1);
        mCompost = ItemUtils.simpleMetaStack(mAgrichemItem1, 8, 1);
        mWoodPellet = ItemUtils.simpleMetaStack(mAgrichemItem1, 9, 1);
        mWoodBrick = ItemUtils.simpleMetaStack(mAgrichemItem1, 10, 1);
        mCellulosePulp = ItemUtils.simpleMetaStack(mAgrichemItem1, 11, 1);
        mRawBioResin = ItemUtils.simpleMetaStack(mAgrichemItem1, 12, 1);
        mCatalystCarrier = ItemUtils.simpleMetaStack(mAgrichemItem1, 13, 1);
        mGreenCatalyst = ItemUtils.simpleMetaStack(mAgrichemItem1, 14, 1);
        mAlginicAcid = ItemUtils.simpleMetaStack(mAgrichemItem1, 15, 1);
        mAlumina = ItemUtils.simpleMetaStack(mAgrichemItem1, 16, 1);
        mAluminiumPellet = ItemUtils.simpleMetaStack(mAgrichemItem1, 17, 1);
        mSodiumAluminate = ItemUtils.simpleMetaStack(mAgrichemItem1, 18, 1);
        if (OreDictionary.doesOreNameExist((String)"dustSodiumHydroxide_GT5U") || OreDictionary.doesOreNameExist((String)"dustSodiumHydroxide")) {
            List aTest = OreDictionary.getOres((String)"dustSodiumHydroxide", (boolean)false);
            ItemStack aTestStack = aTest.isEmpty() ? ((aTest = OreDictionary.getOres((String)"dustSodiumHydroxide_GT5U", (boolean)false)).isEmpty() ? ItemUtils.simpleMetaStack(mAgrichemItem1, 19, 1) : (ItemStack)aTest.get(0)) : (ItemStack)aTest.get(0);
            mSodiumHydroxide = aTestStack;
        } else {
            mSodiumHydroxide = ItemUtils.simpleMetaStack(mAgrichemItem1, 19, 1);
        }
        mSodiumCarbonate = ItemUtils.simpleMetaStack(mAgrichemItem1, 20, 1);
        mLithiumChloride = ItemUtils.simpleMetaStack(mAgrichemItem1, 21, 1);
        mPelletMold = ItemUtils.simpleMetaStack(mAgrichemItem1, 22, 1);
        mCleanAluminiumMix = ItemUtils.simpleMetaStack(mAgrichemItem1, 23, 1);
        mPinecone = ItemUtils.simpleMetaStack(mAgrichemItem1, 24, 1);
        mCrushedPine = ItemUtils.simpleMetaStack(mAgrichemItem1, 25, 1);
        ItemUtils.addItemToOreDictionary(mGreenAlgaeBiosmass, "biomassGreenAlgae");
        ItemUtils.addItemToOreDictionary(mBrownAlgaeBiosmass, "biomassBrownAlgae");
        ItemUtils.addItemToOreDictionary(mGoldenBrownAlgaeBiosmass, "biomassGoldenBrownAlgae");
        ItemUtils.addItemToOreDictionary(mRedAlgaeBiosmass, "biomassRedAlgae");
        ItemUtils.addItemToOreDictionary(mCelluloseFiber, "fiberCellulose");
        ItemUtils.addItemToOreDictionary(mGoldenBrownCelluloseFiber, "fiberCellulose");
        ItemUtils.addItemToOreDictionary(mGoldenBrownCelluloseFiber, "fiberGoldenBrownCellulose");
        ItemUtils.addItemToOreDictionary(mRedCelluloseFiber, "fiberCellulose");
        ItemUtils.addItemToOreDictionary(mRedCelluloseFiber, "fiberRedCellulose");
        ItemUtils.addItemToOreDictionary(mWoodPellet, "pelletWood");
        ItemUtils.addItemToOreDictionary(mWoodBrick, "brickWood");
        ItemUtils.addItemToOreDictionary(mCellulosePulp, "pulpCellulose");
        ItemUtils.addItemToOreDictionary(mCatalystCarrier, "catalystEmpty");
        ItemUtils.addItemToOreDictionary(mGreenCatalyst, "catalystAluminiumSilver");
        ItemUtils.addItemToOreDictionary(mAlginicAcid, "dustAlginicAcid");
        ItemUtils.addItemToOreDictionary(mAlumina, "dustAlumina");
        ItemUtils.addItemToOreDictionary(mAluminiumPellet, "pelletAluminium");
        ItemUtils.addItemToOreDictionary(mSodiumAluminate, "dustSodiumAluminate");
        ItemUtils.addItemToOreDictionary(mSodiumHydroxide, "dustSodiumHydroxide");
        ItemUtils.addItemToOreDictionary(mSodiumCarbonate, "dustSodiumCarbonate");
        ItemUtils.addItemToOreDictionary(mLithiumChloride, "dustLithiumChloride");
        ItemUtils.addItemToOreDictionary(mPinecone, "pinecone");
        ItemUtils.addItemToOreDictionary(mCrushedPine, "crushedPineMaterial");
        List NaOHSmall = OreDictionary.getOres((String)"dustSmallSodiumHydroxide_GT5U", (boolean)false);
        if (!NaOHSmall.isEmpty()) {
            ItemUtils.addItemToOreDictionary((ItemStack)NaOHSmall.get(0), "dustSmallSodiumHydroxide");
        }
        if (!(NaOHTiny = OreDictionary.getOres((String)"dustTinySodiumHydroxide_GT5U", (boolean)false)).isEmpty()) {
            ItemUtils.addItemToOreDictionary((ItemStack)NaOHTiny.get(0), "dustTinySodiumHydroxide");
        }
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        PoopJuice = FluidUtils.generateFluidNonMolten("raw.waste", "Raw Animal Waste", 207, new short[]{100, 70, 30, 100}, null, null, 0, true);
        ManureSlurry = FluidUtils.generateFluidNonMolten("manure.slurry", "Manure Slurry", 214, new short[]{75, 45, 15, 100}, null, null, 0, true);
        FertileManureSlurry = FluidUtils.generateFluidNonMolten("fertile.manure.slurry", "Fertile Manure Slurry", 220, new short[]{65, 50, 15, 100}, null, null, 0, true);
        RedMud = FluidUtils.generateFluidNoPrefix("mud.red.slurry", "Red Mud Slurry", 207, new short[]{180, 35, 25, 100}, true);
    }

    public AgriculturalChem() {
        FluidStack aBlood;
        aBOP = LoadedMods.BiomesOPlenty;
        aTiCon = LoadedMods.TiCon;
        Logger.INFO("Adding Agrochemical content");
        if (aBOP && (aBlood = FluidUtils.getFluidStack("hell_blood", 100)) != null) {
            Logger.INFO("Found Biome's o Plenty, enabled Blood support.");
            CustomBlood = aBlood.getFluid();
            mBloodFluids.put(aBlood);
        }
        if (aTiCon && (aBlood = FluidUtils.getFluidStack("blood", 100)) != null) {
            Logger.INFO("Found Tinker's Construct, enabled Blood support.");
            CustomBlood = aBlood.getFluid();
            mBloodFluids.put(FluidUtils.getFluidStack("blood", 100));
        }
        if (mBloodFluids.isEmpty() || CustomBlood == null) {
            Logger.INFO("Did not find any existing Blood fluids. Trying to wildcard search the fluid registry, then generate our own if that fails.");
            FluidStack aTempBlood = FluidUtils.getWildcardFluidStack("blood", 100);
            CustomBlood = aTempBlood != null ? aTempBlood.getFluid() : ((aTempBlood = FluidUtils.getWildcardFluidStack("hell_blood", 100)) == null ? FluidUtils.generateFluidNoPrefix("blood", "Blood", 207, new short[]{175, 25, 25, 100}, true) : aTempBlood.getFluid());
            Logger.INFO("Using " + CustomBlood.getName());
            mBloodFluids.put(FluidUtils.getFluidStack(CustomBlood, 100));
        }
    }

    private static void processAllOreDict() {
        AgriculturalChem.processOreDict("listAllmeatraw", mMeats);
        AgriculturalChem.processOreDict("listAllfishraw", mFish);
        AgriculturalChem.processOreDict("listAllfruit", mFruits);
        AgriculturalChem.processOreDict("listAllVeggie", mVege);
        AgriculturalChem.processOreDict("listAllnut", mNuts);
        AgriculturalChem.processOreDict("listAllSeed", mSeeds);
        AgriculturalChem.processOreDict("brickPeat", mPeat);
        AgriculturalChem.processOreDict("bone", mBones);
        AgriculturalChem.processOreDict("dustBone", mBoneMeal);
        if (!mMeats.isEmpty()) {
            for (ItemStack g : mMeats) {
                mList_Master_Meats.put(g);
            }
        }
        if (!mFish.isEmpty()) {
            for (ItemStack g : mFish) {
                mList_Master_Meats.put(g);
            }
        }
        if (!mFruits.isEmpty()) {
            for (ItemStack g : mFruits) {
                mList_Master_FruitVege.put(g);
            }
        }
        if (!mVege.isEmpty()) {
            for (ItemStack g : mVege) {
                mList_Master_FruitVege.put(g);
            }
        }
        if (!mNuts.isEmpty()) {
            for (ItemStack g : mNuts) {
                mList_Master_FruitVege.put(g);
            }
        }
        if (!mSeeds.isEmpty()) {
            for (ItemStack g : mSeeds) {
                mList_Master_Seeds.put(g);
            }
        }
        if (!mBoneMeal.isEmpty()) {
            for (ItemStack g : mBoneMeal) {
                mList_Master_Bones.put(g);
            }
        }
        if (!mBones.isEmpty()) {
            for (ItemStack g : mBones) {
                mList_Master_Bones.put(g);
            }
        }
    }

    private static void processOreDict(String aOreName, AutoMap<ItemStack> aMap) {
        ArrayList aTemp = OreDictionary.getOres((String)aOreName);
        if (!aTemp.isEmpty()) {
            for (ItemStack stack : aTemp) {
                aMap.put(stack);
            }
        }
    }

    private static void addBasicSlurryRecipes() {
        ItemStack aManureByprod1 = ItemUtils.getItemStackOfAmountFromOreDict("dustTinyManureByproducts", 1);
        ItemStack aManureByprod2 = ItemUtils.getItemStackOfAmountFromOreDict("dustSmallManureByproducts", 1);
        ItemStack aDirtDust = ItemUtils.getSimpleStack(dustDirt, 1);
        GT_Values.RA.addCentrifugeRecipe(CI.getNumberedCircuit(10), null, FluidUtils.getFluidStack(PoopJuice, 1000), FluidUtils.getFluidStack(ManureSlurry, 250), aDirtDust, aDirtDust, aManureByprod1, aManureByprod1, aManureByprod1, aManureByprod1, new int[]{2000, 2000, 500, 500, 250, 250}, 200, 30);
        GT_Values.RA.addCentrifugeRecipe(CI.getNumberedCircuit(20), null, FluidUtils.getFluidStack(PoopJuice, 1000), FluidUtils.getFluidStack(ManureSlurry, 50), aDirtDust, aDirtDust, aManureByprod1, aManureByprod1, aManureByprod2, aManureByprod2, new int[]{4000, 3000, 1250, 1250, 675, 675}, 400, 60);
    }

    private static void addAdvancedSlurryRecipes() {
        ItemStack aCircuit = CI.getNumberedCircuit(10);
        ItemStack aEmptyCells = CI.emptyCells(2);
        ItemStack aInputCells = ItemUtils.getItemStackOfAmountFromOreDict("cellRawAnimalWaste", 2);
        FluidStack aOutput = FluidUtils.getFluidStack(FertileManureSlurry, 1000);
        for (FluidStack aBloodStack : mBloodFluids) {
            for (ItemStack aBoneStack : mList_Master_Bones) {
                ItemStack aBone = ItemUtils.getSimpleStack(aBoneStack, 2);
                for (ItemStack aMeatStack : mList_Master_Meats) {
                    ItemStack aMeat = ItemUtils.getSimpleStack(aMeatStack, 5);
                    GT_Values.RA.addMixerRecipe(aCircuit, aBone, aMeat, aInputCells, aBloodStack, aOutput, aEmptyCells, 160, 60);
                }
            }
        }
    }

    private static void addBasicOrganiseFertRecipes() {
        FluidStack aInputFluid = FluidUtils.getFluidStack(ManureSlurry, 1000);
        ItemStack aOutputDust = ItemUtils.getSimpleStack(dustOrganicFertilizer, 3);
        for (ItemStack aPeatStack : mPeat) {
            ItemStack aMeat;
            ItemStack aPeat = ItemUtils.getSimpleStack(aPeatStack, 3);
            for (ItemStack aMeatStack : mList_Master_Meats) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 5);
                CORE.RA.addChemicalRecipe(aPeat, aMeat, aInputFluid, null, aOutputDust, 400, 120);
            }
            aPeat = ItemUtils.getSimpleStack(aPeatStack, 2);
            for (ItemStack aMeatStack : mList_Master_FruitVege) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 9);
                CORE.RA.addChemicalRecipe(aPeat, aMeat, aInputFluid, null, aOutputDust, 200, 120);
            }
        }
    }

    private static void addAdvancedOrganiseFertRecipes() {
        FluidStack aInputFluid = FluidUtils.getFluidStack(FertileManureSlurry, 1000);
        ItemStack aOutputDust = ItemUtils.getSimpleStack(dustOrganicFertilizer, 7);
        for (ItemStack aPeatStack : mPeat) {
            ItemStack aMeat;
            ItemStack aPeat = ItemUtils.getSimpleStack(aPeatStack, 5);
            for (ItemStack aMeatStack : mList_Master_Meats) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 7);
                CORE.RA.addChemicalRecipe(aPeat, aMeat, aInputFluid, null, aOutputDust, 200, 140);
            }
            aPeat = ItemUtils.getSimpleStack(aPeatStack, 3);
            for (ItemStack aMeatStack : mList_Master_FruitVege) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 12);
                CORE.RA.addChemicalRecipe(aPeat, aMeat, aInputFluid, null, aOutputDust, 100, 140);
            }
        }
    }

    private static void addMiscRecipes() {
        ItemStack aDustOrganicFert = ItemUtils.getSimpleStack(dustOrganicFertilizer, 1);
        ItemStack aManureByprod = ItemUtils.getSimpleStack(dustManureByproducts, 1);
        if (LoadedMods.Forestry) {
            Field aItemField = ReflectionUtils.getField(ReflectionUtils.getClass("forestry.plugins.PluginCore"), "items");
            try {
                Field aFertField;
                Object aItemInstance;
                Object aItemRegInstance;
                Object object = aItemRegInstance = aItemField != null ? aItemField.get(aItemField) : null;
                if (aItemRegInstance != null && (aItemInstance = (aFertField = ReflectionUtils.getField(aItemRegInstance.getClass(), "fertilizerCompound")).get(aItemRegInstance)) instanceof Item) {
                    aFertForestry = ItemUtils.getSimpleStack((Item)aItemInstance);
                    Item aForestryFert = (Item)aItemInstance;
                    CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedCircuit(11), ItemUtils.getSimpleStack(aDustOrganicFert, 4)}, null, null, new ItemStack[]{ItemUtils.getSimpleStack(aForestryFert, 3), aManureByprod, aManureByprod}, new int[]{10000, 2000, 2000}, 400, 240);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        if (LoadedMods.IndustrialCraft2) {
            aFertIC2 = ItemUtils.getItemStackFromFQRN("IC2:itemFertilizer", 1);
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedCircuit(12), ItemUtils.getSimpleStack(aDustOrganicFert, 4)}, null, null, new ItemStack[]{ItemUtils.getItemStackFromFQRN("IC2:itemFertilizer", 3), aManureByprod, aManureByprod}, new int[]{10000, 2000, 2000}, 400, 240);
        }
        CORE.RA.addCompressorRecipe(ItemUtils.getSimpleStack(dustDirt, 9), ItemUtils.getSimpleStack(Blocks.field_150346_d), 40, 8);
        GT_Values.RA.addCentrifugeRecipe(CI.getNumberedCircuit(20), ItemUtils.getSimpleStack(aManureByprod, 4), FluidUtils.getFluidStack("sulfuricacid", 250), FluidUtils.getFluidStack("sulfuricapatite", 50), MaterialHelper.getDustSmall(Materials.Phosphorus, 2), MaterialHelper.getDustSmall(Materials.Calcium, 2), MaterialHelper.getDustTiny(Materials.Copper, 1), MaterialHelper.getDust(Materials.Carbon, 1), ItemUtils.getSimpleStack(dustDirt, 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAmmoniumNitrate", 1), new int[]{2500, 2500, 750, 1000, 5000, 250}, 400, 60);
        CORE.RA.addSemifluidFuel(FluidUtils.getFluidStack(PoopJuice, 1000), 12);
        CORE.RA.addSemifluidFuel(FluidUtils.getFluidStack(ManureSlurry, 1000), 24);
        CORE.RA.addSemifluidFuel(FluidUtils.getFluidStack(FertileManureSlurry, 1000), 32);
        GT_Values.RA.addCentrifugeRecipe(CI.getNumberedBioCircuit(10), GT_Values.NI, FluidUtils.getFluidStack(RedMud, 1000), FluidUtils.getWater(500), ELEMENT.getInstance().IRON.getSmallDust(1), ELEMENT.getInstance().COPPER.getSmallDust(1), ELEMENT.getInstance().TIN.getSmallDust(1), ELEMENT.getInstance().SULFUR.getSmallDust(1), ELEMENT.getInstance().NICKEL.getTinyDust(1), ELEMENT.getInstance().LEAD.getTinyDust(1), new int[]{3000, 3000, 2000, 2000, 1000, 1000}, 600, 30);
    }

    @Override
    public String errorMessage() {
        return "Failed to generate recipes for AgroChem.";
    }

    @Override
    public boolean generateRecipes() {
        if (mBloodFluids.isEmpty()) {
            Logger.INFO("Could not find, nor create Blood fluid. Unable to add recipes.");
            return false;
        }
        AgriculturalChem.processAllOreDict();
        AgriculturalChem.addBasicSlurryRecipes();
        AgriculturalChem.addAdvancedSlurryRecipes();
        AgriculturalChem.addBasicOrganiseFertRecipes();
        AgriculturalChem.addAdvancedOrganiseFertRecipes();
        AgriculturalChem.addMiscRecipes();
        BioRecipes.init();
        return true;
    }

    static {
        mBloodFluids = new AutoMap();
        mMeats = new AutoMap();
        mFish = new AutoMap();
        mFruits = new AutoMap();
        mVege = new AutoMap();
        mNuts = new AutoMap();
        mSeeds = new AutoMap();
        mPeat = new AutoMap();
        mBones = new AutoMap();
        mBoneMeal = new AutoMap();
        mList_Master_Meats = new AutoMap();
        mList_Master_FruitVege = new AutoMap();
        mList_Master_Seeds = new AutoMap();
        mList_Master_Bones = new AutoMap();
    }
}

