/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.itemblock;

import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemBlockGtFrameBox
extends ItemBlock {
    protected int blockColour;
    private Material mMaterial;
    private int sRadiation;

    public ItemBlockGtFrameBox(Block block) {
        super(block);
        BlockBaseModular baseBlock = (BlockBaseModular)block;
        this.blockColour = baseBlock.func_149741_i(1);
        if (block instanceof BlockBaseModular) {
            BlockBaseModular g = (BlockBaseModular)block;
            this.mMaterial = g.getMaterialEx();
            this.sRadiation = this.mMaterial.vRadiationLevel;
        } else {
            this.mMaterial = null;
            this.sRadiation = 0;
        }
    }

    public int getRenderColor(int aMeta) {
        return this.blockColour;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        if (this.mMaterial != null) {
            list.add(this.mMaterial.vChemicalFormula);
            if (this.mMaterial.vRadiationLevel > 0) {
                list.add(CORE.GT_Tooltip_Radioactive);
            }
        } else {
            list.add("Material is Null.");
        }
        if (KeyboardUtils.isCtrlKeyDown()) {
            Block b = Block.func_149634_a((Item)stack.func_77973_b());
            if (b != null) {
                String aTool = b.getHarvestTool(stack.func_77960_j());
                int aMiningLevel1 = b.getHarvestLevel(stack.func_77960_j());
                list.add("Mining Level: " + Math.min(Math.max(aMiningLevel1, 0), 5));
                if (this.mMaterial != null) {
                    list.add("Contains:    ");
                    if (this.mMaterial.getComposites().isEmpty()) {
                        list.add("- " + this.mMaterial.getLocalizedName());
                    } else {
                        for (MaterialStack m : this.mMaterial.getComposites()) {
                            list.add("- " + m.getStackMaterial().getLocalizedName() + " x" + m.getPartsPerOneHundred());
                        }
                    }
                }
            }
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + "Hold Ctrl to show additional info.");
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (this.sRadiation > 0) {
            EntityUtils.applyRadiationDamageToEntity(iStack.field_77994_a, this.sRadiation, world, entityHolding);
        }
    }
}

