/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.data.StringUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseItemComponent
extends Item {
    private static final Class<TextureSet> mTextureSetPreload = TextureSet.class;
    public final Material componentMaterial;
    public final String materialName;
    public final String unlocalName;
    public final ComponentTypes componentType;
    public final int componentColour;
    public Object extraData;
    protected IIcon base;
    protected IIcon overlay;

    public BaseItemComponent(Material material, ComponentTypes componentType) {
        this.componentMaterial = material;
        this.unlocalName = "item" + componentType.COMPONENT_NAME + material.getUnlocalizedName();
        this.materialName = material.getLocalizedName();
        this.componentType = componentType;
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(this.unlocalName);
        this.func_77625_d(64);
        this.componentColour = material.getRgbAsHex();
        GameRegistry.registerItem((Item)this, (String)this.unlocalName);
        GT_OreDictUnificator.registerOre((Object)(componentType.getOreDictName() + material.getUnlocalizedName()), (ItemStack)ItemUtils.getSimpleStack(this));
        if (componentType == ComponentTypes.GEAR) {
            GT_OreDictUnificator.registerOre((Object)("gear" + material.getUnlocalizedName()), (ItemStack)ItemUtils.getSimpleStack(this));
        }
        if (!LoadedMods.Thaumcraft || this.componentMaterial.isRadioactive) {
            // empty if block
        }
        this.registerComponent();
    }

    public BaseItemComponent(String unlocalName, String localName, short[] RGBA) {
        String aFormattedNameForFluids = unlocalName.contains(".") ? StringUtils.splitAndUppercase(unlocalName, ".") : unlocalName;
        Material aTempMaterial = Material.mMaterialCache.get(localName.toLowerCase());
        Logger.INFO("Attempted to get " + localName + " cell material from cache. Valid? " + (aTempMaterial != null));
        this.componentMaterial = aTempMaterial;
        this.unlocalName = "itemCell" + aFormattedNameForFluids;
        this.materialName = localName;
        this.componentType = ComponentTypes.CELL;
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(aFormattedNameForFluids);
        this.func_77625_d(64);
        this.componentColour = MathUtils.getRgbAsHex(RGBA);
        this.extraData = RGBA;
        this.func_111206_d("miscutils:item" + ComponentTypes.CELL.COMPONENT_NAME);
        GameRegistry.registerItem((Item)this, (String)aFormattedNameForFluids);
        GT_OreDictUnificator.registerOre((Object)(ComponentTypes.CELL.getOreDictName() + Utils.sanitizeStringKeepBrackets(localName)), (ItemStack)ItemUtils.getSimpleStack(this));
        this.registerComponent();
    }

    public boolean registerComponent() {
        String aKey;
        ItemStack x;
        if (this.componentMaterial == null) {
            return false;
        }
        Map<String, ItemStack> aMap = Material.mComponentMap.get(this.componentMaterial.getUnlocalizedName());
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        if ((x = aMap.get(aKey = this.componentType.getGtOrePrefix().name())) == null) {
            aMap.put(aKey, ItemUtils.getSimpleStack(this));
            Logger.MATERIALS("Registering a material component. Item: [" + this.componentMaterial.getUnlocalizedName() + "] Map: [" + aKey + "]");
            Material.mComponentMap.put(this.componentMaterial.getUnlocalizedName(), aMap);
            if (this.componentType == ComponentTypes.PLATE) {
                GregTech_API.registerCover((ItemStack)this.componentMaterial.getPlate(1), (ITexture)new GT_RenderedTexture(this.componentMaterial.getTextureSet().mTextures[71], this.componentMaterial.getRGBA(), false), null);
            } else if (this.componentType == ComponentTypes.PLATEDOUBLE) {
                GregTech_API.registerCover((ItemStack)this.componentMaterial.getPlateDouble(1), (ITexture)new GT_RenderedTexture(this.componentMaterial.getTextureSet().mTextures[72], this.componentMaterial.getRGBA(), false), null);
            }
            return true;
        }
        Logger.MATERIALS("Tried to double register a material component. ");
        return false;
    }

    public String getCorrectTextures() {
        TextureSet u;
        if (!CORE.ConfigSwitches.useGregtechTextures) {
            return "miscutils:item" + this.componentType.COMPONENT_NAME;
        }
        String metType = "9j4852jyo3rjmh3owlhw9oe";
        if (this.componentMaterial != null && (u = this.componentMaterial.getTextureSet()) != null) {
            metType = u.mSetName;
        }
        metType = metType.equals("9j4852jyo3rjmh3owlhw9oe") ? "METALLIC" : metType;
        return "gregtech:materialicons/" + metType + "/" + this.componentType.getOreDictName();
    }

    public final String getMaterialName() {
        return this.materialName;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.componentMaterial == null) {
            String aFormattedLangName = this.componentType.getName();
            if (!aFormattedLangName.startsWith(" ") && aFormattedLangName.contains("@")) {
                String[] aSplit = aFormattedLangName.split("@");
                aFormattedLangName = aSplit[0] + " " + this.getMaterialName() + " " + aSplit[1];
            }
            if (aFormattedLangName.equals(this.componentType.getName())) {
                aFormattedLangName = this.getMaterialName() + aFormattedLangName;
            }
            return GT_LanguageManager.addStringLocalization((String)this.unlocalName, (String)aFormattedLangName);
        }
        String aFormattedLangName = this.componentType.getName();
        if (!aFormattedLangName.startsWith(" ") && aFormattedLangName.contains("@")) {
            String[] aSplit = aFormattedLangName.split("@");
            aFormattedLangName = aSplit[0] + " " + this.componentMaterial.getLocalizedName() + " " + aSplit[1];
        }
        if (aFormattedLangName.equals(this.componentType.getName())) {
            aFormattedLangName = this.componentMaterial.getLocalizedName() + aFormattedLangName;
        }
        return GT_LanguageManager.addStringLocalization((String)this.unlocalName, (String)aFormattedLangName);
    }

    public final void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        try {
            if (this.componentMaterial != null || this.materialName != null) {
                // empty if block
            }
            if (this.materialName != null && this.materialName != "" && !this.materialName.equals("") && this.componentMaterial != null) {
                if (this.componentMaterial != null) {
                    if (!this.componentMaterial.vChemicalFormula.contains("?")) {
                        list.add(Utils.sanitizeStringKeepBrackets(this.componentMaterial.vChemicalFormula));
                    } else if (this.componentMaterial.vChemicalFormula.contains("?")) {
                        String temp = this.componentMaterial.vChemicalFormula;
                        temp = temp.replace(" ", "");
                        temp = temp.replace("-", "");
                        temp = temp.replace("_", "");
                        temp = temp.replace("!", "");
                        temp = temp.replace("@", "");
                        temp = temp.replace("#", "");
                        temp = temp.replace(" ", "");
                        list.add(temp);
                    }
                    if (this.componentMaterial.isRadioactive) {
                        list.add(CORE.GT_Tooltip_Radioactive);
                    }
                    if ((this.componentType == ComponentTypes.INGOT || this.componentType == ComponentTypes.HOTINGOT) && this.materialName != null && this.materialName != "" && !this.materialName.equals("") && this.unlocalName.toLowerCase().contains("hot")) {
                        list.add(EnumChatFormatting.GRAY + "Warning: " + EnumChatFormatting.RED + "Very hot! " + EnumChatFormatting.GRAY + " Avoid direct handling..");
                    }
                } else {
                    String aChemicalFormula = Material.sChemicalFormula.get(this.materialName.toLowerCase());
                    if (aChemicalFormula != null && aChemicalFormula.length() > 0) {
                        list.add(Utils.sanitizeStringKeepBrackets(aChemicalFormula));
                    }
                }
                if (KeyboardUtils.isCtrlKeyDown()) {
                    if (this.componentMaterial != null) {
                        String type = this.componentMaterial.getTextureSet().mSetName;
                        String output = type.substring(0, 1).toUpperCase() + type.substring(1);
                        list.add(EnumChatFormatting.GRAY + "Material Type: " + output + ".");
                        list.add(EnumChatFormatting.GRAY + "Material State: " + this.componentMaterial.getState().name() + ".");
                        list.add(EnumChatFormatting.GRAY + "Radioactivity Level: " + this.componentMaterial.vRadiationLevel + ".");
                    }
                } else {
                    list.add(EnumChatFormatting.DARK_GRAY + "Hold Ctrl to show additional info.");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (this.componentMaterial != null && entityHolding instanceof EntityPlayer && !((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d) {
            EntityUtils.applyRadiationDamageToEntity(iStack.field_77994_a, this.componentMaterial.vRadiationLevel, world, entityHolding);
        }
        if (this.extraData != null && this.componentMaterial != null && this.componentMaterial.getRGBA()[3] > 1) {
            Short aCurrentFrame;
            if (((Map)this.extraData).get(9999) == null) {
                ((Map)this.extraData).put(9999, new Short[]{(short)0});
            }
            short fC = (short)((aCurrentFrame = ((Short[])((Map)this.extraData).get(9999))[0]) >= Short.MAX_VALUE ? 0 : aCurrentFrame + 1);
            ((Map)this.extraData).put(9999, new Short[]{fC, (short)0});
            ((Map)this.extraData).put(9998, new Short[]{aCurrentFrame, (short)0});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return CORE.ConfigSwitches.useGregtechTextures;
    }

    /*
     * Opcode count of 13995 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (this.componentType == ComponentTypes.CELL || this.componentType == ComponentTypes.PLASMACELL) {
            if (renderPass == 0 && !CORE.ConfigSwitches.useGregtechTextures) {
                return Utils.rgbtoHexValue(255, 255, 255);
            }
            if (renderPass == 1 && CORE.ConfigSwitches.useGregtechTextures) {
                return Utils.rgbtoHexValue(255, 255, 255);
            }
        }
        if (this.componentType == ComponentTypes.PLATEHEAVY) {
            // empty if block
        }
        try {
            if (this.componentMaterial == null) {
                if (this.extraData != null && Short.TYPE.isInstance(this.extraData)) {
                    short[] abc = (short[])this.extraData;
                    return Utils.rgbtoHexValue(abc[0], abc[1], abc[2]);
                }
                return this.componentColour;
            }
            if (this.componentMaterial.getRGBA()[3] <= 1) {
                return this.componentColour;
            }
            if (this.componentMaterial.getRGBA()[3] == 2) {
                if (this.extraData == null) {
                    this.extraData = new HashMap();
                    ((Map)this.extraData).put(Short.MAX_VALUE, new Short[]{(short)0});
                    ((Map)this.extraData).put(32766, new Short[]{(short)0});
                    short[] er = this.componentMaterial.getRGBA();
                    int value = 0;
                    Short[] ht = new Short[]{er[0], er[1], er[2]};
                    int aMaxCycles = 200;
                    for (int y = 0; y < aMaxCycles; ++y) {
                        value = y < 50 ? 1 : (y < 100 ? 0 : (y < 150 ? -1 : 0));
                        short r = (short)Math.max(Math.min(255, ht[0] + value), 0);
                        short g = (short)Math.max(Math.min(255, ht[1] + value), 0);
                        short b = (short)Math.max(Math.min(255, ht[2] + value), 0);
                        Short[] qq = new Short[]{(short)Math.min(255, r), (short)Math.min(255, g), (short)Math.min(255, b)};
                        ht = qq;
                        ((Map)this.extraData).put(y, qq);
                    }
                    ((Map)this.extraData).put(32765, new Short[]{(short)(((Map)this.extraData).size() - 1)});
                }
                if (this.extraData != null) {
                    Short aCurrentFrame = ((Short[])((Map)this.extraData).get(Short.MAX_VALUE))[0];
                    Short aSize = (short)(((Map)this.extraData).size() - 3);
                    short nextFrame = (short)(aCurrentFrame < aSize ? aCurrentFrame + 1 : 0);
                    Short[] aCurrentFrameRGB = (Short[])((Map)this.extraData).get(aCurrentFrame < aSize ? aCurrentFrame : (short)0);
                    ((Map)this.extraData).put(Short.MAX_VALUE, new Short[]{nextFrame});
                    return Utils.rgbtoHexValue(aCurrentFrameRGB[0].shortValue(), aCurrentFrameRGB[1].shortValue(), aCurrentFrameRGB[2].shortValue());
                }
            } else if (this.componentMaterial.getRGBA()[3] == 3) {
                if (this.extraData == null) {
                    this.extraData = new HashMap();
                    ((Map)this.extraData).put(Short.MAX_VALUE, new Short[]{(short)0});
                    ((Map)this.extraData).put(32766, new Short[]{(short)0});
                    int aSlot = 0;
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)255, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)204, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)153, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)102, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)51, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)0});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)255, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)204, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)153, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)102, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)51, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)0, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)51, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)102, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)153, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)204, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)255});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)204});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)153});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)102});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(aSlot++, new Short[]{(short)0, (short)255, (short)51});
                    ((Map)this.extraData).put(32765, new Short[]{(short)(((Map)this.extraData).size() - 1)});
                }
                if (this.extraData != null) {
                    Short aCurrentFrame = ((Short[])((Map)this.extraData).get(Short.MAX_VALUE))[0];
                    Short aSize = (short)(((Map)this.extraData).size() - 3);
                    short nextFrame = (short)(aCurrentFrame < aSize ? aCurrentFrame + 1 : 0);
                    Short[] aCurrentFrameRGB = (Short[])((Map)this.extraData).get(aCurrentFrame < aSize ? aCurrentFrame : (short)0);
                    ((Map)this.extraData).put(Short.MAX_VALUE, new Short[]{nextFrame});
                    return Utils.rgbtoHexValue(aCurrentFrameRGB[0].shortValue(), aCurrentFrameRGB[1].shortValue(), aCurrentFrameRGB[2].shortValue());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.componentColour;
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (CORE.ConfigSwitches.useGregtechTextures) {
            if (pass == 0) {
                return this.base;
            }
            return this.overlay;
        }
        return this.base;
    }

    public void func_94581_a(IIconRegister i) {
        if (CORE.ConfigSwitches.useGregtechTextures) {
            this.base = i.func_94245_a(this.getCorrectTextures());
            this.overlay = i.func_94245_a(this.getCorrectTextures() + "_OVERLAY");
        } else {
            this.base = i.func_94245_a(this.getCorrectTextures());
        }
    }

    public static enum ComponentTypes {
        DUST("Dust", " Dust", "dust", OrePrefixes.dust),
        DUSTSMALL("DustSmall", "Small Pile of@Dust", "dustSmall", OrePrefixes.dustSmall),
        DUSTTINY("DustTiny", "Tiny Pile of@Dust", "dustTiny", OrePrefixes.dustTiny),
        INGOT("Ingot", " Ingot", "ingot", OrePrefixes.ingot),
        HOTINGOT("HotIngot", "Hot@Ingot", "ingotHot", OrePrefixes.ingotHot),
        PLATE("Plate", " Plate", "plate", OrePrefixes.plate),
        PLATEDOUBLE("PlateDouble", " Double Plate", "plateDouble", OrePrefixes.plateDouble),
        ROD("Rod", " Rod", "stick", OrePrefixes.stick),
        RODLONG("RodLong", " Long Rod", "stickLong", OrePrefixes.stickLong),
        GEAR("Gear", " Gear", "gearGt", OrePrefixes.gearGt),
        SMALLGEAR("SmallGear", " Gear", "gearGtSmall", OrePrefixes.gearGtSmall),
        SCREW("Screw", " Screw", "screw", OrePrefixes.screw),
        BOLT("Bolt", " Bolt", "bolt", OrePrefixes.bolt),
        ROTOR("Rotor", " Rotor", "rotor", OrePrefixes.rotor),
        RING("Ring", " Ring", "ring", OrePrefixes.ring),
        FOIL("Foil", " Foil", "foil", OrePrefixes.foil),
        PLASMACELL("CellPlasma", " Plasma Cell", "cellPlasma", OrePrefixes.cellPlasma),
        CELL("Cell", " Cell", "cell", OrePrefixes.cell),
        NUGGET("Nugget", " Nugget", "nugget", OrePrefixes.nugget),
        PLATEHEAVY("HeavyPlate", "Heavy@Plate", "plateHeavy", OrePrefixes.plateDense),
        SPRING("Spring", " Spring", "spring", OrePrefixes.spring),
        SMALLSPRING("SmallSpring", "Small@Spring", "springSmall", OrePrefixes.springSmall),
        FINEWIRE("FineWire", "Fine@Wire", "wireFine", OrePrefixes.wireFine);

        private String COMPONENT_NAME;
        private String DISPLAY_NAME;
        private String OREDICT_NAME;
        private OrePrefixes a_GT_EQUAL;

        private ComponentTypes(String LocalName, String DisplayName, String OreDictName, OrePrefixes aPrefix) {
            this.COMPONENT_NAME = LocalName;
            this.DISPLAY_NAME = DisplayName;
            this.OREDICT_NAME = OreDictName;
            this.a_GT_EQUAL = aPrefix;
        }

        public String getComponent() {
            return this.COMPONENT_NAME;
        }

        public String getName() {
            return this.DISPLAY_NAME;
        }

        public String getOreDictName() {
            return this.OREDICT_NAME;
        }

        public OrePrefixes getGtOrePrefix() {
            return this.a_GT_EQUAL;
        }
    }
}

