/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.fluids;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.core.util.Utils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockFluidBase
extends BlockFluidClassic {
    @SideOnly(value=Side.CLIENT)
    protected static IIcon stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected static IIcon flowingIcon;
    protected final short[] mRGB;

    public BlockFluidBase(Fluid fluid, short[] aRGB) {
        this(fluid, Material.field_151586_h, aRGB);
    }

    public BlockFluidBase(Fluid fluid, Material material, short[] aRGB) {
        super(fluid, material);
        this.mRGB = aRGB;
        this.func_149711_c(100.0f);
        this.func_149713_g(3);
        this.func_149649_H();
    }

    public void func_149670_a(World world, int x, int y, int z, Entity ent) {
        if (!(ent instanceof EntityLivingBase)) {
            return;
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? stillIcon : flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (stillIcon == null) {
            stillIcon = register.func_94245_a("miscutils:fluids/fluid.fluid.autogenerated.still");
        }
        if (flowingIcon == null) {
            flowingIcon = register.func_94245_a("miscutils:fluids/fluid.fluid.autogenerated.flowing");
        }
    }

    public int func_149635_D() {
        if (this.mRGB != null && this.mRGB.length >= 3) {
            return Utils.rgbtoHexValue(this.mRGB[0], this.mRGB[1], this.mRGB[2]);
        }
        return super.func_149635_D();
    }

    public int func_149741_i(int aMeta) {
        if (this.mRGB != null && this.mRGB.length >= 3) {
            return Utils.rgbtoHexValue(this.mRGB[0], this.mRGB[1], this.mRGB[2]);
        }
        return super.func_149741_i(aMeta);
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        return super.recolourBlock(world, x, y, z, side, colour);
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }
}

