/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.item.base.itemblock.ItemBlockGtBlock;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class BlockBaseModular
extends BasicBlock {
    protected gtPlusPlus.core.material.Material field_149764_J;
    protected int blockColour;
    public BasicBlock.BlockTypes thisBlock;
    protected String thisBlockMaterial;
    protected final String thisBlockType;
    private static HashMap<String, Block> sBlockCache = new HashMap();

    public static Block getMaterialBlock(gtPlusPlus.core.material.Material aMaterial, BasicBlock.BlockTypes aType) {
        return sBlockCache.get(aMaterial.getUnlocalizedName() + "." + aType.name());
    }

    public BlockBaseModular(gtPlusPlus.core.material.Material material, BasicBlock.BlockTypes blockType) {
        this(material, blockType, material.getRgbAsHex());
    }

    public BlockBaseModular(gtPlusPlus.core.material.Material material, BasicBlock.BlockTypes blockType, int colour) {
        this(material.getUnlocalizedName(), material.getLocalizedName(), Material.field_151573_f, blockType, colour, Math.min(Math.max(material.vTier, 1), 6));
        this.field_149764_J = material;
        this.registerComponent();
        if (material != null) {
            sBlockCache.put(material.getUnlocalizedName() + "." + blockType.name(), (Block)this);
        }
    }

    protected BlockBaseModular(String unlocalizedName, String blockMaterialString, Material vanillaMaterial, BasicBlock.BlockTypes blockType, int colour, int miningLevel) {
        super(blockType, unlocalizedName, vanillaMaterial, miningLevel);
        this.setHarvestLevel(blockType.getHarvestTool(), miningLevel);
        this.func_149658_d("miscutils:" + blockType.getTexture());
        this.blockColour = colour;
        this.thisBlock = blockType;
        this.thisBlockMaterial = blockMaterialString;
        this.thisBlockType = blockType.name().toUpperCase();
        this.func_149663_c(this.GetProperName());
        int fx = this.getBlockTypeMeta();
        GameRegistry.registerBlock((Block)this, ItemBlockGtBlock.class, (String)Utils.sanitizeString(blockType.getTexture() + unlocalizedName));
        if (fx == 0) {
            GT_OreDictUnificator.registerOre((Object)("block" + BlockBaseModular.unifyMaterialName(this.thisBlockMaterial)), (ItemStack)ItemUtils.getSimpleStack((Block)this));
        } else if (fx == 1) {
            GT_OreDictUnificator.registerOre((Object)("frameGt" + BlockBaseModular.unifyMaterialName(this.thisBlockMaterial)), (ItemStack)ItemUtils.getSimpleStack((Block)this));
        } else if (fx == 2) {
            GT_OreDictUnificator.registerOre((Object)("frameGt" + BlockBaseModular.unifyMaterialName(this.thisBlockMaterial)), (ItemStack)ItemUtils.getSimpleStack((Block)this));
        }
    }

    public static String unifyMaterialName(String rawMaterName) {
        return rawMaterName.replace(" ", "").replace("-", "").replace("_", "");
    }

    public boolean registerComponent() {
        int fx;
        String aKey;
        ItemStack x;
        Logger.MATERIALS("Attempting to register " + this.func_149739_a() + ".");
        if (this.field_149764_J == null) {
            Logger.MATERIALS("Tried to register " + this.func_149739_a() + " but the material was null.");
            return false;
        }
        String aName = this.field_149764_J.getUnlocalizedName();
        Map<String, ItemStack> aMap = gtPlusPlus.core.material.Material.mComponentMap.get(aName);
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        if ((x = aMap.get(aKey = (fx = this.getBlockTypeMeta()) == 0 ? OrePrefixes.block.name() : (fx == 1 ? OrePrefixes.frameGt.name() : OrePrefixes.ore.name()))) == null) {
            aMap.put(aKey, ItemUtils.getSimpleStack((Block)this));
            Logger.MATERIALS("Registering a material component. Item: [" + aName + "] Map: [" + aKey + "]");
            gtPlusPlus.core.material.Material.mComponentMap.put(aName, aMap);
            return true;
        }
        Logger.MATERIALS("Tried to double register a material component.");
        return false;
    }

    public int getBlockTypeMeta() {
        if (this.thisBlockType.equals(BasicBlock.BlockTypes.STANDARD.name().toUpperCase())) {
            return 0;
        }
        if (this.thisBlockType.equals(BasicBlock.BlockTypes.FRAME.name().toUpperCase())) {
            return 1;
        }
        if (this.thisBlockType.equals(BasicBlock.BlockTypes.ORE.name().toUpperCase())) {
            return 2;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        if (this.thisBlock == BasicBlock.BlockTypes.FRAME) {
            return 1;
        }
        return 0;
    }

    public String GetProperName() {
        String tempIngot = null;
        if (this.thisBlock == BasicBlock.BlockTypes.STANDARD) {
            tempIngot = "Block of " + this.thisBlockMaterial;
        } else if (this.thisBlock == BasicBlock.BlockTypes.FRAME) {
            tempIngot = this.thisBlockMaterial + " Frame Box";
        } else if (this.thisBlock == BasicBlock.BlockTypes.ORE) {
            tempIngot = this.thisBlockMaterial + " Ore [Old]";
        }
        return tempIngot;
    }

    public String func_149732_F() {
        String aFormattedLangName = this.GetProperName();
        return GT_LanguageManager.addStringLocalization((String)("block." + this.field_149764_J.getUnlocalizedName() + "." + this.thisBlock.name().toLowerCase() + ".name"), (String)aFormattedLangName);
    }

    public String func_149739_a() {
        return "block." + this.field_149764_J.getUnlocalizedName() + "." + this.thisBlock.name().toLowerCase();
    }

    public boolean func_149662_c() {
        return false;
    }

    public gtPlusPlus.core.material.Material getMaterialEx() {
        return this.field_149764_J;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIcon) {
        int tier;
        TextureSet u;
        if (!CORE.ConfigSwitches.useGregtechTextures || this.field_149764_J == null || this.thisBlock == BasicBlock.BlockTypes.ORE) {
            this.field_149761_L = iIcon.func_94245_a("miscutils:" + this.thisBlock.getTexture());
        }
        String metType = "9j4852jyo3rjmh3owlhw9oe";
        if (this.field_149764_J != null && (u = this.field_149764_J.getTextureSet()) != null) {
            metType = u.mSetName;
        }
        metType = metType.equals("9j4852jyo3rjmh3owlhw9oe") ? "METALLIC" : metType;
        int n = tier = this.field_149764_J != null ? this.field_149764_J.vTier : 0;
        String aType = this.thisBlock == BasicBlock.BlockTypes.FRAME ? "frameGt" : (tier <= 4 ? "block1" : "block5");
        this.field_149761_L = iIcon.func_94245_a("gregtech:materialicons/" + metType + "/" + aType);
    }

    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.blockColour == 0) {
            return MathUtils.generateSingularRandomHexValue();
        }
        return this.blockColour;
    }

    public int func_149741_i(int aMeta) {
        if (this.blockColour == 0) {
            return MathUtils.generateSingularRandomHexValue();
        }
        return this.blockColour;
    }

    public int func_149635_D() {
        if (this.blockColour == 0) {
            return MathUtils.generateSingularRandomHexValue();
        }
        return this.blockColour;
    }
}

