/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia.world;

import cpw.mods.fml.common.IWorldGenerator;
import gtPlusPlus.api.interfaces.IGeneratorWorld;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.australia.GTplusplus_Australia;
import gtPlusPlus.australia.gen.map.component.ComponentHut;
import gtPlusPlus.australia.gen.map.component.ComponentShack;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class AustraliaWorldGenerator
implements IWorldGenerator {
    private LinkedList<ChunkCoordIntPair> structuresList = new LinkedList();
    private final ComponentShack.WorldHandlerShack shackGen;
    private final ComponentHut.WorldHandlerHut hutGen;
    private final List<IGeneratorWorld> generators;
    private int midX;
    private int midZ;
    int field_82665_g;
    int field_82666_h = 8;
    public static final AutoMap<Integer> SHACK_ALLOWED_BIOMES = new AutoMap();
    public static final AutoMap<Integer> HUT_ALLOWED_BIOMES = new AutoMap();
    public static final AutoMap<Integer> ALLOWED_BIOMES = new AutoMap();

    public AustraliaWorldGenerator() {
        SHACK_ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Plains_Biome.field_76756_M);
        SHACK_ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Forest_Biome.field_76756_M);
        HUT_ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Desert_Biome_3.field_76756_M);
        HUT_ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Outback_Biome.field_76756_M);
        ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Plains_Biome.field_76756_M);
        ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Forest_Biome.field_76756_M);
        ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Desert_Biome_3.field_76756_M);
        ALLOWED_BIOMES.put(GTplusplus_Australia.Australian_Outback_Biome.field_76756_M);
        this.shackGen = new ComponentShack.WorldHandlerShack(3.0);
        this.hutGen = new ComponentHut.WorldHandlerHut(5.0);
        this.generators = Arrays.asList(this.shackGen, this.hutGen);
        this.field_82665_g = 8 + Math.max(MathUtils.randInt(32, 64), 1);
        this.midX = 0;
        this.midZ = 0;
        for (IGeneratorWorld gen : this.generators) {
            this.midX = Math.max(this.midX, gen.getExtentX() / 2);
            this.midZ = Math.max(this.midZ, gen.getExtentZ() / 2);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == CORE.AUSTRALIA_ID) {
            this.generateOverworld(world, world.field_73012_v, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateOverworld(World world, Random random, int x, int z) {
        block7: {
            boolean gen = false;
            try {
                if (!ALLOWED_BIOMES.containsValue(world.func_72807_a((int)(x + this.midX), (int)(z + this.midZ)).field_76756_M)) break block7;
                Collections.shuffle(this.generators, random);
                for (IGeneratorWorld generator : this.generators) {
                    boolean canGenerate = false;
                    if (generator instanceof ComponentShack.WorldHandlerShack) {
                        if (SHACK_ALLOWED_BIOMES.containsValue(world.func_72807_a((int)(x + this.midX), (int)(z + this.midZ)).field_76756_M)) {
                            canGenerate = true;
                        }
                    } else if (generator instanceof ComponentHut.WorldHandlerHut && HUT_ALLOWED_BIOMES.containsValue(world.func_72807_a((int)(x + this.midX), (int)(z + this.midZ)).field_76756_M)) {
                        canGenerate = true;
                    }
                    if (!canGenerate) continue;
                    boolean a1 = generator.generate(world, random, x, z);
                    boolean a2 = this.nonInRange(world, x, z, generator.getRange());
                    if (!a1 || !a2) continue;
                    this.structuresList.add(new ChunkCoordIntPair(x, z));
                    gen = true;
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected boolean nonInRange(World worldObj, int x, int z, int range) {
        int par1 = x / 16;
        int par2 = z / 16;
        int k = par1;
        int l = par2;
        if (par1 < 0) {
            par1 -= this.field_82665_g - 1;
        }
        if (par2 < 0) {
            par2 -= this.field_82665_g - 1;
        }
        int i1 = par1 / this.field_82665_g;
        int j1 = par2 / this.field_82665_g;
        Random random = worldObj.func_72843_D(i1, j1, 10387312);
        i1 *= this.field_82665_g;
        j1 *= this.field_82665_g;
        return k == (i1 += random.nextInt(this.field_82665_g - this.field_82666_h)) && l == (j1 += random.nextInt(this.field_82665_g - this.field_82666_h));
    }

    public void initiate() {
        this.structuresList.clear();
    }
}

