/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia.gen.map.component;

import gtPlusPlus.api.interfaces.IGeneratorWorld;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.australia.GTplusplus_Australia;
import gtPlusPlus.australia.gen.map.component.AustraliaComponent;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.plugin.villagers.entity.EntityNativeAustralian;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentHut
extends AustraliaComponent {
    public static final int DIM_X = 7;
    public static final int DIM_Y = 10;
    public static final int DIM_Z = 7;
    private int nativesSpawned = 0;
    public static final WeightedRandomChestContent[] shackChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151069_bo, 0, 1, 1, 10), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151034_e, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151101_aQ, 0, 1, 3, 10), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150345_g), 1, 1, 1, 15), new WeightedRandomChestContent(Items.field_151037_a, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151035_b, 0, 1, 1, 5)};
    private boolean hasMadeChest;
    private static final String CHEST_KEY = "AUSShackChest";

    public ComponentHut() {
    }

    public ComponentHut(int direction, Random random, int x, int z) {
        super(direction, random, x, z, 7, 10, 7);
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        Block aFloor;
        Block aRoof;
        Block aWall2;
        BlockSand aWall1;
        BiomeGenBase biom = world.func_72807_a(this.func_74865_a(0, 0), this.func_74873_b(0, 0));
        int groundAvg = this.calcGroundHeight(world, this.field_74887_e);
        if (groundAvg < 0) {
            return true;
        }
        this.field_74887_e.func_78886_a(0, groundAvg - this.field_74887_e.field_78894_e + 10 - 1, 0);
        if (this.isWaterBelow(world, 0, -1, 0, this.field_74887_e) || this.isWaterBelow(world, 0, -1, 6, this.field_74887_e) || this.isWaterBelow(world, 6, -1, 0, this.field_74887_e) || this.isWaterBelow(world, 6, -1, 6, this.field_74887_e)) {
            return false;
        }
        if (biom.field_76756_M == GTplusplus_Australia.Australian_Desert_Biome_3.field_76756_M) {
            aWall1 = Blocks.field_150354_m;
            aWall2 = Blocks.field_150322_A;
            aRoof = Blocks.field_150322_A;
            aFloor = Blocks.field_150322_A;
        } else if (biom.field_76756_M == GTplusplus_Australia.Australian_Outback_Biome.field_76756_M) {
            aWall1 = Blocks.field_150435_aG;
            aWall2 = Blocks.field_150405_ch;
            aRoof = Blocks.field_150405_ch;
            aFloor = Blocks.field_150406_ce;
        } else {
            aWall1 = Blocks.field_150354_m;
            aWall2 = Blocks.field_150322_A;
            aRoof = Blocks.field_150322_A;
            aFloor = Blocks.field_150322_A;
        }
        this.func_74878_a(world, this.field_74887_e, 0, 1, 0, 6, 9, 6);
        this.func_151556_a(world, this.field_74887_e, 0, 0, 0, 6, 0, 6, aFloor, 0, aFloor, 1, false);
        int dir = MathUtils.randInt(0, 3);
        if (dir == 0) {
            this.func_74881_a(world, this.field_74887_e, random, 0, 1, 3, this.func_151555_a(Blocks.field_150466_ao, 1));
        } else if (dir == 1) {
            this.func_74881_a(world, this.field_74887_e, random, 3, 1, 6, this.func_151555_a(Blocks.field_150466_ao, 1));
        } else if (dir == 2) {
            this.func_74881_a(world, this.field_74887_e, random, 6, 1, 3, this.func_151555_a(Blocks.field_150466_ao, 1));
        } else {
            this.func_74881_a(world, this.field_74887_e, random, 3, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
        }
        this.place((Block)aWall1, 0, 0, 1, 2, this.field_74887_e, world);
        if (dir != 0) {
            this.place((Block)aWall1, 0, 0, 1, 3, this.field_74887_e, world);
        }
        this.place((Block)aWall1, 0, 0, 1, 4, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 2, 1, 6, this.field_74887_e, world);
        if (dir != 1) {
            this.place(aWall2, 0, 3, 1, 6, this.field_74887_e, world);
        }
        this.place((Block)aWall1, 0, 4, 1, 6, this.field_74887_e, world);
        this.place(aWall2, 0, 6, 1, 4, this.field_74887_e, world);
        if (dir != 2) {
            this.place((Block)aWall1, 0, 6, 1, 3, this.field_74887_e, world);
        }
        this.place((Block)aWall1, 0, 6, 1, 2, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 4, 1, 0, this.field_74887_e, world);
        if (dir != 3) {
            this.place((Block)aWall1, 0, 3, 1, 0, this.field_74887_e, world);
        }
        this.place(aWall2, 0, 2, 1, 0, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 1, 1, 5, this.field_74887_e, world);
        this.place(aWall2, 0, 5, 1, 5, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 5, 1, 1, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 1, 1, 1, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 0, 2, 2, this.field_74887_e, world);
        this.place(aWall2, 0, 0, 2, 4, this.field_74887_e, world);
        this.place(aWall2, 0, 2, 2, 6, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 4, 2, 6, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 6, 2, 4, this.field_74887_e, world);
        this.place(aWall2, 0, 6, 2, 2, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 4, 2, 0, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 2, 2, 0, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 1, 2, 5, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 5, 2, 5, this.field_74887_e, world);
        this.place(aWall2, 0, 5, 2, 1, this.field_74887_e, world);
        this.place(aWall2, 0, 1, 2, 1, this.field_74887_e, world);
        this.place(aWall2, 0, 0, 3, 2, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 0, 3, 3, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 0, 3, 4, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 2, 3, 6, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 3, 3, 6, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 4, 3, 6, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 6, 3, 4, this.field_74887_e, world);
        this.place(aWall2, 0, 6, 3, 3, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 6, 3, 2, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 4, 3, 0, this.field_74887_e, world);
        this.place(aWall2, 0, 3, 3, 0, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 2, 3, 0, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 1, 3, 5, this.field_74887_e, world);
        this.place(aWall2, 0, 5, 3, 5, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 5, 3, 1, this.field_74887_e, world);
        this.place((Block)aWall1, 0, 1, 3, 1, this.field_74887_e, world);
        this.place(aRoof, 0, 1, 4, 2, this.field_74887_e, world);
        this.place(aRoof, 0, 1, 4, 3, this.field_74887_e, world);
        this.place(aRoof, 0, 1, 4, 4, this.field_74887_e, world);
        this.place(aRoof, 0, 2, 4, 5, this.field_74887_e, world);
        this.place(aRoof, 0, 3, 4, 5, this.field_74887_e, world);
        this.place(aRoof, 0, 4, 4, 5, this.field_74887_e, world);
        this.place(aRoof, 0, 5, 4, 4, this.field_74887_e, world);
        this.place(aRoof, 0, 5, 4, 3, this.field_74887_e, world);
        this.place(aRoof, 0, 5, 4, 2, this.field_74887_e, world);
        this.place(aRoof, 0, 4, 4, 1, this.field_74887_e, world);
        this.place(aRoof, 0, 3, 4, 1, this.field_74887_e, world);
        this.place(aRoof, 0, 2, 4, 1, this.field_74887_e, world);
        this.place(aRoof, 0, 2, 5, 2, this.field_74887_e, world);
        this.place(aRoof, 0, 2, 5, 3, this.field_74887_e, world);
        this.place(aRoof, 0, 2, 5, 4, this.field_74887_e, world);
        this.place(aRoof, 0, 3, 5, 4, this.field_74887_e, world);
        this.place(aRoof, 0, 4, 5, 4, this.field_74887_e, world);
        this.place(aRoof, 0, 4, 5, 3, this.field_74887_e, world);
        this.place(aRoof, 0, 4, 5, 2, this.field_74887_e, world);
        this.place(aRoof, 0, 3, 5, 2, this.field_74887_e, world);
        this.place(Blocks.field_150426_aN, 0, 3, 5, 3, this.field_74887_e, world);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.func_74871_b(world, j, 6, i, this.field_74887_e);
                this.func_151554_b(world, aFloor, 0, j, 0, i, this.field_74887_e);
            }
        }
        this.spawnNatives(world, this.field_74887_e, 4, 1, 3, MathUtils.randInt(3, 5));
        return true;
    }

    private void spawnNatives(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int maxSpawned) {
        if (this.nativesSpawned < maxSpawned) {
            int l1;
            int k1;
            int j1;
            for (int i1 = this.nativesSpawned; i1 < maxSpawned && par2StructureBoundingBox.func_78890_b(j1 = this.func_74865_a(par3 + i1, par5), k1 = this.func_74862_a(par4), l1 = this.func_74873_b(par3 + i1, par5)); ++i1) {
                if (par1World.field_73012_v.nextInt(MathUtils.randInt(3, 5)) == 0) continue;
                EntityNativeAustralian entityvillager = new EntityNativeAustralian(par1World);
                entityvillager.func_110163_bv();
                entityvillager.func_70012_b((double)j1 + 0.5, k1, (double)l1 + 0.5, 0.0f, 0.0f);
                par1World.func_72838_d((Entity)entityvillager);
                ++this.nativesSpawned;
            }
        }
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a(CHEST_KEY, this.hasMadeChest);
        par1NBTTagCompound.func_74768_a("AUSWCount", this.nativesSpawned);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasMadeChest = par1NBTTagCompound.func_74767_n(CHEST_KEY);
        this.nativesSpawned = par1NBTTagCompound.func_74764_b("AUSWCount") ? par1NBTTagCompound.func_74762_e("AUSWCount") : 0;
    }

    public static class WorldHandlerHut
    implements IGeneratorWorld {
        private final double chance;
        private final int range;

        public WorldHandlerHut(double chance) {
            this.chance = chance;
            this.range = 400;
        }

        @Override
        public int getExtentX() {
            return 7;
        }

        @Override
        public int getExtentZ() {
            return 7;
        }

        @Override
        public int getRange() {
            return this.range;
        }

        @Override
        public boolean generate(World world, Random random, int x, int z) {
            if ((double)MathUtils.randInt(0, 100) < this.chance / 5.0) {
                int direction = MathUtils.randInt(0, 3);
                new ComponentHut(direction, random, x, z).addComponentParts(world, random);
                Logger.WORLD("NativeHut x: " + x + " | z: " + z + " | Dir: " + direction);
                return true;
            }
            return false;
        }

        @Override
        public void initiate() {
        }
    }
}

