/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia.gen.gt;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Log;
import gregtech.common.blocks.GT_Block_Ores;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.australia.GTplusplus_Australia;
import gtPlusPlus.australia.dimension.Dimension_Australia;
import gtPlusPlus.australia.gen.gt.WorldGen_GT_Australia;
import gtPlusPlus.australia.gen.gt.WorldGen_GT_Australia_Base;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGen_GT_Australia_Ore_Layer
extends WorldGen_GT_Australia {
    public static ArrayList<WorldGen_GT_Australia_Ore_Layer> sList = new ArrayList();
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public Block mPrimaryMeta;
    public Block mSecondaryMeta;
    public Block mBetweenMeta;
    public Block mSporadicMeta;
    public final Material mPrimary;
    public final Material mSecondary;
    public final Material mBetween;
    public final Material mSporadic;
    public static boolean mUpdated = CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK;
    public static final Block mStoneTypes;
    public final String mRestrictBiome;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;
    public static final int WRONG_BIOME = 0;
    public static final int WRONG_DIMENSION = 1;
    public static final int NO_ORE_IN_BOTTOM_LAYER = 2;
    public static final int NO_OVERLAP = 3;
    public static final int ORE_PLACED = 4;
    public static final int NO_OVERLAP_AIR_BLOCK = 5;
    public final String aTextWorldgen = "worldgen.";
    private String fString = "unset";
    private String ore1String = "unset";
    private String ore2String = "unset";
    private String ore3String = "unset";
    private String ore4String = "unset";
    Map<Materials, String> gtOreMap = new HashMap<Materials, String>();

    public WorldGen_GT_Australia_Ore_Layer(String aName, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, Material aPrimary, Material aSecondary, Material aBetween, Material aSporadic) {
        this(aName, true, aMinY, aMaxY, aWeight, aDensity, aSize, false, false, false, false, false, false, aPrimary, aSecondary, aBetween, aSporadic);
    }

    public WorldGen_GT_Australia_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, boolean aNether, boolean aEnd, boolean GC_UNUSED1, boolean GC_UNUSED2, boolean GC_UNUSED3, Material aPrimary, Material aSecondary, Material aBetween, Material aSporadic) {
        super(aName, sList, aDefault);
        Logger.WARNING("Creating Ore Layer Object");
        this.mOverworld = GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mMinY = (short)5;
        int mMaxY = 14;
        if (mMaxY < this.mMinY + 7) {
            GT_Log.out.println("Oremix " + this.mWorldGenName + " has invalid Min/Max heights!");
            mMaxY = (short)(this.mMinY + 7);
        }
        this.mMaxY = (short)mMaxY;
        this.mWeight = (short)GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RandomWeight", aWeight);
        this.mDensity = (short)GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Density", aDensity);
        this.mSize = (short)Math.max(1, GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Size", aSize));
        this.mPrimary = aPrimary;
        this.mSecondary = aSecondary;
        this.mBetween = aBetween;
        this.mSporadic = aSporadic;
        this.mPrimaryMeta = aPrimary.getOreBlock(1);
        this.mSecondaryMeta = aSecondary.getOreBlock(1);
        this.mBetweenMeta = aBetween.getOreBlock(1);
        this.mSporadicMeta = aSporadic.getOreBlock(1);
        this.mRestrictBiome = GTplusplus_Australia.sCustomWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RestrictToBiomeName", "None");
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    public int executeWorldgenChunkified(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int aSeedX, int aSeedZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int placeZ;
        int tZ;
        int placeX;
        int tX;
        int sZ;
        int eX;
        if (this.mPrimaryMeta == Blocks.field_150348_b || this.mSecondaryMeta == Blocks.field_150348_b || this.mBetweenMeta == Blocks.field_150348_b || this.mSporadicMeta == Blocks.field_150348_b) {
            this.mPrimaryMeta = this.mPrimary.getOreBlock(1);
            this.mSecondaryMeta = this.mSecondary.getOreBlock(1);
            this.mBetweenMeta = this.mBetween.getOreBlock(1);
            this.mSporadicMeta = this.mSporadic.getOreBlock(1);
            Logger.WARNING("[Vein Generator] An Ore in a Vein had defaulted back to a default value, so they have now been reset to correct values.");
        }
        if (this.mWorldGenName.equals("vein0")) {
            if (WorldGen_GT_Australia_Base.debugWorldGen) {
                GT_Log.out.println(" NoOresInVein-vein0");
            }
            Logger.WARNING("[World Generation Debug] Special Empty Vein placed.");
            return 4;
        }
        if (aDimensionType != Dimension_Australia.DIMID) {
            Logger.WARNING("[World Generation Debug] Wrong dimension.");
            return 1;
        }
        if (!this.mRestrictBiome.equals("None") && !this.mRestrictBiome.equals(aBiome)) {
            return 0;
        }
        int[] placeCount = new int[4];
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int wXVein = aSeedX - aRandom.nextInt(this.mSize);
        int eXVein = aSeedX + 16 + aRandom.nextInt(this.mSize);
        int wX = Math.max(wXVein, aChunkX + 2);
        if (wX >= (eX = Math.min(eXVein, aChunkX + 2 + 16))) {
            Block tBlock = aWorld.func_147439_a(aChunkX + 8, tMinY, aChunkZ + 8);
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150377_bs) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, GregTech_API.sBlockGranites) || mUpdated && tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, mStoneTypes)) {
                return 3;
            }
            return 5;
        }
        int nZVein = aSeedZ - aRandom.nextInt(this.mSize);
        int sZVein = aSeedZ + 16 + aRandom.nextInt(this.mSize);
        int nZ = Math.max(nZVein, aChunkZ + 2);
        if (nZ >= (sZ = Math.min(sZVein, aChunkZ + 2 + 16))) {
            Block tBlock = aWorld.func_147439_a(aChunkX + 8, tMinY, aChunkZ + 8);
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150377_bs) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, GregTech_API.sBlockGranites) || mUpdated && tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, mStoneTypes)) {
                return 3;
            }
            return 5;
        }
        if (WorldGen_GT_Australia_Base.debugWorldGen) {
            String tDimensionName = aWorld.field_73011_w.func_80007_l();
            GT_Log.out.print("Trying Orevein:" + this.mWorldGenName + " Dimension=" + tDimensionName + " mX=" + aChunkX / 16 + " mZ=" + aChunkZ / 16 + " oreseedX=" + aSeedX / 16 + " oreseedZ=" + aSeedZ / 16 + " cY=" + tMinY);
        }
        int localDensity = Math.max(1, this.mDensity / (int)Math.sqrt(2.0 + Math.pow(aChunkX / 16 - aSeedX / 16, 2.0) + Math.pow(aChunkZ / 16 - aSeedZ / 16, 2.0)));
        int level = tMinY - 1;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, false)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        Logger.WARNING("[World Generation Debug] Trying to set Ores?");
        for (level = tMinY; level < tMinY - 1 + 3; ++level) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                    if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta != null) {
                        if (!this.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, false)) continue;
                        placeCount[1] = placeCount[1] + 1;
                        continue;
                    }
                    if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
        }
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, false)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, false)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, false)) continue;
                    placeCount[0] = placeCount[0] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        while (level < tMinY + 6) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                    if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta != null) {
                        if (!this.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, false)) continue;
                        placeCount[0] = placeCount[0] + 1;
                        continue;
                    }
                    if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
            ++level;
        }
        if (WorldGen_GT_Australia_Base.debugWorldGen) {
            String tDimensionName = aWorld.field_73011_w.func_80007_l();
            GT_Log.out.println("Generated Orevein:" + this.mWorldGenName + " Dimension=" + tDimensionName + " mX=" + aChunkX / 16 + " mZ=" + aChunkZ / 16 + " oreseedX=" + aSeedX / 16 + " oreseedZ=" + aSeedZ / 16 + " cY=" + tMinY + " wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " locDen=" + localDensity + " Den=" + this.mDensity + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return 4;
    }

    public boolean setOreBlock(World aWorld, int aX, int aY, int aZ, Block aMetaData, boolean isSmallOre, boolean air) {
        if (!air) {
            aY = Math.min(aWorld.func_72940_L(), Math.max(aY, 1));
        }
        if (aMetaData instanceof GT_Block_Ores) {
            int r;
            if (this.ore1String.equals("unset")) {
                this.ore1String = Utils.sanitizeString(this.mPrimary.getLocalizedName().toLowerCase());
            }
            if (this.ore2String.equals("unset")) {
                this.ore2String = Utils.sanitizeString(this.mSecondaryMeta.func_149732_F().toLowerCase());
            }
            if (this.ore3String.equals("unset")) {
                this.ore3String = Utils.sanitizeString(this.mBetweenMeta.func_149732_F().toLowerCase());
            }
            if (this.ore4String.equals("unset")) {
                this.ore4String = Utils.sanitizeString(this.mSporadicMeta.func_149732_F().toLowerCase());
            }
            if (this.mPrimaryMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.name().toLowerCase()));
                    }
                    this.fString = this.gtOreMap.get(f);
                    if (!this.fString.contains(this.ore1String) || !this.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    Logger.WARNING("[World Generation Debug] Set " + f.mDefaultLocalName + " Ore at X: " + aX + " | Y: " + aY + " | Z: " + aZ);
                    return true;
                }
            }
            if (this.mSecondaryMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.name().toLowerCase()));
                    }
                    this.fString = this.gtOreMap.get(f);
                    if (!this.fString.contains(this.ore2String) || !this.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    Logger.WARNING("[World Generation Debug] Set " + f.mDefaultLocalName + " Ore at X: " + aX + " | Y: " + aY + " | Z: " + aZ);
                    return true;
                }
            }
            if (this.mBetweenMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.name().toLowerCase()));
                    }
                    this.fString = this.gtOreMap.get(f);
                    if (!this.fString.contains(this.ore3String) || !this.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    Logger.WARNING("[World Generation Debug] Set " + f.mDefaultLocalName + " Ore at X: " + aX + " | Y: " + aY + " | Z: " + aZ);
                    return true;
                }
            }
            if (this.mSporadicMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.name().toLowerCase()));
                    }
                    this.fString = this.gtOreMap.get(f);
                    if (!this.fString.contains(this.ore4String) || !this.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    Logger.WARNING("[World Generation Debug] Set " + f.mDefaultLocalName + " Ore at X: " + aX + " | Y: " + aY + " | Z: " + aZ);
                    return true;
                }
            }
        }
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        Block tOreBlock = aMetaData;
        int BlockMeta = aWorld.func_72805_g(aX, aY, aZ);
        String BlockName = tBlock.func_149739_a();
        if ((tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150346_d) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTech_API.sBlockGranites) || mUpdated && tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, mStoneTypes) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150322_A)) && aWorld.func_147465_d(aX, aY, aZ, tOreBlock, 0, 3)) {
            Logger.WARNING("[World Generation Debug] Set " + tOreBlock.func_149732_F() + " at X: " + aX + " | Y: " + aY + " | Z: " + aZ);
            return true;
        }
        return false;
    }

    private boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int mMetaItemSubID, boolean useless) {
        block10: {
            boolean is08;
            Method setOres = null;
            boolean bl = is08 = !CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK;
            if (is08) {
                try {
                    setOres = GT_TileEntity_Ores.class.getDeclaredMethod("setOreBlock", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException | SecurityException exception) {}
            } else {
                try {
                    setOres = GT_TileEntity_Ores.class.getDeclaredMethod("setOreBlock", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            try {
                if (is08 && setOres != null) {
                    setOres.invoke(null, aWorld, aX, aY, aZ, mMetaItemSubID);
                    break block10;
                }
                if (!is08 && setOres != null) {
                    setOres.invoke(null, aWorld, aX, aY, aZ, mMetaItemSubID, useless);
                    break block10;
                }
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        if (mUpdated) {
            Object tempBlock = null;
            try {
                Field temp = ReflectionUtils.getField(GregTech_API.class, "sBlockStones");
                tempBlock = temp.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
            mStoneTypes = (Block)tempBlock;
        } else {
            mStoneTypes = null;
        }
    }
}

