/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia.gen.gt;

import cpw.mods.fml.common.IWorldGenerator;
import gregtech.api.util.GT_Log;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.random.XSTR;
import gtPlusPlus.australia.dimension.Dimension_Australia;
import gtPlusPlus.australia.gen.gt.WorldGen_GT_Australia;
import gtPlusPlus.australia.gen.gt.WorldGen_GT_Australia_Ore_Layer;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.xmod.gregtech.HANDLER_GT;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGen_GT_Australia_Base
implements IWorldGenerator {
    public static int oreveinPercentage;
    public static int oreveinAttempts;
    public static int oreveinMaxPlacementAttempts;
    public static boolean debugWorldGen;
    public static List<Runnable> mList;
    public static HashSet<Long> ProcChunks;
    public static WorldGen_GT_Australia_Ore_Layer noOresInVein;
    public static Hashtable<Long, WorldGen_GT_Australia_Ore_Layer> validOreveins;
    public boolean mIsGenerating = false;
    public static final Object listLock;

    public WorldGen_GT_Australia_Base() {
        if (debugWorldGen) {
            GT_Log.out.println("GTPP_Worldgenerator created");
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == Dimension_Australia.DIMID) {
            this.generateSafely(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public synchronized void generateSafely(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int xDim = Dimension_Australia.DIMID;
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (world.field_73011_w.field_76574_g != xDim) break;
                this.generateEverglades(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generateEverglades(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        Logger.WARNING("Trying to Generate Dimension.");
        Object object = listLock;
        synchronized (object) {
            Logger.WARNING("Locked List addition.");
            if (mList.add(new WorldGenContainer(new XSTR(Math.abs(aRandom.nextInt()) + 1), aX, aZ, Dimension_Australia.DIMID, aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y))) {
                Logger.WARNING("Locked List addition. Success.");
            } else {
                Logger.WARNING("Locked List addition. Fail.");
            }
            if (debugWorldGen) {
                GT_Log.out.println("ADD WorldSeed:" + aWorld.func_72905_C() + " DimId" + aWorld.field_73011_w.field_76574_g + " chunk x:" + aX + " z:" + aZ + " SIZE: " + mList.size());
            }
        }
        if (!this.mIsGenerating) {
            Logger.WARNING("Is not generating.");
            this.mIsGenerating = true;
            Logger.WARNING("Setting Generation to true.");
            int mList_sS = mList.size();
            mList_sS = Math.min(mList_sS, 3);
            for (int i = 0; i < mList_sS; ++i) {
                WorldGenContainer toRun = (WorldGenContainer)mList.get(0);
                if (debugWorldGen) {
                    GT_Log.out.println("RUN WorldSeed:" + aWorld.func_72905_C() + " DimId" + aWorld.field_73011_w.field_76574_g + " chunk x:" + toRun.mX + " z:" + toRun.mZ + " SIZE: " + mList.size() + " i: " + i);
                }
                Object object2 = listLock;
                synchronized (object2) {
                    Logger.WARNING("Locked List Removal.");
                    mList.remove(0);
                }
                toRun.run();
            }
            this.mIsGenerating = false;
            Logger.WARNING("Is Generating now set to false..");
        }
    }

    public void generateOre(Block block, World world, Random random, int chunk_x, int chunk_z, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY, Block generateIn) {
        int heightRange = maxY - minY;
        WorldGenMinable worldgenminable = new WorldGenMinable(block, maxVeinSize, generateIn);
        for (int k1 = 0; k1 < chancesToSpawn; ++k1) {
            int xrand = random.nextInt(16);
            int yrand = random.nextInt(heightRange) + minY;
            int zrand = random.nextInt(16);
            worldgenminable.func_76484_a(world, random, chunk_x + xrand, yrand, chunk_z + zrand);
        }
    }

    static {
        debugWorldGen = false;
        mList = new ArrayList<Runnable>();
        ProcChunks = new HashSet();
        noOresInVein = new WorldGen_GT_Australia_Ore_Layer("vein0", 0, 255, 0, 0, 0, ELEMENT.getInstance().IRON, ELEMENT.getInstance().GOLD, ELEMENT.getInstance().LEAD, ELEMENT.getInstance().TIN);
        validOreveins = new Hashtable(1024);
        listLock = new Object();
    }

    public static class WorldGenContainer
    implements Runnable {
        public final Random mRandom;
        public final int mX;
        public final int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;
        public static ArrayList<NearbySeeds> seedList = new ArrayList();

        public WorldGenContainer(Random aRandom, int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mRandom = aRandom;
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        public void worldGenFindVein(int oreseedX, int oreseedZ) {
            long oreveinSeed = this.mWorld.func_72905_C() << 16 ^ (((long)this.mWorld.field_73011_w.field_76574_g & 0xFFL) << 56 | ((long)oreseedX & 0xFFFFFFFL) << 28 | (long)oreseedZ & 0xFFFFFFFL);
            XSTR oreveinRNG = new XSTR(oreveinSeed);
            int oreveinPercentageRoll = oreveinRNG.nextInt(100);
            boolean noOrePlacedCount = false;
            String tDimensionName = "";
            if (debugWorldGen) {
                tDimensionName = this.mWorld.field_73011_w.func_80007_l();
            }
            if (debugWorldGen) {
                GT_Log.out.println(" Finding oreveins for oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " worldSeed=" + this.mWorld.func_72905_C());
            }
            Logger.WARNING("[World Generation Debug] !validOreveins.containsKey(oreveinSeed) | oreveinSeed: " + oreveinSeed);
            if (!validOreveins.containsKey(oreveinSeed)) {
                Logger.WARNING("[World Generation Debug] oreveinPercentageRoll < oreveinPercentage? " + (oreveinPercentageRoll < oreveinPercentage));
                Logger.WARNING("[World Generation Debug] WorldGen_GT_Ore_Layer.sWeight > 0? " + (WorldGen_GT_Australia_Ore_Layer.sWeight > 0));
                Logger.WARNING("[World Generation Debug] WorldGen_GT_Ore_Layer.sList.size() > 0? " + (WorldGen_GT_Australia_Ore_Layer.sList.size() > 0));
                if (oreveinPercentageRoll < oreveinPercentage && WorldGen_GT_Australia_Ore_Layer.sWeight > 0 && WorldGen_GT_Australia_Ore_Layer.sList.size() > 0) {
                    int i;
                    int placementAttempts = 0;
                    boolean oreveinFound = false;
                    block12: for (i = 0; i < oreveinAttempts && !oreveinFound && placementAttempts < oreveinMaxPlacementAttempts; ++i) {
                        Logger.WARNING("[World Generation Debug] i: " + i);
                        Logger.WARNING("[World Generation Debug] placementAttempts: " + placementAttempts);
                        Logger.WARNING("[World Generation Debug] oreveinAttempts: " + oreveinAttempts);
                        Logger.WARNING("[World Generation Debug] (placementAttempts < oreveinMaxPlacementAttempts): " + (placementAttempts < oreveinMaxPlacementAttempts));
                        Logger.WARNING("[World Generation Debug] oreveinFound: " + oreveinFound);
                        int tRandomWeight = oreveinRNG.nextInt(WorldGen_GT_Australia_Ore_Layer.sWeight);
                        for (WorldGen_GT_Australia_Ore_Layer tWorldGen : WorldGen_GT_Australia_Ore_Layer.sList) {
                            Logger.WARNING("[World Generation Debug] Iterating sList - Size: " + WorldGen_GT_Australia_Ore_Layer.sList.size());
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                int placementResult = tWorldGen.executeWorldgenChunkified(this.mWorld, new XSTR(oreveinSeed ^ (long)Block.func_149682_b((Block)tWorldGen.mPrimaryMeta)), this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, oreseedX * 16, oreseedZ * 16, this.mChunkGenerator, this.mChunkProvider);
                                switch (placementResult) {
                                    case 4: {
                                        if (debugWorldGen) {
                                            GT_Log.out.println(" Added oreveinSeed=" + oreveinSeed + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        validOreveins.put(oreveinSeed, tWorldGen);
                                        oreveinFound = true;
                                        Logger.WARNING("[World Generation Debug] ORE_PLACED");
                                        break;
                                    }
                                    case 2: {
                                        Logger.WARNING("[World Generation Debug] NO_ORE_IN_BOTTOM_LAYER | Attempts: " + ++placementAttempts);
                                        break;
                                    }
                                    case 3: {
                                        Logger.WARNING("[World Generation Debug] NO_OVERLAP");
                                        if (debugWorldGen) {
                                            GT_Log.out.println(" Added far oreveinSeed=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        validOreveins.put(oreveinSeed, tWorldGen);
                                        oreveinFound = true;
                                        break;
                                    }
                                    case 5: {
                                        if (debugWorldGen) {
                                            GT_Log.out.println(" No overlap and air block in test spot=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        Logger.WARNING("[World Generation Debug] NO_OVERLAP_AIR_BLOCK");
                                        ++placementAttempts;
                                    }
                                }
                                continue block12;
                            }
                            catch (Throwable e) {
                                if (debugWorldGen) {
                                    GT_Log.out.println("Exception occurred on oreVein" + tWorldGen + " oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ);
                                }
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                    if (!oreveinFound && this.mX == oreseedX && this.mZ == oreseedZ) {
                        if (debugWorldGen) {
                            GT_Log.out.println(" Empty oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                        }
                        validOreveins.put(oreveinSeed, noOresInVein);
                    }
                } else if (oreveinPercentageRoll >= oreveinPercentage) {
                    if (debugWorldGen) {
                        GT_Log.out.println(" Skipped oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " RNG=" + oreveinPercentageRoll + " %=" + oreveinPercentage + " dimensionName=" + tDimensionName);
                    }
                    validOreveins.put(oreveinSeed, noOresInVein);
                }
            } else {
                if (debugWorldGen) {
                    GT_Log.out.print(" Valid oreveinSeed=" + oreveinSeed + " validOreveins.size()=" + validOreveins.size() + " ");
                }
                WorldGen_GT_Australia_Ore_Layer tWorldGen = validOreveins.get(oreveinSeed);
                oreveinRNG.setSeed(oreveinSeed ^ (long)Block.func_149682_b((Block)tWorldGen.mPrimaryMeta));
                int placementResult = tWorldGen.executeWorldgenChunkified(this.mWorld, oreveinRNG, this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, oreseedX * 16, oreseedZ * 16, this.mChunkGenerator, this.mChunkProvider);
                switch (placementResult) {
                    case 2: {
                        if (!debugWorldGen) break;
                        GT_Log.out.println(" No ore in bottom layer");
                        break;
                    }
                    case 3: {
                        if (!debugWorldGen) break;
                        GT_Log.out.println(" No overlap");
                    }
                }
            }
        }

        @Override
        public void run() {
            long startTime = System.nanoTime();
            int oreveinMaxSize = this.mWorld.field_73011_w.func_80007_l().equals("Underdark") ? 24 : 48;
            int wXbox = this.mX - oreveinMaxSize / 16;
            int eXbox = this.mX + (oreveinMaxSize / 16 + 1);
            int nZbox = this.mZ - oreveinMaxSize / 16;
            int sZbox = this.mZ + (oreveinMaxSize / 16 + 1);
            for (int x = wXbox; x < eXbox; ++x) {
                for (int z = nZbox; z < sZbox; ++z) {
                    if (Math.abs(x) % 3 != 1 || Math.abs(z) % 3 != 1) continue;
                    if (debugWorldGen) {
                        GT_Log.out.println("Adding seed x=" + x + " z=" + z);
                    }
                    seedList.add(new NearbySeeds(x, z));
                }
            }
            while (seedList.size() != 0) {
                if (debugWorldGen) {
                    GT_Log.out.println("Processing seed x=" + WorldGenContainer.seedList.get((int)0).mX + " z=" + WorldGenContainer.seedList.get((int)0).mZ);
                }
                this.worldGenFindVein(WorldGenContainer.seedList.get((int)0).mX, WorldGenContainer.seedList.get((int)0).mZ);
                seedList.remove(0);
            }
            long oregenTime = System.nanoTime();
            try {
                for (WorldGen_GT_Australia tWorldGen : HANDLER_GT.sWorldgenListAustralia) {
                    tWorldGen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, this.mChunkGenerator, this.mChunkProvider);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            long leftOverTime = System.nanoTime();
            Chunk tChunk = this.mWorld.func_72938_d(this.mX, this.mZ);
            if (tChunk != null) {
                tChunk.field_76643_l = true;
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            if (debugWorldGen) {
                GT_Log.out.println(" Oregen took " + (oregenTime - startTime) + " Leftover gen took " + (leftOverTime - oregenTime) + " Worldgen took " + duration + " nanoseconds");
            }
        }

        class NearbySeeds {
            public int mX;
            public int mZ;

            NearbySeeds(int x, int z) {
                this.mX = x;
                this.mZ = z;
            }
        }
    }
}

