/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.australia.biome.type.Biome_AustralianDesert_Ex;
import gtPlusPlus.australia.biome.type.Biome_AustralianForest;
import gtPlusPlus.australia.biome.type.Biome_AustralianOcean;
import gtPlusPlus.australia.biome.type.Biome_AustralianOutback;
import gtPlusPlus.australia.biome.type.Biome_AustralianPlains;
import gtPlusPlus.australia.block.AustraliaContentLoader;
import gtPlusPlus.australia.dimension.Dimension_Australia;
import gtPlusPlus.australia.gen.gt.WorldGen_Australia_Ores;
import gtPlusPlus.australia.gen.gt.WorldGen_GT_Australia_Base;
import gtPlusPlus.australia.gen.map.structure.StructureManager;
import gtPlusPlus.australia.world.AustraliaWorldGenerator;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.xmod.gregtech.api.util.GTPP_Config;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@Mod(modid="Australia", name="GT++ Australia", version="1.7.110", dependencies="required-after:Forge; after:dreamcraft; after:IC2; after:ihl; required-after:gregtech; required-after:miscutils;")
public class GTplusplus_Australia
implements ActionListener {
    @Mod.Instance(value="Australia")
    public static GTplusplus_Australia instance;
    public static GTPP_Config sCustomWorldgenFile;
    public static volatile Biome_AustralianDesert_Ex Australian_Desert_Biome_3;
    public static volatile Biome_AustralianForest Australian_Forest_Biome;
    public static volatile Biome_AustralianOcean Australian_Ocean_Biome;
    public static volatile Biome_AustralianOutback Australian_Outback_Biome;
    public static volatile Biome_AustralianPlains Australian_Plains_Biome;
    public static volatile Dimension_Australia Australia_Dimension;
    public static AustraliaWorldGenerator Australia_World_Generator;
    public static int globalAustraliaPortalSpawnTimer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Logger.INFO("Loading Australia V1.7.110");
        this.setVars(event);
        Australia_Dimension = new Dimension_Australia();
        GTplusplus_Australia.Australia_Dimension.instance = instance;
        Australian_Desert_Biome_3 = Biome_AustralianDesert_Ex.biome;
        Australian_Forest_Biome = Biome_AustralianForest.biome;
        Australian_Ocean_Biome = Biome_AustralianOcean.biome;
        Australian_Outback_Biome = Biome_AustralianOutback.biome;
        Australian_Plains_Biome = Biome_AustralianPlains.biome;
        StructureManager.registerVillageComponents();
        this.setupWorldGenerator();
        sCustomWorldgenFile = new GTPP_Config(new Configuration(new File(new File(event.getModConfigurationDirectory(), "GTplusplus"), "Australia.cfg")));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent e) {
        Logger.INFO("Begin resource allocation for Australia V1.7.110");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGen_GT_Australia_Base(), (int)Short.MAX_VALUE);
        Australian_Desert_Biome_3.load();
        Australian_Forest_Biome.load();
        Australian_Ocean_Biome.load();
        Australian_Outback_Biome.load();
        Australian_Plains_Biome.load();
        Australia_Dimension.load();
    }

    public static synchronized void GenerateOreMaterials() {
    }

    protected synchronized void setVars(FMLPreInitializationEvent event) {
        sCustomWorldgenFile = new GTPP_Config(new Configuration(new File(new File(event.getModConfigurationDirectory(), "GTplusplus"), "Australia.cfg")));
        if (DimensionManager.isDimensionRegistered((int)Dimension_Australia.DIMID)) {
            Dimension_Australia.DIMID = DimensionManager.getNextFreeDimId();
        }
        WorldGen_Australia_Ores.generateValidOreVeins();
        WorldGen_GT_Australia_Base.oreveinPercentage = 16;
        WorldGen_GT_Australia_Base.oreveinAttempts = 16;
        WorldGen_GT_Australia_Base.oreveinMaxPlacementAttempts = 2;
        if (CORE_Preloader.DEBUG_MODE || CORE.DEVENV) {
            WorldGen_GT_Australia_Base.debugWorldGen = true;
        }
        AustraliaContentLoader.run();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        Australia_World_Generator.initiate();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent e) {
        Logger.INFO("Finished loading Australia plugin for GT++.");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    private void setupWorldGenerator() {
        Logger.INFO("Registering World Generator for Australia.");
        Australia_World_Generator = new AustraliaWorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)Australia_World_Generator, (int)0);
    }

    static {
        sCustomWorldgenFile = null;
        globalAustraliaPortalSpawnTimer = 0;
    }
}

