/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import codechicken.nei.PositionedStack;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.nei.GT_NEI_DefaultHandler;
import gtPlusPlus.api.interfaces.IComparableRecipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GTPP_Recipe
extends GT_Recipe
implements IComparableRecipe {
    private final String mRecipeHash;
    private final AutoMap<Integer> mHashMap = new AutoMap();

    public GTPP_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
        this.mRecipeHash = GTPP_Recipe.getRecipeHash(this);
        this.mHashMap.addAll((Collection<Integer>)GTPP_Recipe.convertStringDataToInts(GTPP_Recipe.getEncodedRecipeData(this)));
    }

    public GTPP_Recipe(ItemStack aInput1, ItemStack aOutput1, int aFuelValue, int aType) {
        this(aInput1, aOutput1, null, null, null, aFuelValue, aType);
    }

    private static AutoMap<Integer> convertStringDataToInts(AutoMap<String> aData) {
        AutoMap<Integer> aMap = new AutoMap<Integer>();
        for (String string : aData) {
            aMap.add(string.hashCode());
        }
        return aMap;
    }

    private static AutoMap<String> getEncodedRecipeData(GTPP_Recipe aRecipe) {
        AutoMap<String> aData = new AutoMap<String>();
        aData.add(aRecipe.mRecipeHash);
        aData.add("" + aRecipe.mCanBeBuffered);
        aData.add("" + aRecipe.mHidden);
        aData.add("" + aRecipe.mEnabled);
        aData.add("" + aRecipe.mDuration);
        aData.add("" + aRecipe.mEUt);
        aData.add("" + aRecipe.mFakeRecipe);
        aData.add("" + aRecipe.mSpecialItems);
        aData.add(aRecipe.mChances.toString());
        aData.add(aRecipe.mInputs.toString());
        aData.add(aRecipe.mOutputs.toString());
        aData.add(aRecipe.mFluidInputs.toString());
        aData.add(aRecipe.mFluidOutputs.toString());
        return aData;
    }

    public static String getRecipeHash(GT_Recipe aRecipe) {
        String aEncoderString = aRecipe.toString();
        return aEncoderString;
    }

    private final void checkModified() {
        if (this.hasBeenModified()) {
            String[] aInfo;
            for (String s : aInfo = RecipeUtils.getRecipeInfo(this)) {
                Logger.INFO(s);
            }
            CORE.crash("Someone has edited an internal GT++ recipe, which is no longer allowed. Please complain to whoever has done this, not Alkalus.");
        }
    }

    private final boolean hasBeenModified() {
        int a;
        String aEncoderString = this.toString();
        boolean aBasicHashCheck = this.mRecipeHash.equals(aEncoderString);
        if (!aBasicHashCheck) {
            Logger.INFO("This Recipe Hash: " + aEncoderString);
            Logger.INFO("Expected Hash Code: " + this.mRecipeHash);
            return true;
        }
        AutoMap<Integer> aData = new AutoMap<Integer>();
        aData.addAll((Collection<Integer>)GTPP_Recipe.convertStringDataToInts(GTPP_Recipe.getEncodedRecipeData(this)));
        long aHashTotal = 0L;
        long aExpectedHashTotal = 0L;
        Iterator<Object> iterator = aData.iterator();
        while (iterator.hasNext()) {
            a = (Integer)iterator.next();
            aHashTotal += (long)a;
        }
        iterator = this.mHashMap.iterator();
        while (iterator.hasNext()) {
            a = (Integer)iterator.next();
            aExpectedHashTotal += (long)a;
        }
        if (aHashTotal != aExpectedHashTotal) {
            Logger.INFO("This Recipe Hash: " + aEncoderString);
            Logger.INFO("Expected Hash Code: " + this.mRecipeHash);
            Logger.INFO("This Recipe Hash: " + aHashTotal);
            Logger.INFO("Expected Hash Code: " + aExpectedHashTotal);
            return true;
        }
        return false;
    }

    public GTPP_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        Logger.WARNING("Switch case method for adding fuels");
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    Logger.WARNING("Added fuel " + aInput1.func_82833_r() + " is ROCKET FUEL - continuing");
                    GTPP_Recipe_Map.sRocketFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 1: {
                    GTPP_Recipe_Map.sGeoThermalFuels.addRecipe(this);
                    break;
                }
                case 2: {
                    GTPP_Recipe_Map.sRTGFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    public static void reInit() {
        GT_Log.out.println("GT_Mod: Re-Unificating Recipes.");
        for (GTPP_Recipe_Map_Internal tMapEntry : GTPP_Recipe_Map_Internal.sMappingsEx) {
            if (tMapEntry == null || tMapEntry.mRecipeList == null || tMapEntry.mRecipeList.isEmpty()) continue;
            for (GT_Recipe aRecipe : tMapEntry.mRecipeList) {
                GTPP_Recipe.checkRecipeOwnership(aRecipe);
            }
        }
    }

    private static final boolean checkRecipeOwnership(GT_Recipe aRecipe) {
        if (aRecipe != null && aRecipe instanceof GTPP_Recipe) {
            GTPP_Recipe nRecipe = (GTPP_Recipe)aRecipe;
            GTPP_Recipe_Map_Internal.mHashedRecipes.put(nRecipe.hashCode(), nRecipe);
            return true;
        }
        return false;
    }

    public static final void checkRecipeModifications() {
        for (GTPP_Recipe aRecipe : GTPP_Recipe_Map_Internal.mHashedRecipes.values()) {
            Logger.INFO("Checking recipe: " + aRecipe.hashCode());
            aRecipe.checkModified();
        }
    }

    public static class GTPP_Recipe_Map_ChemicalPlant
    extends GTPP_Recipe_Map_Internal {
        public GTPP_Recipe_Map_ChemicalPlant(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe_ChemicalPlant(aOptimize, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addRecipe(int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe_ChemicalPlant(false, null, null, null, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), false, false, false);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe_ChemicalPlant(aOptimize, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public static class GTPP_Recipe_ChemicalPlant
        extends GT_Recipe {
            public GTPP_Recipe_ChemicalPlant(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
                super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
            }

            public ArrayList<PositionedStack> getInputPositionedStacks() {
                int tStartIndex = 0;
                ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>(this.mInputs.length + this.mFluidInputs.length);
                if (this.getRepresentativeInput(tStartIndex) != null) {
                    inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getRepresentativeInput(tStartIndex), 3, -4));
                }
                if (this.getRepresentativeInput(++tStartIndex) != null) {
                    inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getRepresentativeInput(tStartIndex), 21, -4));
                }
                if (this.getRepresentativeInput(++tStartIndex) != null) {
                    inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getRepresentativeInput(tStartIndex), 39, -4));
                }
                if (this.getRepresentativeInput(++tStartIndex) != null) {
                    inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getRepresentativeInput(tStartIndex), 57, -4));
                }
                ++tStartIndex;
                if (this.mSpecialItems != null) {
                    inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack(this.mSpecialItems, 120, 52));
                }
                if (this.mFluidInputs.length >= 1) {
                    if (this.mFluidInputs[0] != null && this.mFluidInputs[0].getFluid() != null) {
                        inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[0], (boolean)true), 3, 31));
                    }
                    if (this.mFluidInputs.length > 1 && this.mFluidInputs[1] != null && this.mFluidInputs[1].getFluid() != null) {
                        inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[1], (boolean)true), 21, 31));
                    }
                    if (this.mFluidInputs.length > 2 && this.mFluidInputs[2] != null && this.mFluidInputs[2].getFluid() != null) {
                        inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[2], (boolean)true), 39, 31));
                    }
                    if (this.mFluidInputs.length > 3 && this.mFluidInputs[3] != null && this.mFluidInputs[3].getFluid() != null) {
                        inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[3], (boolean)true), 57, 31));
                    }
                }
                return inputStacks;
            }

            public ArrayList<PositionedStack> getOutputPositionedStacks() {
                int tStartIndex = 0;
                ArrayList<PositionedStack> outputStacks = new ArrayList<PositionedStack>(this.mOutputs.length + this.mFluidOutputs.length);
                if (this.getOutput(tStartIndex) != null) {
                    outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getOutput(tStartIndex), 102, 5, this.getOutputChance(tStartIndex)));
                }
                if (this.getOutput(++tStartIndex) != null) {
                    outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getOutput(tStartIndex), 120, 5, this.getOutputChance(tStartIndex)));
                }
                if (this.getOutput(++tStartIndex) != null) {
                    outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getOutput(tStartIndex), 102, 23, this.getOutputChance(tStartIndex)));
                }
                if (this.getOutput(++tStartIndex) != null) {
                    outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)this.getOutput(tStartIndex), 120, 23, this.getOutputChance(tStartIndex)));
                }
                ++tStartIndex;
                if (this.mFluidOutputs.length > 0) {
                    if (this.mFluidOutputs[0] != null && this.mFluidOutputs[0].getFluid() != null) {
                        outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidOutputs[0], (boolean)true), 138, 5));
                    }
                    if (this.mFluidOutputs.length > 1 && this.mFluidOutputs[1] != null && this.mFluidOutputs[1].getFluid() != null) {
                        outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidOutputs[1], (boolean)true), 138, 23));
                    }
                }
                return outputStacks;
            }
        }
    }

    public static class GTPP_Recipe_Map_MultiNoCell
    extends GTPP_Recipe_Map_Internal {
        private static final HashMap<Integer, Pair<Integer, Integer>> mInputSlotMap = new HashMap();
        private static final HashMap<Integer, Pair<Integer, Integer>> mOutputSlotMap = new HashMap();

        public GTPP_Recipe_Map_MultiNoCell(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe_MultiNoCell(aOptimize, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addRecipe(int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe_MultiNoCell(false, null, null, null, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), false, false, false);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe_MultiNoCell(aOptimize, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GTPP_Recipe_MultiNoCell(false, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GTPP_Recipe_MultiNoCell(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, boolean hidden) {
            return this.addFakeRecipe(aCheckForCollisions, new GTPP_Recipe_MultiNoCell(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), hidden);
        }

        static {
            int[] slotsX = new int[]{12, 30, 48};
            int[] slotsY = new int[]{5, 23, 41, 64};
            int aIndex = 0;
            for (int slotY : slotsY) {
                for (int slotX : slotsX) {
                    mInputSlotMap.put(aIndex++, new Pair<Integer, Integer>(slotX, slotY));
                }
            }
            slotsX = new int[]{102, 120, 138};
            aIndex = 0;
            for (int slotY : slotsY) {
                for (int slotX : slotsX) {
                    mOutputSlotMap.put(aIndex++, new Pair<Integer, Integer>(slotX, slotY));
                }
            }
        }

        public static class GTPP_Recipe_MultiNoCell
        extends GT_Recipe {
            public GTPP_Recipe_MultiNoCell(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
                super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
            }

            public ArrayList<PositionedStack> getInputPositionedStacks() {
                int y;
                int x;
                int i;
                int aInputItemsCount = this.mInputs.length;
                int aInputFluidsCount = this.mFluidInputs.length;
                int aInputSlotsUsed = 0;
                int aSlotToCheck = 0;
                ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>(aInputItemsCount + aInputFluidsCount);
                if (this.mSpecialItems != null) {
                    inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack(this.mSpecialItems, 120, 52));
                }
                if (aInputItemsCount > 0) {
                    if (aInputItemsCount > 9) {
                        aInputItemsCount = 9;
                    }
                    for (i = 0; i < aInputItemsCount; ++i) {
                        ItemStack aRepStack;
                        x = (Integer)((Pair)mInputSlotMap.get(aInputSlotsUsed)).getKey();
                        y = (Integer)((Pair)mInputSlotMap.get(aInputSlotsUsed)).getValue();
                        if ((aRepStack = this.getRepresentativeInput(aSlotToCheck++)) == null) continue;
                        inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)aRepStack, x, y));
                        ++aInputSlotsUsed;
                    }
                }
                aSlotToCheck = aInputSlotsUsed;
                if (aInputFluidsCount > 0) {
                    for (i = 0; i < aInputFluidsCount; ++i) {
                        x = (Integer)((Pair)mInputSlotMap.get(aSlotToCheck)).getKey();
                        y = (Integer)((Pair)mInputSlotMap.get(aSlotToCheck)).getValue();
                        inputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidInputs[i], (boolean)true), x, y));
                        ++aSlotToCheck;
                        ++aInputSlotsUsed;
                    }
                }
                return inputStacks;
            }

            public ArrayList<PositionedStack> getOutputPositionedStacks() {
                int y;
                int x;
                int i;
                int aOutputItemsCount = this.mOutputs.length;
                int aOutputFluidsCount = this.mFluidOutputs.length;
                int aOutputSlotsUsed = 0;
                int aSlotToCheck = 0;
                ArrayList<PositionedStack> outputStacks = new ArrayList<PositionedStack>(aOutputItemsCount + aOutputFluidsCount);
                if (aOutputItemsCount > 0) {
                    if (aOutputItemsCount > 9) {
                        aOutputItemsCount = 9;
                    }
                    for (i = 0; i < aOutputItemsCount; ++i) {
                        x = (Integer)((Pair)mOutputSlotMap.get(aOutputSlotsUsed)).getKey();
                        y = (Integer)((Pair)mOutputSlotMap.get(aOutputSlotsUsed)).getValue();
                        ItemStack aRepStack = this.getOutput(aSlotToCheck);
                        if (aRepStack != null) {
                            outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)aRepStack, x, y, this.getOutputChance(aSlotToCheck)));
                            ++aOutputSlotsUsed;
                        }
                        ++aSlotToCheck;
                    }
                }
                aSlotToCheck = aOutputSlotsUsed;
                if (aOutputFluidsCount > 0) {
                    for (i = 0; i < aOutputFluidsCount; ++i) {
                        x = (Integer)((Pair)mOutputSlotMap.get(aSlotToCheck)).getKey();
                        y = (Integer)((Pair)mOutputSlotMap.get(aSlotToCheck)).getValue();
                        outputStacks.add((PositionedStack)new GT_NEI_DefaultHandler.FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack((FluidStack)this.mFluidOutputs[i], (boolean)true), x, y));
                        ++aSlotToCheck;
                        ++aOutputSlotsUsed;
                    }
                }
                return outputStacks;
            }
        }
    }

    public static class GTPP_Recipe_Map {
        public static final GTPP_Recipe_Map_Internal sCokeOvenRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.cokeoven", "Coke Oven", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sMatterFab2Recipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.matterfab2", "Matter Fabricator", null, "gregtech:textures/gui/basicmachines/Default", 6, 6, 0, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sRocketFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.rocketenginefuel", "Rocket Engine Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 3000, " EU", true, true);
        public static final GTPP_Recipe_Map_Internal sGeoThermalFuels = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10), "gtpp.recipe.geothermalfuel", "GeoThermal Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GTPP_Recipe_Map_Internal sChemicalDehydratorRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.chemicaldehydrator", "Dehydrator", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sVacuumFurnaceRecipes = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(500), "gtpp.recipe.vacfurnace", "Vacuum Furnace", null, "gregtech:textures/gui/basicmachines/FissionFuel", 6, 6, 1, 0, 1, "Heat Capacity: ", 1, " K", false, true);
        public static final GTPP_Recipe_Map_Internal sAlloyBlastSmelterRecipes = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(200), "gtpp.recipe.alloyblastsmelter", "Alloy Blast Smelter", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sSteamTurbineFuels = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10), "gtpp.recipe.steamturbinefuel", "GeoThermal Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, false);
        public static final GTPP_Recipe_Map_Internal sLiquidFluorineThoriumReactorRecipes = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(50), "gtpp.recipe.lftr", "Liquid Fluoride Thorium Reactor", null, "gregtech:textures/gui/basicmachines/FissionFuel", 0, 0, 0, 2, 0, "Power: ", 1, " EU/t per Dynamo", true, true);
        public static final GTPP_Recipe_Map_Internal sOreMillRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.oremill", "Milling", null, "gregtech:textures/gui/basicmachines/LFTR", 3, 4, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sFissionFuelProcessing = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(50), "gtpp.recipe.fissionfuel", "Nuclear Fuel Processing", null, "gregtech:textures/gui/basicmachines/FissionFuel", 0, 0, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sColdTrapRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.coldtrap", "Cold Trap", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sReactorProcessingUnitRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.reactorprocessingunit", "Reactor Processing Unit", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sSimpleWasherRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.simplewasher", "Simple Dust Washer", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 1, 1, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sMolecularTransformerRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.moleculartransformer", "Molecular Transformer", null, "gregtech:textures/gui/basicmachines/Scanner", 1, 1, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sElementalDuplicatorRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.elementaldupe", "Elemental Duplicator", null, "gregtech:textures/gui/basicmachines/Replicator", 1, 1, 0, 1, 1, "", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sChemicalPlantRecipes = new GTPP_Recipe_Map_ChemicalPlant(new HashSet<GT_Recipe>(100), "gtpp.recipe.fluidchemicaleactor", "Chemical Plant", null, "miscutils:textures/gui/FluidReactor", 0, 0, 0, 2, 1, "Tier: ", 1, "", true, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sRTGFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.RTGgenerators", "RTG", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 365, " Minecraft Days", true, true);
        public static final GTPP_Recipe_Map_Internal sThermalFuels = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(10), "gtpp.recipe.thermalgeneratorfuel", "Thermal Generator Fuel", null, "gregtech:textures/gui/basicmachines/FissionFuel", 1, 1, 0, 0, 1, null, 1000, null, true, true);
        public static final GTPP_Recipe_Map_Internal sSolarTowerRecipes = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(10), "gtpp.recipe.solartower", "Solar Tower", null, "gregtech:textures/gui/basicmachines/FissionFuel", 1, 1, 0, 0, 1, null, 1000, null, true, true);
        public static final GTPP_Recipe_Map_Internal sCyclotronRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.cyclotron", "COMET - Compact Cyclotron", null, "gregtech:textures/gui/basicmachines/BlastSmelter", 2, 16, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sAdvancedMixerRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(1000), "gtpp.recipe.advanced.mixer", "Advanced Material Combiner", null, "gregtech:textures/gui/basicmachines/MixerAdvanced", 4, 4, 1, 0, 2, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sSlowFusionRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(50), "gtpp.recipe.slowfusionreactor", "Mimir - Slow Fusion", null, "gregtech:textures/gui/basicmachines/LFTR", 0, 0, 0, 2, 1, "Start: ", 1, " EU", true, true);
        public static final GT_Recipe.GT_Recipe_Map sComponentAssemblerRecipes = new GT_Recipe.GT_Recipe_Map_Assembler(new HashSet(300), "gtpp.recipe.componentassembler", "Component Assembler", null, "gregtech:textures/gui/basicmachines/Assembler", 6, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sFishPondRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.fishpond", "Zhuhai - Fishing Port", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 0, 1, 0, 0, 1, "Requires Circuit: ", 1, ".", true, true);
        public static final GTPP_Recipe_Map_Internal sSpargeTowerRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.spargetower", "Sparging", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sAdvFreezerRecipes_GT = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(2000), "gtpp.recipe.cryogenicfreezer", "Cryogenic Freezer", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GTPP_Recipe_Map_Internal sMultiblockCentrifugeRecipes_GT = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(2000), "gtpp.recipe.multicentrifuge", "Multiblock Centrifuge", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GTPP_Recipe_Map_Internal sMultiblockElectrolyzerRecipes_GT = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(2000), "gtpp.recipe.multielectro", "Multiblock Electrolyzer", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GTPP_Recipe_Map_Internal sChemicalPlant_GT = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(2000), "gtpp.recipe.temp4", "temp4", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 0, 0, 0, 0, 0, "", 0, "", false, false);
        public static final GTPP_Recipe_Map_Internal sMultiblockMixerRecipes_GT = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(2000), "gtpp.recipe.multimixer", "Multiblock Mixer", null, "gregtech:textures/gui/basicmachines/FissionFuel", 12, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sSemiFluidLiquidFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.semifluidgeneratorfuels", "Semifluid Generator Fuels", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GTPP_Recipe_Map_Internal sFlotationCellRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.flotationcell", "Flotation Cell", null, "gregtech:textures/gui/basicmachines/LFTR", 6, 4, 1, 1, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sTreeSimFakeRecipes = new GTPP_Recipe_Map_MultiNoCell(new HashSet<GT_Recipe>(100), "gtpp.recipe.treefarm", "Tree Growth Simulator", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 1, 0, 1, "", 1, "", false, true);
    }

    public static class GTPP_Recipe_Map_Internal
    extends GT_Recipe.GT_Recipe_Map {
        public static final Collection<GTPP_Recipe_Map_Internal> sMappingsEx = new ArrayList<GTPP_Recipe_Map_Internal>();
        private static final HashMap<Integer, GTPP_Recipe> mHashedRecipes = new HashMap();

        public GTPP_Recipe_Map_Internal(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            GT_Recipe.GT_Recipe_Map.sMappings.remove((Object)this);
            sMappingsEx.add(this);
        }
    }
}

