/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AdvancedFusionOverclockDescriber;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_FusionComputer;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaTileEntity_Adv_Fusion_MK4
extends GT_MetaTileEntity_FusionComputer {
    public static final Method mUpdateHatchTexture = ReflectionUtils.getMethod(GT_MetaTileEntity_Hatch.class, "updateTexture", Integer.TYPE);

    public GregtechMetaTileEntity_Adv_Fusion_MK4(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Adv_Fusion_MK4(String aName) {
        super(aName);
    }

    protected OverclockDescriber createOverclockDescriber() {
        return new AdvancedFusionOverclockDescriber((byte)this.tier(), this.capableStartupCanonical());
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fusion Reactor").addInfo("HARNESSING THE POWER OF A BLUE GIANT").addInfo("Controller block for the Fusion Reactor Mk IV").addInfo("131072EU/t and 320M EU capacity per Energy Hatch").addInfo("If the recipe has a startup cost greater than the").addInfo("number of energy hatches * cap, you can't do it").addInfo("Performs 4/4 overclocks").addSeparator().beginStructureBlock(15, 3, 15, false).addController("See diagram when placed").addCasingInfoMin("Fusion Machine Casings MK III", 79, false).addStructureInfo("Cover the coils with casing").addOtherStructurePart("Advanced Fusion Coils", "Center part of the ring").addEnergyHatch("1-16, Specified casings", new int[]{2}).addInputHatch("2-16, Specified casings", new int[]{1}).addOutputHatch("1-16, Specified casings", new int[]{3}).addStructureInfo("ALL Hatches must be UHV or better").toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public int tier() {
        return 9;
    }

    public long maxEUStore() {
        return 2560040000L * (long)Math.min(16, this.mEnergyHatches.size()) / 8L;
    }

    public long capableStartupCanonical() {
        return 5120000000L;
    }

    public int getRecipeCatalystPriority() {
        return -1;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Adv_Fusion_MK4(this.mName);
    }

    public Block getCasing() {
        return this.getFusionCoil();
    }

    public int getCasingMeta() {
        return 12;
    }

    public Block getFusionCoil() {
        return ModBlocks.blockCasings3Misc;
    }

    public int getFusionCoilMeta() {
        return 13;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)super.createProcessingLogic().setOverclock(2, 2);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa)), TextureFactory.builder().addIcon(new IIconContainer[]{this.getIconOverlay()}).extFacing().build()};
        }
        if (!aActive) {
            return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.TEXTURE_CASING_FUSION_CASING_ULTRA, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
    }

    public ITexture getTextureOverlay() {
        return new GT_RenderedTexture((IIconContainer)(this.getBaseMetaTileEntity().isActive() ? TexturesGtBlock.Casing_Machine_Screen_3 : TexturesGtBlock.Casing_Machine_Screen_1));
    }

    public IIconContainer getIconOverlay() {
        return this.getBaseMetaTileEntity().isActive() ? TexturesGtBlock.Casing_Machine_Screen_3 : TexturesGtBlock.Casing_Machine_Screen_1;
    }

    public boolean turnCasingActive(boolean status) {
        try {
            if (this.mEnergyHatches != null) {
                for (GT_MetaTileEntity_Hatch_Energy hatch : this.mEnergyHatches) {
                    mUpdateHatchTexture.invoke((Object)hatch, status ? TAE.getIndexFromPage(2, 14) : 53);
                }
            }
            if (this.mOutputHatches != null) {
                for (GT_MetaTileEntity_Hatch_Output hatch2 : this.mOutputHatches) {
                    mUpdateHatchTexture.invoke((Object)hatch2, status ? TAE.getIndexFromPage(2, 14) : 53);
                }
            }
            if (this.mInputHatches != null) {
                for (GT_MetaTileEntity_Hatch_Input hatch3 : this.mInputHatches) {
                    mUpdateHatchTexture.invoke((Object)hatch3, status ? TAE.getIndexFromPage(2, 14) : 53);
                }
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public String[] getInfoData() {
        String tier = "IV";
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{"Fusion Reactor MK " + tier, "EU Required: " + powerRequired + "EU/t", "Stored EU: " + this.mEUStore + " / " + this.maxEUStore(), "Plasma Output: " + plasmaOut + "L/t"};
    }
}

