/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_MultiInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_CraftingInput_ME;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_Input_ME;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Solidifier;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialMultiMachine
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialMultiMachine>
implements ISurvivalConstructable {
    protected int mInternalMode = 0;
    private static final int MODE_COMPRESSOR = 0;
    private static final int MODE_LATHE = 1;
    private static final int MODE_MAGNETIC = 2;
    private static final int MODE_FERMENTER = 3;
    private static final int MODE_FLUIDEXTRACT = 4;
    private static final int MODE_EXTRACTOR = 5;
    private static final int MODE_LASER = 6;
    private static final int MODE_AUTOCLAVE = 7;
    private static final int MODE_FLUIDSOLIDIFY = 8;
    private static final int[][] MODE_MAP = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}};
    public static final String[] aToolTipNames = new String[9];
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialMultiMachine> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialMultiMachine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialMultiMachine(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialMultiMachine(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Nine in One";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        String[] aBuiltStrings = new String[]{aToolTipNames[0] + ", " + aToolTipNames[1] + ", " + aToolTipNames[2], aToolTipNames[3] + ", " + aToolTipNames[4] + ", " + aToolTipNames[5], aToolTipNames[6] + ", " + aToolTipNames[7] + ", " + aToolTipNames[8]};
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Multi-Machine").addInfo("250% faster than using single block machines of the same voltage").addInfo("Only uses 80% of the EU/t normally required").addInfo("Processes two items per voltage tier").addInfo("Machine Type: Metal - " + EnumChatFormatting.YELLOW + aBuiltStrings[0] + EnumChatFormatting.RESET).addInfo("Machine Type: Fluid - " + EnumChatFormatting.YELLOW + aBuiltStrings[1] + EnumChatFormatting.RESET).addInfo("Machine Type: Misc - " + EnumChatFormatting.YELLOW + aBuiltStrings[2] + EnumChatFormatting.RESET).addInfo("Read Multi-Machine Manual for extra information").addInfo(EnumChatFormatting.AQUA + "You can use Solidifier Hatch to solidify multiple liquids." + EnumChatFormatting.RESET).addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("Multi-Use Casings", 6, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialMultiMachine> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMultiMachine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(this.getTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)2))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getTextureIndex();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        if (this.mInternalMode == 0) {
            return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMultiMachine_ModeMetal;
        }
        if (this.mInternalMode == 1) {
            return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMultiMachine_ModeFluid;
        }
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMultiMachine_ModeMisc;
    }

    public int getTextureIndex() {
        return TAE.getIndexFromPage(2, 2);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private ItemStack getCircuit(ItemStack[] t) {
        for (ItemStack j : t) {
            if (j.func_77973_b() != CI.getNumberedCircuit(0).func_77973_b() || j.func_77960_j() < 20 || j.func_77960_j() > 22) continue;
            return j;
        }
        return null;
    }

    private int getCircuitID(ItemStack circuit) {
        int H = circuit.func_77960_j();
        int T = H == 20 ? 0 : (H == 21 ? 1 : (H == 22 ? 2 : -1));
        return MODE_MAP[this.mInternalMode][T];
    }

    public RecipeMap<?> getRecipeMap() {
        return null;
    }

    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.compressorRecipes, RecipeMaps.latheRecipes, RecipeMaps.polarizerRecipes, RecipeMaps.fermentingRecipes, RecipeMaps.fluidExtractionRecipes, RecipeMaps.extractorRecipes, RecipeMaps.laserEngraverRecipes, RecipeMaps.autoclaveRecipes, RecipeMaps.fluidSolidifierRecipes);
    }

    public int getRecipeCatalystPriority() {
        return -10;
    }

    private static RecipeMap<?> getRecipeMap(int aMode) {
        if (aMode == 0) {
            return RecipeMaps.compressorRecipes;
        }
        if (aMode == 1) {
            return RecipeMaps.latheRecipes;
        }
        if (aMode == 2) {
            return RecipeMaps.polarizerRecipes;
        }
        if (aMode == 3) {
            return RecipeMaps.fermentingRecipes;
        }
        if (aMode == 4) {
            return RecipeMaps.fluidExtractionRecipes;
        }
        if (aMode == 5) {
            return RecipeMaps.extractorRecipes;
        }
        if (aMode == 6) {
            return RecipeMaps.laserEngraverRecipes;
        }
        if (aMode == 7) {
            return RecipeMaps.autoclaveRecipes;
        }
        if (aMode == 8) {
            return RecipeMaps.fluidSolidifierRecipes;
        }
        return null;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){
            private ItemStack lastCircuit = null;

            @Nonnull
            protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                RecipeMap foundMap;
                ItemStack circuit = GregtechMetaTileEntity_IndustrialMultiMachine.this.getCircuit(this.inputItems);
                if (circuit == null) {
                    return Stream.empty();
                }
                if (!GT_Utility.areStacksEqual((ItemStack)circuit, (ItemStack)this.lastCircuit)) {
                    this.lastRecipe = null;
                    this.lastCircuit = circuit;
                }
                if ((foundMap = GregtechMetaTileEntity_IndustrialMultiMachine.getRecipeMap(GregtechMetaTileEntity_IndustrialMultiMachine.this.getCircuitID(circuit))) == null) {
                    return Stream.empty();
                }
                return super.findRecipeMatches(foundMap);
            }
        }.setSpeedBonus(0.2857143f)).setEuModifier(0.8f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mInternalMode = this.mInternalMode < 2 ? ++this.mInternalMode : 0;
        String mModeString = this.mInternalMode == 0 ? "Metal" : (this.mInternalMode == 1 ? "Fluid" : (this.mInternalMode == 2 ? "Misc." : "null"));
        PlayerUtils.messagePlayer(aPlayer, "Multi-Machine is now in " + mModeString + " mode.");
        this.mLastRecipe = null;
    }

    @Override
    public String[] getInfoData() {
        String[] data = super.getInfoData();
        ArrayList<String> mInfo = new ArrayList<String>(Arrays.asList(data));
        String mode = this.mInternalMode == 0 ? StatCollector.func_74838_a((String)"GTPP.multiblock.multimachine.metal") : (this.mInternalMode == 1 ? StatCollector.func_74838_a((String)"GTPP.multiblock.multimachine.fluid") : StatCollector.func_74838_a((String)"GTPP.multiblock.multimachine.misc"));
        mInfo.add(mode);
        return mInfo.toArray(new String[0]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mInternalMode", this.mInternalMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mInternalMode = aNBT.func_74762_e("mInternalMode");
        super.loadNBTData(aNBT);
    }

    public boolean isInputSeparationEnabled() {
        return true;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("mode", this.mInternalMode);
    }

    protected CheckRecipeResult doCheckRecipe() {
        if (this.mInternalMode != 2 || !this.isInputSeparationEnabled()) {
            return super.doCheckRecipe();
        }
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_RECIPE;
        if (this.supportsCraftingMEBuffer()) {
            for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
                Iterator it = dualInputHatch.inventories();
                while (it.hasNext()) {
                    IDualInputInventory slot = (IDualInputInventory)it.next();
                    this.processingLogic.setInputItems(slot.getItemInputs());
                    this.processingLogic.setInputFluids(slot.getFluidInputs());
                    CheckRecipeResult foundResult = this.processingLogic.process();
                    if (foundResult.wasSuccessful()) {
                        return foundResult;
                    }
                    if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                    result = foundResult;
                }
            }
        }
        for (GT_MetaTileEntity_Hatch_Input solidifierHatch : this.mInputHatches) {
            if (!(solidifierHatch instanceof GT_MetaTileEntity_Hatch_Solidifier)) continue;
            ItemStack mold = ((GT_MetaTileEntity_Hatch_Solidifier)solidifierHatch).getMold();
            FluidStack fluid = solidifierHatch.getFluid();
            if (mold == null || fluid == null) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            inputItems.add(mold);
            inputItems.add(ItemUtils.getGregtechCircuit(22));
            this.processingLogic.setInputItems(inputItems.toArray(new ItemStack[0]));
            this.processingLogic.setInputFluids(new FluidStack[]{fluid});
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        this.processingLogic.clear();
        this.processingLogic.setInputFluids(this.getStoredFluids());
        for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
            if (bus instanceof GT_MetaTileEntity_Hatch_CraftingInput_ME) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            for (int i = bus.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack stored = bus.func_70301_a(i);
                if (stored == null) continue;
                inputItems.add(stored);
            }
            if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                inputItems.add(this.getControllerSlot());
            }
            this.processingLogic.setInputItems(inputItems.toArray(new ItemStack[0]));
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        return result;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mInputHatches)) {
            if (tHatch instanceof GT_MetaTileEntity_Hatch_Solidifier) continue;
            this.setHatchRecipeMap(tHatch);
            if (tHatch instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                for (FluidStack tFluid : ((GT_MetaTileEntity_Hatch_MultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch instanceof GT_MetaTileEntity_Hatch_Input_ME) {
                if (!tHatch.isValid()) continue;
                for (FluidStack fluidStack : ((GT_MetaTileEntity_Hatch_Input_ME)tHatch).getStoredFluids()) {
                    if (fluidStack == null) continue;
                    rList.add(fluidStack);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("mode")) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Mode: ").append(EnumChatFormatting.YELLOW);
            switch (tag.func_74762_e("mode")) {
                case 1: {
                    string = "Fluid";
                    break;
                }
                case 2: {
                    string = "Misc";
                    break;
                }
                default: {
                    string = "Metal";
                }
            }
            currentTip.add(stringBuilder.append(string).append(EnumChatFormatting.RESET).toString());
        }
    }

    static {
        for (int id = 0; id < 9; ++id) {
            RecipeMap<?> recipeMap = GregtechMetaTileEntity_IndustrialMultiMachine.getRecipeMap(id);
            if (recipeMap == null) continue;
            String aNEI = GT_LanguageManager.getTranslation((String)GregtechMetaTileEntity_IndustrialMultiMachine.getRecipeMap((int)id).unlocalizedName);
            GregtechMetaTileEntity_IndustrialMultiMachine.aToolTipNames[id] = aNEI != null ? aNEI : "BAD NEI NAME (Report to Github)";
        }
    }
}

