/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.AddGregtechRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CoalTar
extends ItemPackage {
    public static Fluid Coal_Gas;
    public static Fluid Coal_Oil;
    public static Fluid Ethylene;
    public static Fluid Ethylbenzene;
    public static Fluid Anthracene;
    public static Fluid Toluene;
    public static Fluid Coal_Tar;
    public static Fluid Coal_Tar_Oil;
    public static Fluid Sulfuric_Coal_Tar_Oil;
    public static Fluid Naphthalene;

    public static void recipeCreateEthylene() {
        FluidStack bioEth1 = FluidUtils.getFluidStack("fluid.bioethanol", 1000);
        FluidStack bioEth2 = FluidUtils.getFluidStack("bioethanol", 1000);
        if (bioEth1 != null) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 1)}, bioEth1, FluidUtils.getWater(1000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 1)}, new int[]{10000}, 2400, 80);
        }
        if (bioEth2 != null) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(18), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 1)}, bioEth2, FluidUtils.getWater(1000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 1)}, new int[]{10000}, 2400, 80);
        }
    }

    public static void recipeCreateBenzene() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Toluene.getCells(1)}).itemOutputs(new ItemStack[]{Materials.Benzene.getCells(1)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getGas(2000L)}).fluidOutputs(new FluidStack[]{Materials.Methane.getGas(1000L)}).duration(200).eut(90).noOptimize().addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    public static void recipeCreateEthylbenzene() {
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 2), ItemUtils.getGregtechCircuit(1), FluidUtils.getFluidStack("benzene", 2000), FluidUtils.getFluidStack("fluid.ethylbenzene", 2000), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 2), 300);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellBenzene", 2), ItemUtils.getGregtechCircuit(1), FluidUtils.getFluidStack("ethylene", 2000), FluidUtils.getFluidStack("fluid.ethylbenzene", 2000), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 2), 300);
    }

    public static void recipeCoalToCoalTar() {
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Charcoal, (long)32L), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDirt", 2), FluidUtils.getFluidStack("fluid.coaltar", 800), 15, 120);
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Lignite, (long)16L), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDarkAsh", 2), FluidUtils.getFluidStack("fluid.coaltar", 800), 45, 60);
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Coal, (long)12L), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDarkAsh", 2), FluidUtils.getFluidStack("fluid.coaltar", 2200), 30, 120);
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 8), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallAsh", 3), FluidUtils.getFluidStack("fluid.coaltar", 3400), 15, 240);
    }

    private static void recipeCoalTarToCoalTarOil() {
        FluidStack[] distOutputs = new FluidStack[]{FluidUtils.getFluidStack("fluid.coaltaroil", 600), FluidUtils.getFluidStack("liquid_naphtha", 150), FluidUtils.getFluidStack("fluid.ethylbenzene", 200), FluidUtils.getFluidStack("fluid.anthracene", 50), FluidUtils.getFluidStack("fluid.kerosene", 600)};
        for (int i = 0; i < distOutputs.length; ++i) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)(i + 1))}).fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("fluid.coaltar", 1000)}).fluidOutputs(new FluidStack[]{distOutputs[i]}).duration(600).eut(64).addTo((IRecipeMap)RecipeMaps.distilleryRecipes);
        }
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("fluid.coaltar", 1000)}).fluidOutputs(distOutputs).duration(300).eut(256).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
    }

    private static void recipeCoalTarOilToSulfuricOilToNaphthalene() {
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 8), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricAcid", 8), null, null, ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 16), 320);
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(6), FluidUtils.getFluidStack("fluid.sulfuriccoaltaroil", 1000), FluidUtils.getFluidStack("fluid.naphthalene", 1000), 1200, 30, false);
    }

    private static void recipeNaphthaleneToPhthalicAcid() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Lithium.getDust(5)}).fluidInputs(new FluidStack[]{FluidUtils.getFluidStack(Naphthalene, 2000)}).fluidOutputs(new FluidStack[]{Materials.PhthalicAcid.getFluid(2500L)}).eut(30).duration(320).noOptimize().addTo(GT_RecipeConstants.UniversalChemical);
    }

    private static void recipePhthalicAcidToPhthalicAnhydride() {
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(15)}, Materials.PhthalicAcid.getFluid(1000L), null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustPhthalicAnhydride", 15)}, new int[]{10000}, 1200, 120);
    }

    @Override
    public String errorMessage() {
        return "Bad Coal Science!";
    }

    @Override
    public boolean generateRecipes() {
        CoalTar.recipeCreateEthylene();
        CoalTar.recipeCreateBenzene();
        CoalTar.recipeCreateEthylbenzene();
        CoalTar.recipeCoalToCoalTar();
        CoalTar.recipeCoalTarToCoalTarOil();
        CoalTar.recipeCoalTarOilToSulfuricOilToNaphthalene();
        CoalTar.recipeNaphthaleneToPhthalicAcid();
        CoalTar.recipePhthalicAcidToPhthalicAnhydride();
        GT_Values.RA.addFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalGas", 1), null, 96, 1);
        CORE.RA.addSemifluidFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 1), 64);
        CORE.RA.addSemifluidFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 1), 32);
        CORE.RA.addSemifluidFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTar", 1), 16);
        return true;
    }

    @Override
    public void items() {
        ItemUtils.generateSpecialUseDusts("PhthalicAnhydride", "Phthalic Anhydride", "C6H4(CO)2O", Utils.rgbtoHexValue(175, 175, 175));
        ItemUtils.generateSpecialUseDusts("LithiumHydroperoxide", "Lithium Hydroperoxide", "HLiO2", Utils.rgbtoHexValue(125, 125, 125));
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        Coal_Gas = FluidUtils.generateFluidNonMolten("CoalGas", "Coal Gas", 500, new short[]{48, 48, 48, 100}, null, null);
        Ethylene = !FluidUtils.doesFluidExist("ethylene") ? FluidUtils.generateFluidNonMolten("ethylene", "Ethylene", -103, new short[]{255, 255, 255, 100}, null, null) : FluidUtils.getWildcardFluidStack("ethylene", 1).getFluid();
        Ethylbenzene = FluidUtils.generateFluidNonMolten("Ethylbenzene", "Ethylbenzene", 136, new short[]{255, 255, 255, 100}, null, null);
        Anthracene = FluidUtils.generateFluidNonMolten("Anthracene", "Anthracene", 340, new short[]{255, 255, 255, 100}, null, null);
        Toluene = !FluidUtils.doesFluidExist("liquid_toluene") ? FluidUtils.generateFluidNonMolten("liquid_toluene", "Toluene", -95, new short[]{140, 70, 20, 100}, null, null) : FluidUtils.getWildcardFluidStack("liquid_toluene", 1).getFluid();
        Coal_Tar = FluidUtils.generateFluidNonMolten("CoalTar", "Coal Tar", 450, new short[]{32, 32, 32, 100}, null, null);
        Coal_Tar_Oil = FluidUtils.generateFluidNonMolten("CoalTarOil", "Coal Tar Oil", 240, new short[]{240, 240, 150, 100}, null, null);
        Sulfuric_Coal_Tar_Oil = FluidUtils.generateFluidNonMolten("SulfuricCoalTarOil", "Sulfuric Coal Tar Oil", 240, new short[]{250, 170, 12, 100}, null, null);
        Naphthalene = FluidUtils.generateFluidNonMolten("Naphthalene", "Naphthalene", 115, new short[]{210, 185, 135, 100}, null, null);
    }
}

