/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FlotationRecipeHandler {
    private static final HashMap<String, Material> sMaterialMap = new HashMap();
    private static final HashMap<String, ItemStack> sMilledMap = new HashMap();

    public static boolean registerOreType(Material aMaterial) {
        String aMaterialKey = aMaterial.getUnlocalizedName();
        if (sMaterialMap.containsKey(aMaterialKey)) {
            Logger.WARNING("Tried to register a Flotation material already in use. Material: " + aMaterialKey);
            return false;
        }
        sMaterialMap.put(aMaterialKey, aMaterial);
        sMilledMap.put(aMaterialKey, aMaterial.getMilled(1));
        return true;
    }

    public static Material getMaterialOfMilledProduct(ItemStack aMilled) {
        for (String aKey : sMilledMap.keySet()) {
            ItemStack aTempMilledStack = sMilledMap.get(aKey);
            if (!GT_Utility.areStacksEqual((ItemStack)aTempMilledStack, (ItemStack)aMilled, (boolean)true)) continue;
            return sMaterialMap.get(aKey);
        }
        return null;
    }

    public static ItemStack findMilledStack(GT_Recipe aRecipe) {
        if (aRecipe == null || aRecipe.mInputs == null || aRecipe.mInputs.length <= 0) {
            return null;
        }
        return FlotationRecipeHandler.findMilledStack(aRecipe.mInputs);
    }

    public static ItemStack findMilledStack(ItemStack[] aInputs) {
        if (aInputs == null || aInputs.length <= 0) {
            return null;
        }
        for (ItemStack aStack : aInputs) {
            for (int oredictID : OreDictionary.getOreIDs((ItemStack)aStack)) {
                String oredict = OreDictionary.getOreName((int)oredictID);
                if (!oredict.startsWith(OrePrefixes.milled.toString())) continue;
                return aStack;
            }
        }
        return null;
    }
}

