/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common;

import cpw.mods.fml.common.registry.LanguageRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.TAE;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.handler.AchievementHandler;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.LangUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.common.covers.CoverManager;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Meta_GT_Proxy {
    public static AchievementHandler mAssemblyAchievements;

    public static void preInit() {
        Meta_GT_Proxy.fixIC2FluidNames();
        CoverManager.generateCustomCovers();
    }

    public static void init() {
        PollutionUtils.setPollutionFluids();
        Meta_GT_Proxy.fixIC2FluidNames();
    }

    public static void postInit() {
        mAssemblyAchievements = new AchievementHandler();
        Meta_GT_Proxy.fixIC2FluidNames();
        TAE.finalizeTAE();
    }

    public static void fixIC2FluidNames() {
        try {
            Fluid f;
            String aNewHeatedWaterName = "Heated Water";
            Logger.INFO("Renaming [IC2 Hotspring Water] --> [" + aNewHeatedWaterName + "].");
            LanguageRegistry.instance().addStringLocalization("fluidHotWater", "Heated Water");
            LanguageRegistry.instance().addStringLocalization("fluidHotWater", aNewHeatedWaterName);
            LanguageRegistry.instance().addStringLocalization("ic2.fluidHotWater", aNewHeatedWaterName);
            GT_LanguageManager.addStringLocalization((String)"fluidHotWater", (String)aNewHeatedWaterName);
            GT_LanguageManager.addStringLocalization((String)"ic2.fluidHotWater", (String)aNewHeatedWaterName);
            Block b = BlocksItems.getFluidBlock((InternalName)InternalName.fluidHotWater);
            if (b != null) {
                LanguageRegistry.addName((Object)ItemUtils.getSimpleStack(b), (String)aNewHeatedWaterName);
                LanguageRegistry.instance().addStringLocalization(b.func_149739_a(), aNewHeatedWaterName);
                GT_LanguageManager.addStringLocalization((String)b.func_149739_a(), (String)aNewHeatedWaterName);
            }
            if ((f = BlocksItems.getFluid((InternalName)InternalName.fluidHotWater)) != null) {
                LanguageRegistry.instance().addStringLocalization(f.getUnlocalizedName(), aNewHeatedWaterName);
                GT_LanguageManager.addStringLocalization((String)f.getUnlocalizedName(), (String)aNewHeatedWaterName);
                int aDam = FluidRegistry.getFluidID((Fluid)f);
                ItemStack s = ItemList.Display_Fluid.getWithDamage(1L, (long)aDam, new Object[0]);
                if (s != null) {
                    LanguageRegistry.addName((Object)s, (String)aNewHeatedWaterName);
                }
            }
            String[] aLangs = new String[]{"de_DE", "en_US", "en_GB", "en_IC", "es_AR", "es_ES", "es_MX", "es_UY", "es_VE", "fr_CA", "fr_FR", "it_IT", "ko_KR", "pt_BR", "pt_PT", "ru_RU", "sv_SE", "tr_TR", "zh_CN", "zh_TW"};
            String[] aLangValues = new String[]{"Erhitztes Wasser", "Heated Water", "Heated Water", "Heated Water", "Agua caliente", "Agua caliente", "Agua caliente", "Agua caliente", "Agua caliente", "Eau chauff\u00e9e", "Eau chauff\u00e9e", "Acqua riscaldata", "\uc628\uc218", "\u00c1gua aquecida", "\u00c1gua aquecida", "\u0412\u043e\u0434\u0430 \u0441 \u043f\u043e\u0434\u043e\u0433\u0440\u0435\u0432\u043e\u043c", "Uppv\u00e4rmt vatten", "Is\u0131t\u0131lm\u0131\u015f Su", "\u70ed\u6c34", "\u70ed\u6c34"};
            for (int i = 0; i < aLangs.length; ++i) {
                Logger.REFLECTION("Trying to inject new lang data for " + aLangs[i] + ", using value: " + aLangValues[i]);
                LangUtils.rewriteEntryForLanguageRegistry(aLangs[i], "fluidHotWater", aLangValues[i]);
                LangUtils.rewriteEntryForLanguageRegistry(aLangs[i], "ic2.fluidHotWater", aLangValues[i]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

