/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class PlayerUtils {
    public static final Map<String, EntityPlayer> mCachedFakePlayers = new WeakHashMap<String, EntityPlayer>();
    private static final Class mThaumcraftFakePlayer = ReflectionUtils.doesClassExist("thaumcraft.common.lib.FakeThaumcraftPlayer") ? ReflectionUtils.getClass("thaumcraft.common.lib.FakeThaumcraftPlayer") : null;

    public static List<EntityPlayerMP> getOnlinePlayers() {
        List onlinePlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        return onlinePlayers;
    }

    public static void messagePlayer(EntityPlayer P, String S) {
        GT_Utility.sendChatToPlayer((EntityPlayer)P, (String)S);
    }

    public static void messagePlayer(EntityPlayer P, IChatComponent S) {
        P.func_146105_b(S);
    }

    public static EntityPlayer getPlayer(String name) {
        try {
            for (EntityPlayer entityPlayer : PlayerUtils.getOnlinePlayers()) {
                if (!entityPlayer.getDisplayName().toLowerCase().equals(name.toLowerCase())) continue;
                return entityPlayer;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static EntityPlayer getPlayerOnServerFromUUID(UUID parUUID) {
        if (parUUID == null) {
            return null;
        }
        for (EntityPlayerMP player : PlayerUtils.getOnlinePlayers()) {
            if (!player.func_110124_au().equals(parUUID)) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayer getPlayerInWorld(World world, String Name2) {
        List i = world.field_73010_i;
        Minecraft mc = Minecraft.func_71410_x();
        try {
            for (EntityPlayer temp : i) {
                if (!temp.getDisplayName().toLowerCase().equals(Name2.toLowerCase())) continue;
                return temp;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPlayerOP(EntityPlayer player) {
        return player.func_70003_b(2, "");
    }

    public static ItemStack getItemStackInPlayersHand(World world, String Name2) {
        EntityPlayer thePlayer = PlayerUtils.getPlayer(Name2);
        ItemStack heldItem = null;
        try {
            heldItem = thePlayer.func_70694_bm();
        }
        catch (NullPointerException e) {
            return null;
        }
        if (heldItem != null) {
            return heldItem;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getItemStackInPlayersHand() {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack heldItem = null;
        try {
            heldItem = mc.field_71439_g.func_70694_bm();
        }
        catch (NullPointerException e) {
            return null;
        }
        if (heldItem != null) {
            return heldItem;
        }
        return null;
    }

    public static ItemStack getItemStackInPlayersHand(EntityPlayer player) {
        ItemStack heldItem = null;
        try {
            heldItem = player.func_70694_bm();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        if (heldItem != null) {
            return heldItem;
        }
        heldItem = Utils.isClient() ? player.func_71011_bu() : player.func_71045_bC();
        return heldItem;
    }

    @SideOnly(value=Side.CLIENT)
    public static Item getItemInPlayersHandClient() {
        Minecraft mc = Minecraft.func_71410_x();
        Item heldItem = null;
        try {
            heldItem = mc.field_71439_g.func_70694_bm().func_77973_b();
        }
        catch (NullPointerException e) {
            return null;
        }
        if (heldItem != null) {
            return heldItem;
        }
        return null;
    }

    public static Item getItemInPlayersHand(EntityPlayer player) {
        Item heldItem = null;
        try {
            heldItem = player.func_70694_bm().func_77973_b();
        }
        catch (NullPointerException e) {
            return null;
        }
        if (heldItem != null) {
            return heldItem;
        }
        return null;
    }

    public static final EntityPlayer getPlayerEntityByName(String aPlayerName) {
        EntityPlayer player = PlayerUtils.getPlayer(aPlayerName);
        if (player != null) {
            return player;
        }
        return null;
    }

    public static final UUID getPlayersUUIDByName(String aPlayerName) {
        EntityPlayer player = PlayerUtils.getPlayer(aPlayerName);
        if (player != null) {
            return player.func_110124_au();
        }
        return null;
    }

    public static void messageAllPlayers(String string) {
        Utils.sendServerMessage(string);
    }

    public static boolean isCreative(EntityPlayer aPlayer) {
        return aPlayer.field_71075_bZ.field_75098_d;
    }

    public static boolean canTakeDamage(EntityPlayer aPlayer) {
        return !aPlayer.field_71075_bZ.field_75102_a;
    }

    public static void cacheFakePlayer(EntityPlayer aPlayer) {
        ChunkCoordinates aChunkLocation = aPlayer.func_82114_b();
        if (aPlayer instanceof FakePlayer || mThaumcraftFakePlayer != null && mThaumcraftFakePlayer.isInstance(aPlayer) || aPlayer.func_70005_c_() == null || aPlayer.func_70005_c_().length() <= 0 || aPlayer.func_85032_ar() && !aPlayer.func_70003_b(0, "") && aChunkLocation == null || aChunkLocation.field_71574_a == 0 && aChunkLocation.field_71572_b == 0 && aChunkLocation.field_71573_c == 0) {
            mCachedFakePlayers.put(aPlayer.func_110124_au().toString(), aPlayer);
        }
    }

    public static boolean isCachedFakePlayer(String aUUID) {
        return mCachedFakePlayers.containsKey(aUUID);
    }

    public static boolean isRealPlayer(EntityLivingBase aEntity) {
        if (aEntity instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)aEntity;
            ChunkCoordinates aChunkLocation = p.func_82114_b();
            if (p instanceof FakePlayer) {
                PlayerUtils.cacheFakePlayer(p);
                return false;
            }
            if (mThaumcraftFakePlayer != null && mThaumcraftFakePlayer.isInstance(p)) {
                PlayerUtils.cacheFakePlayer(p);
                return false;
            }
            if (p.func_70005_c_() == null) {
                PlayerUtils.cacheFakePlayer(p);
                return false;
            }
            if (p.func_70005_c_().length() <= 0) {
                PlayerUtils.cacheFakePlayer(p);
                return false;
            }
            if (p.func_85032_ar() && !p.func_70003_b(0, "") && aChunkLocation.field_71574_a == 0 && aChunkLocation.field_71572_b == 0 && aChunkLocation.field_71573_c == 0) {
                PlayerUtils.cacheFakePlayer(p);
                return false;
            }
            if (!PlayerUtils.isCachedFakePlayer(p.func_110124_au().toString())) {
                return true;
            }
        }
        return false;
    }
}

