/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GT_MTE_LargeTurbine_Gas
extends GregtechMetaTileEntity_LargerTurbineBase {
    private static final HashSet<Fluid> BLACKLIST = new HashSet();

    public GT_MTE_LargeTurbine_Gas(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_Gas(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_Gas(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 3;
    }

    @Override
    public int getCasingTextureIndex() {
        return 58;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return false;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 4000;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = ((FuelBackend)this.getRecipeMap().getBackend()).findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    public RecipeMap<FuelBackend> getRecipeMap() {
        return RecipeMaps.gasTurbineFuels;
    }

    public int getRecipeCatalystPriority() {
        return -20;
    }

    protected boolean filtersFluid() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList fluids = this.getStoredFluids();
        for (FluidStack fluid : fluids) {
            if (fluid == null || !BLACKLIST.contains(fluid.getFluid())) continue;
            return SimpleCheckRecipeResult.ofFailure((String)"fuel_blacklisted");
        }
        return super.checkProcessing();
    }

    @Override
    long fluidIntoPower(ArrayList<FluidStack> aFluids, long aOptFlow, int aBaseEff, float[] flowMultipliers) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (aOptFlow < (long)fuelValue) {
                this.realOptFlow = 1.0;
                this.depleteInput(new FluidStack(firstFuelType, 1));
                ++this.storedFluid;
                return GT_Utility.safeInt((long)(aOptFlow * (long)aBaseEff / 10000L));
            }
            actualOptimalFlow = GT_Utility.safeInt((long)((long)((double)aOptFlow * (double)flowMultipliers[1] / (double)fuelValue)));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((long)((float)actualOptimalFlow * 1.25f)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            if (totalFlow <= 0) {
                return 0L;
            }
            tEU = GT_Utility.safeInt((long)((long)totalFlow * (long)fuelValue));
            if (totalFlow == actualOptimalFlow) {
                tEU = GT_Utility.safeInt((long)((long)tEU * (long)aBaseEff / 10000L));
            } else {
                float efficiency = 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((float)tEU * efficiency);
                tEU = GT_Utility.safeInt((long)((long)tEU * (long)aBaseEff / 10000L));
            }
            return tEU;
        }
        return 0L;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return CORE.RANDOM.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public String getMachineType() {
        return "Large Gas Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Gas";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Gas Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_SS5);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_SS_ACTIVE5);
    }

    static {
        BLACKLIST.add(Materials.Benzene.getFluid(0L).getFluid());
    }
}

