/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntity_NuclearSaltProcessingPlant
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_NuclearSaltProcessingPlant>
implements ISurvivalConstructable {
    protected GT_Recipe lastRecipeToBuffer;
    private int casing;
    private static IStructureDefinition<GregtechMetaTileEntity_NuclearSaltProcessingPlant> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_NuclearSaltProcessingPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_NuclearSaltProcessingPlant(String mName) {
        super(mName);
    }

    @Override
    public String getMachineType() {
        return "Reactor Processing Unit, Cold Trap";
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new GregtechMetaTileEntity_NuclearSaltProcessingPlant(this.mName);
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiAutoCrafter;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Nuclear Salt Processing Plant").addInfo("Processes depleted nuclear salts that come from the LFTR").addInfo("Handles the recipes of the Reactor Processor Unit and Cold Trap").addInfo("Only Thermally Insulated Casings can be replaced with hatches").addInfo("Mufflers on top, Energy Hatches on bottom, exactly 2 of each are required").addInfo("Maintenance Hatch goes on the back, opposite of the controller block").addInfo("Inputs go on the left side of the multi, outputs on the right side").addInfo("150% faster than using single block machines of the same voltage").addInfo("Processes two items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("IV Machine Casing", 58, false).addCasingInfoMin("Thermally Insulated Casing", 1, false).addInputBus("Left Half", new int[]{2}).addInputHatch("Left Half", new int[]{2}).addOutputBus("Right Half", new int[]{3}).addOutputHatch("Right Half", new int[]{3}).addMufflerHatch("Top Side, 2 Required", new int[]{4}).addEnergyHatch("Bottom Side, 2 Required", new int[]{5}).addMaintenanceHatch("Back Side, Opposite of Controller", new int[]{6}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 10);
    }

    public IStructureDefinition<GregtechMetaTileEntity_NuclearSaltProcessingPlant> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"AAA   AAA", "ADA   ADA", "AAA   AAA"}, {"ABBA ACCA", "B  AAA  C", "ABBA ACCA"}, {"ABBB~CCCA", "B       C", "ABBBFCCCA"}, {"ABBA ACCA", "B  AAA  C", "ABBA ACCA"}, {"AAA   AAA", "AEA   AEA", "AAA   AAA"}})).addElement('A', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)5)).addElement('B', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_NuclearSaltProcessingPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8))})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_NuclearSaltProcessingPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(3).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8))})).addElement('D', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_NuclearSaltProcessingPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(4).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8))})).addElement('E', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_NuclearSaltProcessingPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8))})).addElement('F', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_NuclearSaltProcessingPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(6).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.buildPiece(this.mName, itemStack, hintsOnly, 4, 2, 0);
    }

    public int survivalConstruct(ItemStack itemStack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, itemStack, 4, 2, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity baseMetaTileEntity, ItemStack itemStack) {
        this.casing = 0;
        return this.checkPiece(this.mName, 4, 2, 0) && this.checkHatch();
    }

    @Override
    public boolean checkHatch() {
        return this.mEnergyHatches.size() == 2 && this.mMufflerHatches.size() == 2 && super.checkHatch();
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.nuclearSaltProcessingPlantRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic().setSpeedBonus(0.4f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * Math.max(1, GT_Utility.getTier((long)this.getMaxInputVoltage()));
    }

    @Override
    public String[] getExtraInfoData() {
        String running = this.mMaxProgresstime > 0 ? "Salt Plant running" : "Salt Plant stopped";
        String maintenance = this.getIdealStatus() == this.getRepairStatus() ? "No Maintenance issues" : "Needs Maintenance";
        String tSpecialText = this.lastRecipeToBuffer != null && this.lastRecipeToBuffer.mOutputs[0].func_82833_r() != null ? "Currently processing: " + this.lastRecipeToBuffer.mOutputs[0].func_82833_r() : "Currently processing: Nothing";
        return new String[]{"Nuclear Salt Processing Plant", running, maintenance, tSpecialText};
    }

    public boolean supportsInputSeparation() {
        return true;
    }
}

