/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class GregtechMetaTileEntity_IndustrialForgeHammer
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialForgeHammer>
implements ISurvivalConstructable {
    private int mCasing;
    private int mAnvilTier = 0;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialForgeHammer> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialForgeHammer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialForgeHammer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Forge Hammer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Forge Hammer").addInfo("Speed: +100% | EU Usage: 100% | Parallel: Tier x Anvil Tier x 8").addInfo("T1 - Vanilla Anvil");
        if (Mods.Railcraft.isModLoaded()) {
            tt.addInfo("T2 - Steel Anvil");
        }
        if (Mods.EnderIO.isModLoaded()) {
            tt.addInfo("T3 - Dark Steel Anvil");
        }
        if (Mods.ThaumicBases.isModLoaded()) {
            tt.addInfo("T3 - Thaumium Anvil");
            tt.addInfo("T4 - Void Metal Anvil");
        }
        tt.addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("Forge Casing", 6, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).addOtherStructurePart("Anvil", "In the center of 3x3x3 structure", new int[]{2}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialForgeHammer> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            HashMap<Block, Integer> anvilTiers = new HashMap<Block, Integer>();
            anvilTiers.put(Blocks.field_150467_bQ, 1);
            if (Mods.Railcraft.isModLoaded()) {
                anvilTiers.put(GameRegistry.findBlock((String)Mods.Railcraft.ID, (String)"anvil"), 2);
            }
            if (Mods.EnderIO.isModLoaded()) {
                anvilTiers.put(GameRegistry.findBlock((String)Mods.EnderIO.ID, (String)"blockDarkSteelAnvil"), 3);
            }
            if (Mods.ThaumicBases.isModLoaded()) {
                anvilTiers.put(GameRegistry.findBlock((String)Mods.ThaumicBases.ID, (String)"thaumicAnvil"), 3);
                anvilTiers.put(GameRegistry.findBlock((String)Mods.ThaumicBases.ID, (String)"voidAnvil"), 4);
            }
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "CAC", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialForgeHammer.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(TAE.getIndexFromPage(1, 11)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)6))})).addElement('A', StructureUtility.ofBlocksTiered(GregtechMetaTileEntity_IndustrialForgeHammer.anvilTierConverter(anvilTiers), GregtechMetaTileEntity_IndustrialForgeHammer.getAllAnvilTiers(anvilTiers), (Object)0, GregtechMetaTileEntity_IndustrialForgeHammer::setAnvilTier, GregtechMetaTileEntity_IndustrialForgeHammer::getAnvilTier)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private static List<Pair<Block, Integer>> getAllAnvilTiers(Map<Block, Integer> anvilTiers) {
        return anvilTiers.entrySet().stream().map(e -> Pair.of((Object)((Block)e.getKey()), (Object)((Integer)e.getValue()))).collect(Collectors.toList());
    }

    private static ITierConverter<Integer> anvilTierConverter(Map<Block, Integer> anvilTiers) {
        return (block, meta) -> block == null ? 0 : anvilTiers.getOrDefault(block, 0);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    protected SoundResource getProcessStartSound() {
        return SoundResource.RANDOM_ANVIL_USE;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(1, 11);
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.hammerRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic().setSpeedBonus(0.5f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * this.getAnvilTier() * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialForgeHammer;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private void setAnvilTier(int tier) {
        this.mAnvilTier = tier;
    }

    private int getAnvilTier() {
        return this.mAnvilTier;
    }
}

