/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntity_IndustrialFluidHeater
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialFluidHeater>
implements ISurvivalConstructable {
    private int mCasing1;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialFluidHeater> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialFluidHeater(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialFluidHeater(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialFluidHeater(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fluid Heater";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Fluid Heater").addInfo("120% faster than using single block machines of the same voltage").addInfo("Only uses 90% of the EU/t normally required").addInfo("Processes eight items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(5, 6, 5, true).addController("Front Center").addCasingInfoMin("Top/Bottom layer: Multi-use Casings", 34, false).addCasingInfoMin("Middle layers: Thermal Containment Casing", 47, false).addInputBus("Bottom Layer (optional)", new int[]{1}).addInputHatch("Bottom Layer", new int[]{1}).addOutputBus("Top Layer (optional)", new int[]{1}).addOutputHatch("Top Layer", new int[]{1}).addEnergyHatch("Any Multi-use Casing", new int[]{1}).addMaintenanceHatch("Any Multi-use Casing", new int[]{1}).addMufflerHatch("Any Multi-use Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialFluidHeater> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" TTT ", "TTTTT", "TTTTT", "TTTTT", " TTT "}, {" XXX ", "X---X", "X---X", "X---X", " XXX "}, {" XXX ", "X---X", "X---X", "X---X", " XXX "}, {" XXX ", "X---X", "X---X", "X---X", " XXX "}, {" X~X ", "X---X", "X---X", "X---X", " XXX "}, {" BBB ", "BBBBB", "BBBBB", "BBBBB", " BBB "}})).addElement('B', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialFluidHeater.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex((int)this.getCasingTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock2(), (int)this.getCasingMeta2()))})).addElement('X', StructureUtility.ofBlock((Block)this.getCasingBlock1(), (int)this.getCasingMeta1())).addElement('T', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialFluidHeater.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex((int)this.getCasingTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock2(), (int)this.getCasingMeta2()))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing1 = 0;
        boolean didBuild = this.checkPiece(this.mName, 2, 4, 0);
        this.log("Built? " + didBuild + ", " + this.mCasing1);
        return didBuild && this.mCasing1 >= 34 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 1);
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fluidHeaterRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic().setSpeedBonus(0.45454544f)).setEuModifier(0.9f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialThermalCentrifuge;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock1() {
        return ModBlocks.blockCasings2Misc;
    }

    public byte getCasingMeta1() {
        return 11;
    }

    public Block getCasingBlock2() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getCasingMeta2() {
        return 2;
    }

    public byte getCasingTextureIndex() {
        return (byte)TAE.getIndexFromPage(2, 2);
    }
}

