/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StreamUtil;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ChiselBus;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import team.chisel.carving.Carving;

public class GregtechMetaTileEntity_IndustrialChisel
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialChisel>
implements ISurvivalConstructable {
    private int mCasing;
    private ItemStack target;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialChisel> STRUCTURE_DEFINITION = null;
    private ItemStack mInputCache;
    private ItemStack mOutputCache;
    private GT_Recipe mCachedRecipe;
    private static ResourceLocation sChiselSound = null;

    public GregtechMetaTileEntity_IndustrialChisel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialChisel(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialChisel(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chisel";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Auto Chisel").addInfo("Target block goes in Controller slot for common Input Buses").addInfo("You can also set a target block in each Chisel Input Bus and use them as an Input Bus").addInfo("If no target is provided for common buses, the result of the first chisel is used").addInfo("Speed: +200% | EU Usage: 75% | Parallel: Tier x 16").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfoMin("Sturdy Printer Casing", 6, false).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialChisel> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialChisel.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(90).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)5))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return 90;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSpecialSlot, boolean aClearOnFailure) {
        if (this.mInputCache != null && this.mOutputCache != null && this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)aSpecialSlot, (ItemStack)this.mOutputCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mInputCache = null;
            this.mOutputCache = null;
            this.mCachedRecipe = null;
        }
        return false;
    }

    private void cacheItem(ItemStack aInputItem, ItemStack aOutputItem, GT_Recipe aRecipe) {
        this.mInputCache = aInputItem.func_77946_l();
        this.mOutputCache = aOutputItem.func_77946_l();
        this.mCachedRecipe = aRecipe;
    }

    private static boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChiselResults(ItemStack from) {
        List<ItemStack> results = GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(from);
        return results.size() > 0;
    }

    private static List<ItemStack> getItemsForChiseling(ItemStack aStack) {
        return Carving.chisel.getItemsForChiseling(aStack);
    }

    private static ItemStack getChiselOutput(ItemStack aInput, ItemStack aTarget) {
        Object tOutput = aTarget != null && GregtechMetaTileEntity_IndustrialChisel.canBeMadeFrom(aInput, aTarget) ? aTarget : (aTarget != null && !GregtechMetaTileEntity_IndustrialChisel.canBeMadeFrom(aInput, aTarget) ? null : GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(aInput).get(0));
        return tOutput;
    }

    private GT_Recipe generateChiselRecipe(ItemStack aInput) {
        boolean tIsCached = this.hasValidCache(aInput, this.target, true);
        if (tIsCached || aInput != null && GregtechMetaTileEntity_IndustrialChisel.hasChiselResults(aInput)) {
            ItemStack tOutput;
            ItemStack itemStack = tOutput = tIsCached ? this.mOutputCache.func_77946_l() : GregtechMetaTileEntity_IndustrialChisel.getChiselOutput(aInput, this.target);
            if (tOutput != null) {
                if (this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aInput, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)this.mOutputCache)) {
                    return this.mCachedRecipe;
                }
                GT_Recipe aRecipe = new GT_Recipe(false, new ItemStack[]{ItemUtils.getSimpleStack(aInput, 1)}, new ItemStack[]{ItemUtils.getSimpleStack(tOutput, 1)}, null, new int[]{10000}, new FluidStack[0], new FluidStack[0], 20, 16, 0);
                this.cacheItem(aInput, tOutput, aRecipe);
                return aRecipe;
            }
        }
        return null;
    }

    private GT_Recipe getRecipe() {
        for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
            GT_Recipe tRecipe;
            ItemStack itemsInSlot;
            int i;
            if (bus instanceof GT_MetaTileEntity_ChiselBus) {
                if (bus.mInventory[bus.func_70302_i_() - 1] == null) continue;
                this.target = bus.mInventory[bus.func_70302_i_() - 1];
                for (i = bus.func_70302_i_() - 2; i >= 0; --i) {
                    itemsInSlot = bus.mInventory[i];
                    if (itemsInSlot == null || (tRecipe = this.generateChiselRecipe(itemsInSlot)) == null) continue;
                    return tRecipe;
                }
                continue;
            }
            this.target = this.getControllerSlot();
            for (i = bus.func_70302_i_() - 1; i >= 0; --i) {
                itemsInSlot = bus.mInventory[i];
                if (itemsInSlot == null || (tRecipe = this.generateChiselRecipe(itemsInSlot)) == null) continue;
                return tRecipe;
            }
        }
        return null;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){

            @Nonnull
            protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                return GT_StreamUtil.ofNullable((Object)GregtechMetaTileEntity_IndustrialChisel.this.getRecipe());
            }
        }.setSpeedBonus(0.33333334f)).setEuModifier(0.75f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    protected void sendStartMultiBlockSoundLoop() {
        this.sendLoopStart((byte)1);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    private static ResourceLocation getChiselSound() {
        if (sChiselSound == null) {
            sChiselSound = new ResourceLocation(Carving.chisel.getVariationSound(Blocks.field_150348_b, 0));
        }
        return sChiselSound;
    }

    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        switch (aIndex) {
            case 1: {
                GT_Utility.doSoundAtClient((ResourceLocation)GregtechMetaTileEntity_IndustrialChisel.getChiselSound(), (int)this.getTimeBetweenProcessSounds(), (float)1.0f, (float)1.0f, (double)aX, (double)aY, (double)aZ);
                break;
            }
            case 8: {
                GT_Utility.doSoundAtClient((SoundResource)SoundResource.IC2_MACHINES_INTERRUPT_ONE, (int)100, (float)1.0f, (double)aX, (double)aY, (double)aZ);
            }
        }
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialChisel;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

