/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GT_Mod;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.common.GT_Pollution;
import gtPlusPlus.core.item.general.ItemAirFilter;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_Muffler_Adv
extends GT_MetaTileEntity_Hatch_Muffler
implements IAddGregtechLogo {
    protected int SLOT_FILTER = 0;
    private int mPollutionSmogLimit = 500000;
    final String[] mDescription = new String[]{"Outputs pollution from a multiblock", "DO NOT OBSTRUCT THE OUTPUT!", "Requires 3 Air Blocks in front of the exhaust face", this.mTier < 5 ? "Requires an Air Filter" : "Requires an Air Filter " + EnumChatFormatting.WHITE + "[Tier 2]" + EnumChatFormatting.GRAY, "Can take Air Filters from an input bus of the multiblock", "Reduces Pollution to " + this.calculatePollutionReduction(100, true) + "%", "Recovers " + (100 - this.calculatePollutionReduction(100, true)) + "% of CO2/CO/SO2", CORE.GT_Tooltip.get()};

    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        try {
            int a1 = GT_Mod.gregtechproxy.mPollutionSmogLimit;
            if (a1 > 0) {
                this.mPollutionSmogLimit = a1;
            }
        }
        catch (Throwable t) {
            this.mPollutionSmogLimit = 500000;
        }
    }

    public GT_MetaTileEntity_Hatch_Muffler_Adv(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{""}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Muffler_Adv(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    public String[] getDescription() {
        return this.mDescription;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Hatch_Muffler_Adv)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Hatch_Muffler_Adv)};
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex == this.SLOT_FILTER;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == this.SLOT_FILTER && this.isAirFilter(aStack);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Muffler_Adv(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean polluteEnvironment(MetaTileEntity parentTileEntity) {
        if (!this.airCheck()) {
            return false;
        }
        int emission = 10000;
        emission = this.damageAirFilter(parentTileEntity) ? this.calculatePollutionReduction(emission, true) : super.calculatePollutionReduction(emission);
        GT_Pollution.addPollution((IGregTechTileEntity)this.getBaseMetaTileEntity(), (int)emission);
        return true;
    }

    public int calculatePollutionReduction(int aPollution) {
        return this.calculatePollutionReduction(aPollution, false);
    }

    protected int calculatePollutionReduction(int aPollution, boolean ignoreFilter) {
        if (!ignoreFilter && !this.hasAirFilter()) {
            return super.calculatePollutionReduction(aPollution);
        }
        if (this.mTier < 2) {
            return (int)((double)aPollution * 0.95);
        }
        if (this.mTier > 8) {
            return 0;
        }
        return (int)((double)aPollution * Math.pow(0.64, this.mTier - 1));
    }

    private boolean airCheck() {
        ForgeDirection facing;
        IGregTechTileEntity bmte = this.getBaseMetaTileEntity();
        return bmte.getAirAtSide(facing = bmte.getFrontFacing()) && bmte.getAirAtSideAndDistance(facing, 1) && bmte.getAirAtSideAndDistance(facing, 2);
    }

    private boolean damageAirFilter(MetaTileEntity parentTileEntity) {
        if (!this.findAirFilter(parentTileEntity)) {
            return false;
        }
        ItemStack filter = this.mInventory[this.SLOT_FILTER];
        if (filter == null) {
            return false;
        }
        long currentDamage = ItemAirFilter.getFilterDamage(filter);
        if (currentDamage < ItemAirFilter.getFilterMaxDamage(filter) - 1L) {
            ItemAirFilter.setFilterDamage(filter, currentDamage + 1L);
            return true;
        }
        this.mInventory[this.SLOT_FILTER] = null;
        this.findAirFilter(parentTileEntity);
        return true;
    }

    private boolean findAirFilter(MetaTileEntity parentTileEntity) {
        if (this.hasAirFilter()) {
            return true;
        }
        if (this.mInventory[this.SLOT_FILTER] != null) {
            return false;
        }
        if (parentTileEntity == null) {
            return false;
        }
        if (parentTileEntity instanceof GT_MetaTileEntity_MultiBlockBase) {
            GT_MetaTileEntity_MultiBlockBase GTMultiBase = (GT_MetaTileEntity_MultiBlockBase)parentTileEntity;
            for (GT_MetaTileEntity_Hatch_InputBus inputBus : GTMultiBase.mInputBusses) {
                for (ItemStack stack : inputBus.mInventory) {
                    if (!this.isAirFilter(stack)) continue;
                    ItemStack stackCopy = stack.func_77946_l();
                    if (!GTMultiBase.depleteInput(stack)) continue;
                    this.mInventory[this.SLOT_FILTER] = stackCopy;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasAirFilter() {
        return this.isAirFilter(this.mInventory[this.SLOT_FILTER]);
    }

    public boolean isAirFilter(ItemStack filter) {
        if (filter == null) {
            return false;
        }
        if (filter.func_77973_b() instanceof ItemAirFilter) {
            if (this.mTier < 5) {
                return true;
            }
            return filter.func_77960_j() == 1;
        }
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.getBaseMetaTileEntity().isActive()) {
            String aParticleName = aTick % 2L == 0L ? "cloud" : "smoke";
            this.pollutionParticles(this.getBaseMetaTileEntity().getWorld(), aParticleName);
        }
    }

    public void pollutionParticles(World aWorld, String name) {
        float zSpd;
        float xSpd;
        boolean chk3;
        boolean chk2;
        float ran1 = CORE.RANDOM.nextFloat();
        float ran2 = 0.0f;
        float ran3 = 0.0f;
        boolean chk1 = ran1 * 100.0f < (float)this.calculatePollutionReduction(100);
        int aPollutionAmount = PollutionUtils.getPollution(this.getBaseMetaTileEntity());
        if (aPollutionAmount >= this.mPollutionSmogLimit) {
            ran2 = CORE.RANDOM.nextFloat();
            ran3 = CORE.RANDOM.nextFloat();
            chk2 = ran2 * 100.0f < (float)this.calculatePollutionReduction(100);
            boolean bl = chk3 = ran3 * 100.0f < (float)this.calculatePollutionReduction(100);
            if (!(chk1 || chk2 || chk3)) {
                return;
            }
        } else {
            if (!chk1) {
                return;
            }
            chk3 = false;
            chk2 = false;
        }
        IGregTechTileEntity aMuffler = this.getBaseMetaTileEntity();
        ForgeDirection aDir = aMuffler.getFrontFacing();
        float xPos = (float)aDir.offsetX * 0.76f + (float)aMuffler.getXCoord() + 0.25f;
        float yPos = (float)aDir.offsetY * 0.76f + (float)aMuffler.getYCoord() + 0.25f;
        float zPos = (float)aDir.offsetZ * 0.76f + (float)aMuffler.getZCoord() + 0.25f;
        float ySpd = (float)aDir.offsetY * 0.1f + 0.2f + 0.1f * CORE.RANDOM.nextFloat();
        if (aDir.offsetY == -1) {
            float temp = CORE.RANDOM.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)aDir.offsetX * (0.1f + 0.2f * CORE.RANDOM.nextFloat());
            zSpd = (float)aDir.offsetZ * (0.1f + 0.2f * CORE.RANDOM.nextFloat());
        }
        if (chk1) {
            aWorld.func_72869_a(name, (double)(xPos + ran1 * 0.5f), (double)(yPos + CORE.RANDOM.nextFloat() * 0.5f), (double)(zPos + CORE.RANDOM.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
        if (chk2) {
            aWorld.func_72869_a(name, (double)(xPos + ran2 * 0.5f), (double)(yPos + CORE.RANDOM.nextFloat() * 0.5f), (double)(zPos + CORE.RANDOM.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
        if (chk3) {
            aWorld.func_72869_a(name, (double)(xPos + ran3 * 0.5f), (double)(yPos + CORE.RANDOM.nextFloat() * 0.5f), (double)(zPos + CORE.RANDOM.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
    }

    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setMainBackground((UITexture)GTPP_UITextures.BACKGROUND_YELLOW).setItemSlot((UITexture)GTPP_UITextures.SLOT_ITEM_YELLOW).setTitleTab(GTPP_UITextures.TAB_TITLE_YELLOW, GTPP_UITextures.TAB_TITLE_DARK_YELLOW, GTPP_UITextures.TAB_TITLE_ANGULAR_YELLOW);
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(stack -> stack.func_77973_b() instanceof ItemAirFilter).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).setPos(79, 34));
    }
}

