/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.circuit;

import com.gtnewhorizons.modularui.api.UIInfos;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.INetworkUpdatableItem;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_UpdateItem;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.uifactory.SelectItemUIFactory;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang3.tuple.Pair;

public class GTPP_IntegratedCircuit_Item
extends Item
implements INetworkUpdatableItem {
    private final List<ItemStack> ALL_VARIANTS = new ArrayList<ItemStack>();
    private final String iconLocation;
    protected IIcon base;

    public GTPP_IntegratedCircuit_Item(String unlocalizedName, String iconLocation) {
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77655_b(unlocalizedName);
        this.iconLocation = iconLocation;
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
        this.ALL_VARIANTS.add(new ItemStack((Item)this, 0, 0));
        for (int i = 1; i <= 24; ++i) {
            ItemStack aStack = new ItemStack((Item)this, 0, i);
            this.ALL_VARIANTS.add(aStack);
        }
    }

    public boolean func_77645_m() {
        return false;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
        try {
            aList.add("Configuration == " + aStack.func_77960_j());
            aList.add(GT_LanguageManager.addStringLocalization((String)(this.func_77658_a() + ".tooltip.0"), (String)"Right click to reconfigure"));
            aList.add(GT_LanguageManager.addStringLocalization((String)(this.func_77658_a() + ".tooltip.1"), (String)"Needs a screwdriver or circuit programming tool"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        super.func_77624_a(aStack, p_77624_2_, aList, p_77624_4_);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.common;
    }

    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        aList.add(ItemUtils.simpleMetaStack(aItem, 0, 1));
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void func_94581_a(IIconRegister u) {
        this.base = u.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.iconLocation);
    }

    public IIcon func_77618_c(int damage, int pass) {
        return this.base;
    }

    public IIcon func_77617_a(int damage) {
        return this.base;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.base;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.base;
    }

    public boolean receive(ItemStack stack, EntityPlayerMP player, NBTTagCompound tag) {
        int meta;
        int n = meta = tag.func_150297_b("meta", 1) ? (int)tag.func_74771_c("meta") : -1;
        if (meta < 0 || meta > 24) {
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> toolIndex = GTPP_IntegratedCircuit_Item.findConfiguratorInInv((EntityPlayer)player);
            if (toolIndex == null) {
                return true;
            }
            ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
            mainInventory[((Integer)toolIndex.getKey()).intValue()] = (ItemStack)((BiFunction)toolIndex.getValue()).apply(mainInventory[(Integer)toolIndex.getKey()], player);
        }
        stack.func_77964_b(meta);
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack configuratorStack;
        if (player instanceof FakePlayer || !world.field_72995_K) {
            return stack;
        }
        if (player.field_71075_bZ.field_75098_d) {
            configuratorStack = null;
        } else {
            Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> configurator = GTPP_IntegratedCircuit_Item.findConfiguratorInInv(player);
            if (configurator == null) {
                int count;
                try {
                    count = Integer.parseInt(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.no_screwdriver.count"));
                }
                catch (NumberFormatException e) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error in translation GT5U.item.programmed_circuit.no_screwdriver.count: " + e.getMessage()));
                    count = 1;
                }
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.item.programmed_circuit.no_screwdriver." + XSTR.XSTR_INSTANCE.nextInt(count), new Object[0]));
                return stack;
            }
            configuratorStack = player.field_71071_by.field_70462_a[(Integer)configurator.getKey()];
        }
        this.openSelectorGui(configuratorStack, stack.func_77960_j(), player);
        return stack;
    }

    private void openSelectorGui(ItemStack configurator, int meta, EntityPlayer player) {
        UIInfos.openClientUI((EntityPlayer)player, buildContext -> new SelectItemUIFactory(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.select.header"), configurator, GTPP_IntegratedCircuit_Item::onConfigured, this.ALL_VARIANTS, meta, true).createWindow(buildContext));
    }

    private static void onConfigured(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("meta", (byte)stack.func_77960_j());
        GT_Values.NW.sendToServer((GT_Packet)new GT_Packet_UpdateItem(tag));
    }

    private static Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> findConfiguratorInInv(EntityPlayer player) {
        ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
        int mainInventoryLength = mainInventory.length;
        for (int j = 0; j < mainInventoryLength; ++j) {
            ItemStack toolStack = mainInventory[j];
            if (!GT_Utility.isStackValid((ItemStack)toolStack)) continue;
            for (Map.Entry p : GregTech_API.sCircuitProgrammerList.entrySet()) {
                if (!((Predicate)p.getKey()).test(toolStack)) continue;
                return Pair.of((Object)j, (Object)((BiFunction)p.getValue()));
            }
        }
        return null;
    }
}

