/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_LWJGL_Keyboard {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    private static final HashMap<String, String> mBadKeyCache = new HashMap();
    private static Class mKeyboard;
    private static Field mKeyName;
    private boolean isClientSettingsObfuscated = false;

    public static synchronized String getKeyName(int key) {
        String[] aTemp;
        if (ClassTransformer_LWJGL_Keyboard.init() && key < (aTemp = ClassTransformer_LWJGL_Keyboard.getKeyName()).length && key >= 0) {
            return aTemp[key];
        }
        String aCachedValue = mBadKeyCache.get("key-" + key);
        if (aCachedValue == null) {
            FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Unable to map key code " + key + " to LWJGL keymap."), (Object[])new Object[0]);
            FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)"Caching key value to be empty.", (Object[])new Object[0]);
            aCachedValue = "FIX!";
            mBadKeyCache.put("key-" + key, aCachedValue);
            ClassTransformer_LWJGL_Keyboard.trySetClientKey(key);
        }
        return aCachedValue;
    }

    public static void trySetClientKey(int aKey) {
        if (Utils.isClient() && ReflectionUtils.doesClassExist("net.minecraft.client.Minecraft")) {
            FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)"Trying to set key value to be empty.", (Object[])new Object[0]);
            GameSettings options = Minecraft.func_71410_x().field_71474_y;
            KeyBinding[] akeybinding = Minecraft.func_71410_x().field_71474_y.field_74324_K;
            int i = akeybinding.length;
            for (KeyBinding keybinding : akeybinding) {
                if (keybinding == null || keybinding.func_151463_i() != aKey) continue;
                options.func_151440_a(keybinding, 0);
                FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Set keybind " + aKey + " to 0."), (Object[])new Object[0]);
                break;
            }
        }
    }

    private static boolean init() {
        Field aKeyName;
        if (mKeyName != null) {
            return true;
        }
        Class<?> aKeyboard = ReflectionUtils.getClass("org.lwjgl.input.Keyboard");
        if (aKeyboard != null && (aKeyName = ReflectionUtils.getField(mKeyboard = aKeyboard, "keyName")) != null) {
            mKeyName = aKeyName;
        }
        return mKeyName != null;
    }

    private static String[] getKeyName() {
        if (ClassTransformer_LWJGL_Keyboard.init()) {
            try {
                Object o = mKeyName.get(null);
                if (o instanceof String[]) {
                    String[] y = (String[])o;
                    return y;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return new String[0];
    }

    public ClassTransformer_LWJGL_Keyboard(byte[] basicClass, boolean isClientSettings) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        if (!isClientSettings) {
            aTempReader.accept((ClassVisitor)new PatchLWJGL((ClassVisitor)aTempWriter), 0);
            this.injectLWJGLPatch(aTempWriter);
        } else {
            aTempReader.accept((ClassVisitor)new PatchClientSettings((ClassVisitor)aTempWriter), 0);
            this.injectClientSettingPatch(aTempWriter);
        }
        this.isValid = aTempReader != null && aTempWriter != null;
        FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Valid? " + this.isValid + "."), (Object[])new Object[0]);
        this.reader = aTempReader;
        this.writer = aTempWriter;
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectLWJGLPatch(ClassWriter cw) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)"Injecting getKeyName.", (Object[])new Object[0]);
        MethodVisitor mv = cw.visitMethod(41, "getKeyName", "(I)Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(49, l0);
        mv.visitVarInsn(21, 0);
        mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_LWJGL_Keyboard", "getKeyName", "(I)Ljava/lang/String;", false);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("key", "I", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        didInject = true;
        FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public boolean injectClientSettingPatch(ClassWriter cw) {
        boolean didInject = false;
        String aMethodName = this.isClientSettingsObfuscated ? "func_74298_c" : "getKeyDisplayString";
        FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Injecting " + aMethodName + "."), (Object[])new Object[0]);
        MethodVisitor mv = cw.visitMethod(9, aMethodName, "(I)Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(130, l0);
        mv.visitVarInsn(21, 0);
        mv.visitMethodInsn(184, "gtPlusPlus/preloader/keyboard/BetterKeyboard", "getKeyDisplayString", "(I)Ljava/lang/String;", false);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("p_74298_0_", "I", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        didInject = true;
        FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public class PatchLWJGL
    extends ClassVisitor {
        private final String[] aMethodsToStrip;

        public PatchLWJGL(ClassVisitor cv) {
            super(327680, cv);
            this.aMethodsToStrip = new String[]{"getKeyName"};
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean found = false;
            for (String s : this.aMethodsToStrip) {
                if (!name.equals(s)) continue;
                found = true;
                break;
            }
            MethodVisitor methodVisitor = !found ? super.visitMethod(access, name, desc, signature, exceptions) : null;
            if (found) {
                FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
            }
            return methodVisitor;
        }
    }

    public class PatchClientSettings
    extends ClassVisitor {
        private final String[] aMethodsToStrip;

        public PatchClientSettings(ClassVisitor cv) {
            super(327680, cv);
            this.aMethodsToStrip = new String[]{"func_74298_c", "getKeyDisplayString"};
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean found = false;
            for (String s : this.aMethodsToStrip) {
                if (!name.equals(s)) continue;
                if (name.equals(this.aMethodsToStrip[0])) {
                    ClassTransformer_LWJGL_Keyboard.this.isClientSettingsObfuscated = true;
                } else {
                    ClassTransformer_LWJGL_Keyboard.this.isClientSettingsObfuscated = false;
                }
                found = true;
                break;
            }
            MethodVisitor methodVisitor = !found ? super.visitMethod(access, name, desc, signature, exceptions) : null;
            if (found) {
                FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
            }
            return methodVisitor;
        }
    }
}

