/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import forestry.core.tiles.EscritoireGame;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;

public class EscritoireTextSource {
    private static final ListMultimap<Notes, String> researchNotes;
    private static final Random random;
    private String researchNote;
    private Notes lastNoteLevel;

    public String getText(EscritoireGame escritoireGame) {
        Notes noteLevel = EscritoireTextSource.getNoteLevel(escritoireGame);
        if (this.lastNoteLevel != noteLevel) {
            this.researchNote = EscritoireTextSource.getRandomNote(noteLevel);
            this.lastNoteLevel = noteLevel;
        }
        return this.researchNote;
    }

    private static String getRandomNote(Notes level) {
        List candidates = researchNotes.get((Object)level);
        int index = random.nextInt(candidates.size());
        return (String)candidates.get(index);
    }

    public static Notes getNoteLevel(EscritoireGame game) {
        EscritoireGame.Status status = game.getStatus();
        switch (status) {
            case PLAYING: {
                int bounty = game.getBountyLevel();
                if (bounty >= 16) {
                    return Notes.level1;
                }
                if (bounty > 8) {
                    return Notes.level2;
                }
                if (bounty > 4) {
                    return Notes.level3;
                }
                return Notes.level4;
            }
            case FAILURE: {
                return Notes.failure;
            }
            case SUCCESS: {
                return Notes.success;
            }
            case EMPTY: {
                return Notes.empty;
            }
        }
        return null;
    }

    static {
        random = new Random();
        researchNotes = ArrayListMultimap.create();
        EnumSet<Notes[]> multipleTranslationNoteLevels = EnumSet.of(Notes.level1, new Notes[]{Notes.level2, Notes.level3, Notes.level4, Notes.success, Notes.failure});
        for (Notes notes : multipleTranslationNoteLevels) {
            int levelCount = Integer.valueOf(StringUtil.localize("gui.escritoire.notes." + (Object)((Object)notes) + ".count").replaceAll("\u00a7\\d", ""));
            for (int i = 1; i <= levelCount; ++i) {
                String note = StringUtil.localize("gui.escritoire.notes." + (Object)((Object)notes) + '.' + i);
                researchNotes.put((Object)notes, (Object)note);
            }
        }
        researchNotes.put((Object)Notes.empty, (Object)StringUtil.localize("gui.escritoire.instructions"));
    }

    private static enum Notes {
        level1,
        level2,
        level3,
        level4,
        success,
        failure,
        empty;

    }
}

