/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockForestry;
import forestry.core.circuits.ISocketable;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.utils.InventoryUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    private long previousMessageTick = 0L;

    protected BlockStructure(Material material) {
        super(material);
        this.func_149711_c(1.0f);
    }

    public boolean func_149700_E() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        String validationError;
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof MultiblockTileEntityForestry)) {
            return false;
        }
        MultiblockTileEntityForestry part = (MultiblockTileEntityForestry)tile;
        IMultiblockController controller = part.getMultiblockLogic().getController();
        if (player.func_71045_bC() == null && !controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
            long tick = world.func_82737_E();
            if (tick > this.previousMessageTick + 20L) {
                player.func_145747_a((IChatComponent)new ChatComponentText(validationError));
                this.previousMessageTick = tick;
            }
            return true;
        }
        if (controller == null || !controller.isAssembled()) {
            return false;
        }
        if (!world.field_72995_K) {
            part.openGui(player);
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityLiving, ItemStack itemstack) {
        if (world.field_72995_K) {
            return;
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            TileEntity tile = world.func_147438_o(i, j, k);
            if (tile instanceof MultiblockTileEntityForestry) {
                MultiblockTileEntityForestry tileForestry = (MultiblockTileEntityForestry)tile;
                GameProfile gameProfile = player.func_146103_bH();
                tileForestry.setOwner(gameProfile);
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        IMultiblockComponent part;
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IMultiblockComponent && MultiblockUtil.getNeighboringParts(world, part = (IMultiblockComponent)tile).size() == 0) {
            if (tile instanceof IInventory) {
                InventoryUtil.dropInventory((IInventory)tile, world, x, y, z);
            }
            if (tile instanceof ISocketable) {
                InventoryUtil.dropSockets((ISocketable)tile, world, x, y, z);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

