/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.config.Config;
import forestry.core.utils.Log;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.plugins.PluginLepidopterology;
import net.minecraft.world.World;

public class ButterflySpawner
implements ILeafTickHandler {
    @Override
    public boolean onRandomLeafTick(ITree tree, World world, int x, int y, int z, boolean isDestroyed) {
        if (Config.disableButterfly) {
            return false;
        }
        if (world.field_73012_v.nextFloat() >= tree.getGenome().getSappiness() * tree.getGenome().getYield()) {
            return false;
        }
        IButterfly spawn = ButterflyManager.butterflyRoot.getIndividualTemplates().get(world.field_73012_v.nextInt(ButterflyManager.butterflyRoot.getIndividualTemplates().size()));
        if (world.field_73012_v.nextFloat() >= spawn.getGenome().getPrimary().getRarity() * 0.5f) {
            return false;
        }
        if (world.func_72907_a(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
            return false;
        }
        if (!spawn.canSpawn(world, x, y, z)) {
            return false;
        }
        if (world.func_147437_c(x - 1, y, z)) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, x - 1, y, z);
        } else if (world.func_147437_c(x + 1, y, z)) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, x + 1, y, z);
        } else if (world.func_147437_c(x, y, z - 1)) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, x, y, z - 1);
        } else if (world.func_147437_c(x, y, z + 1)) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, x, y, z + 1);
        }
        return false;
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, double x, double y, double z) {
        if (ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), x, y + (double)0.1f, z) != null) {
            Log.finest("Spawned a butterfly '%s' at %s/%s/%s.", butterfly.getDisplayName(), x, y, z);
        }
    }
}

