/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.math.BigDecimal;

public class MathUtil {
    private static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    private static final BigDecimal MIN_FLOAT = BigDecimal.valueOf(-3.4028234663852886E38);

    private static float clampToFloatRange(BigDecimal result) {
        if (result.compareTo(MAX_FLOAT) > 0) {
            return Float.MAX_VALUE;
        }
        if (result.compareTo(MIN_FLOAT) < 0) {
            return -3.4028235E38f;
        }
        return result.floatValue();
    }

    public static float safeMultiply(float a, float b) {
        BigDecimal bigA = BigDecimal.valueOf(a);
        BigDecimal bigB = BigDecimal.valueOf(b);
        return MathUtil.clampToFloatRange(bigA.multiply(bigB));
    }

    public static float safeAdd(float a, float b) {
        BigDecimal bigA = BigDecimal.valueOf(a);
        BigDecimal bigB = BigDecimal.valueOf(b);
        return MathUtil.clampToFloatRange(bigA.add(bigB));
    }
}

