/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;

public class NEIUtils {
    public static String translate(String unlocalized) {
        return StatCollector.func_74838_a((String)("neiintegration." + unlocalized));
    }

    public static List<ItemStack> getItemVariations(ItemStack base) {
        ArrayList<ItemStack> variations = new ArrayList<ItemStack>();
        base.func_77973_b().func_150895_a(base.func_77973_b(), null, variations);
        Iterator itr = variations.iterator();
        while (itr.hasNext()) {
            ItemStack stack = (ItemStack)itr.next();
            if (base.func_77969_a(stack) && stack.func_77942_o()) continue;
            itr.remove();
        }
        if (variations.isEmpty()) {
            return Collections.singletonList(base);
        }
        return variations;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        if (stack != null) {
            Fluid fluid;
            FluidStack fluidStack = null;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            }
            if (fluidStack == null) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (fluidStack == null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)stack.func_77973_b())).getFluid()) != null) {
                fluidStack = new FluidStack(fluid, 1000);
            }
            return fluidStack;
        }
        return null;
    }

    public static boolean areFluidsSameType(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null || fluidStack2 == null) {
            return false;
        }
        return fluidStack1.getFluid() == fluidStack2.getFluid();
    }
}

