/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.config.Constants;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerTile;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ILocatable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;

public abstract class MultiblockTileEntityForestry<T extends IMultiblockLogic>
extends MultiblockTileEntityBase<T>
implements ISidedInventory,
IFilterSlotDelegate,
ILocatable,
IGuiHandlerTile {
    private GameProfile owner;

    public MultiblockTileEntityForestry(T multiblockLogic) {
        super(multiblockLogic);
    }

    public void openGui(EntityPlayer player) {
        GuiHandler.openGui(player, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.func_74775_l("owner"));
        }
        this.getInternalInventory().readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbt.func_82580_o("Properties");
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        this.getInternalInventory().writeToNBT(data);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public boolean allowsAutomation() {
        return false;
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public final ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_70295_k_() {
        this.getInternalInventory().func_70295_k_();
    }

    public final void func_70305_f() {
        this.getInternalInventory().func_70305_f();
    }

    public final String func_145825_b() {
        return this.getInternalInventory().func_145825_b();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public final int[] func_94128_d(int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_94128_d(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_102007_a(slotIndex, itemStack, side);
        }
        return false;
    }

    public final boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_102008_b(slotIndex, itemStack, side);
        }
        return false;
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final GameProfile getOwner() {
        return this.owner;
    }

    public final void setOwner(GameProfile owner) {
        this.owner = owner;
    }
}

