/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumLeafType;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IToolScoop;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.arboriculture.LeafDecayHelper;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.render.TextureLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockForestryLeaves
extends BlockNewLeaf
implements ITileEntityProvider,
IGrowable {
    private final ThreadLocal<ArrayList<ItemStack>> drops = new ThreadLocal();
    @SideOnly(value=Side.CLIENT)
    private static IIcon defaultIcon;

    public BlockForestryLeaves() {
        this.func_149647_a(Tabs.tabArboriculture);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLeaves();
    }

    public static TileLeaves getLeafTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileLeaves) {
            return (TileLeaves)tile;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (ITree tree : TreeManager.treeRoot.getIndividualTemplates()) {
            TileLeaves leaves = new TileLeaves();
            leaves.setDecorative();
            leaves.setTree(tree);
            NBTTagCompound leavesNBT = new NBTTagCompound();
            leaves.writeToNBTDecorative(leavesNBT);
            ItemStack itemStack = new ItemStack(item, 1, 0);
            itemStack.func_77982_d(leavesNBT);
            list.add(itemStack);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        ItemStack held;
        TileLeaves leafTile = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (leafTile == null || leafTile.isDecorative()) {
            return;
        }
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        float saplingModifier = 1.0f;
        if (!world.field_72995_K && (held = player.field_71071_by.func_70448_g()) != null && held.func_77973_b() instanceof IToolGrafter) {
            saplingModifier = ((IToolGrafter)held.func_77973_b()).getSaplingModifier(held, world, player, x, y, z);
            held.func_77972_a(1, (EntityLivingBase)player);
            if (held.field_77994_a <= 0) {
                player.func_71028_bD();
            }
        }
        GameProfile playerProfile = player.func_146103_bH();
        ArrayList<ItemStack> leafDrops = BlockForestryLeaves.getLeafDrop(world, playerProfile, x, y, z, saplingModifier, fortune);
        this.drops.set(leafDrops);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = BlockForestryLeaves.getLeafDrop(world, null, x, y, z, 1.0f, fortune);
        }
        return ret;
    }

    private static ArrayList<ItemStack> getLeafDrop(World world, @Nullable GameProfile playerProfile, int x, int y, int z, float saplingModifier, int fortune) {
        ITree[] saplings;
        ArrayList<ItemStack> prod = new ArrayList<ItemStack>();
        TileLeaves tile = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tile == null || tile.getTree() == null || tile.isDecorative()) {
            return prod;
        }
        for (ITree sapling : saplings = tile.getTree().getSaplings(world, playerProfile, x, y, z, saplingModifier)) {
            if (sapling == null) continue;
            prod.add(TreeManager.treeRoot.getMemberStack(sapling, EnumGermlingType.SAPLING.ordinal()));
        }
        if (tile.hasFruit()) {
            Collections.addAll(prod, tile.getTree().produceStacks(world, x, y, z, tile.getRipeningTime()));
        }
        return prod;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = super.getPickBlock(target, world, x, y, z);
        TileLeaves leaves = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        NBTTagCompound leavesNBT = new NBTTagCompound();
        leaves.writeToNBTDecorative(leavesNBT);
        itemStack.func_77982_d(leavesNBT);
        return itemStack;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList ret = super.onSheared(item, world, x, y, z, fortune);
        TileLeaves leaves = BlockForestryLeaves.getLeafTile(world, x, y, z);
        NBTTagCompound shearedLeavesNBT = new NBTTagCompound();
        leaves.writeToNBTDecorative(shearedLeavesNBT);
        for (ItemStack stack : ret) {
            if (!(stack.func_77973_b() instanceof ItemBlockLeaves)) continue;
            stack.func_77982_d(shearedLeavesNBT);
        }
        return ret;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        TileLeaves tile = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tile == null || tile.isDecorative()) {
            return;
        }
        super.beginLeavesDecay(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TileLeaves tileLeaves = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tileLeaves != null && TreeDefinition.Willow.getUID().equals(tileLeaves.getSpeciesUID())) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        entity.field_70159_w *= 0.4;
        entity.field_70179_y *= 0.4;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileLeaves tileLeaves = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tileLeaves == null || tileLeaves.isDecorative()) {
            return;
        }
        LeafDecayHelper.leafDecay((BlockLeaves)this, world, x, y, z);
        if (tileLeaves.func_145837_r()) {
            return;
        }
        if ((double)world.field_73012_v.nextFloat() > 0.1) {
            return;
        }
        tileLeaves.onBlockTick();
    }

    public boolean func_149662_c() {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    public int func_149645_b() {
        return PluginArboriculture.modelIdLeaves;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileLeaves leaves = BlockForestryLeaves.getLeafTile(world, x, y, z);
        if (leaves == null) {
            return super.func_149720_d(world, x, y, z);
        }
        int colour = leaves.getFoliageColour((EntityPlayer)Proxies.common.getClientInstance().field_71439_g);
        if (colour == PluginArboriculture.proxy.getFoliageColorBasic()) {
            colour = super.func_149720_d(world, x, y, z);
        }
        return colour;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        TextureLeaves.registerAllIcons(register);
        defaultIcon = TextureLeaves.get(EnumLeafType.DECIDUOUS).getFancy();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileLeaves leaves = BlockForestryLeaves.getLeafTile(world, x, y, z);
        if (leaves != null) {
            return leaves.getIcon(Proxies.render.fancyGraphicsEnabled());
        }
        return defaultIcon;
    }

    public String[] func_150125_e() {
        return new String[0];
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 60;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        IButterfly caterpillar;
        ItemStack heldItem = player.func_70694_bm();
        TileEntity tile = world.func_147438_o(x, y, z);
        IButterfly iButterfly = caterpillar = tile instanceof TileLeaves ? ((TileLeaves)tile).getCaterpillar() : null;
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
            ItemStack butterfly = ButterflyManager.butterflyRoot.getMemberStack(caterpillar, EnumFlutterType.CATERPILLAR.ordinal());
            ItemStackUtil.dropItemStackAsEntity(butterfly, world, x, y, z);
            ((TileLeaves)tile).setCaterpillar(null);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        TileLeaves leafTile = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (leafTile != null) {
            return leafTile.hasFruit() && leafTile.getRipeness() < 1.0f;
        }
        return false;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        TileLeaves leafTile = BlockForestryLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (leafTile != null) {
            leafTile.addRipeness(1.0f);
        }
    }
}

