/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.blocks.IMachinePropertiesTESR;
import forestry.core.proxy.Proxies;
import forestry.core.render.IBlockRenderer;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEscritoire;
import forestry.core.tiles.TileForestry;
import forestry.plugins.PluginApiculture;
import javax.annotation.Nullable;

public enum BlockCoreType implements IMachinePropertiesTESR
{
    ANALYZER(TileAnalyzer.class, "Analyzer"){

        @Override
        @Nullable
        public IBlockRenderer getRenderer() {
            return PluginApiculture.proxy.getRendererAnalyzer("textures/blocks/analyzer_");
        }
    }
    ,
    ESCRITOIRE(TileEscritoire.class, "Escritoire"){

        @Override
        @Nullable
        public IBlockRenderer getRenderer() {
            return Proxies.render.getRenderEscritoire();
        }
    };

    public static final BlockCoreType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;

    private BlockCoreType(Class<? extends TileForestry> teClass, String teName) {
        this.teIdent = "forestry." + teName;
        this.teClass = teClass;
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    static {
        VALUES = BlockCoreType.values();
    }
}

