/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.access.IAccessHandler;
import forestry.core.blocks.BlockForestry;
import forestry.core.blocks.IMachineProperties;
import forestry.core.circuits.ISocketable;
import forestry.core.fluids.FluidHelper;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.MachineDefinition;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBase<T extends IMachineProperties>
extends BlockForestry {
    private final List<MachineDefinition> definitions = new ArrayList<MachineDefinition>();
    private final boolean hasTESR;

    public BlockBase() {
        this(false);
    }

    public BlockBase(boolean hasTESR) {
        super(Material.field_151573_f);
        this.hasTESR = hasTESR;
        this.field_149787_q = this.func_149662_c();
        this.field_149786_r = this.func_149662_c() ? 255 : 0;
    }

    public void addDefinitions(MachineDefinition ... definitions) {
        for (MachineDefinition definition : definitions) {
            this.addDefinition(definition);
        }
    }

    public void addDefinition(MachineDefinition definition) {
        definition.setBlock((Block)this);
        while (this.definitions.size() <= definition.getMeta()) {
            this.definitions.add(null);
        }
        this.definitions.set(definition.getMeta(), definition);
    }

    public boolean func_149662_c() {
        return !this.hasTESR;
    }

    public boolean func_149686_d() {
        return !this.hasTESR;
    }

    public int func_149645_b() {
        if (this.hasTESR) {
            return Proxies.render.getByBlockModelRenderId();
        }
        return 0;
    }

    private MachineDefinition getDefinition(IBlockAccess world, int x, int y, int z) {
        if (!(world.func_147439_a(x, y, z) instanceof BlockBase)) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        return this.getDefinition(meta);
    }

    private MachineDefinition getDefinition(int metadata) {
        if (metadata < 0 || metadata >= this.definitions.size()) {
            return null;
        }
        return this.definitions.get(metadata);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.func_149668_a(world, x, y, z);
        }
        return definition.getBoundingBox(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.func_149668_a(world, x, y, z);
        }
        return definition.getBoundingBox(x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.func_149731_a(world, x, y, z, startVec, endVec);
        }
        return definition.collisionRayTrace(world, x, y, z, startVec, endVec);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (MachineDefinition definition : this.definitions) {
            if (definition == null) continue;
            definition.getSubBlocks(item, tab, list);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        MachineDefinition definition = this.getDefinition(metadata);
        if (definition == null) {
            return null;
        }
        return definition.createMachine();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        MachineDefinition definition = this.getDefinition(world, x, y, z);
        return definition != null && definition.isSolidOnSide(world, x, y, z, side.ordinal());
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        TileBase tile = (TileBase)world.func_147438_o(x, y, z);
        if (!TileUtil.isUsableByPlayer(player, tile)) {
            return false;
        }
        IAccessHandler access = tile.getAccessHandler();
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() != Items.field_151133_ar && tile instanceof IFluidHandler && access.allowsAlteration(player) && FluidHelper.handleRightClick((IFluidHandler)tile, ForgeDirection.getOrientation((int)side), player, true, tile.canDrainWithBucket())) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (access.allowsViewing(player)) {
            tile.openGui(player);
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.accesslocked", new Object[]{PlayerUtil.getOwnerName(access)}));
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.rotateBlock(world, x, y, z, axis);
        }
        return definition.rotateBlock(world, x, y, z, axis);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            InventoryUtil.dropInventory(inventory, world, x, y, z);
            if (tile instanceof TileForestry) {
                ((TileForestry)tile).onRemoval();
            }
            if (tile instanceof ISocketable) {
                InventoryUtil.dropSockets((ISocketable)tile, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void init() {
        for (MachineDefinition def : this.definitions) {
            if (def == null) continue;
            def.register();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (MachineDefinition def : this.definitions) {
            if (def == null) continue;
            def.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            return null;
        }
        return this.definitions.get(metadata).getBlockTextureForSide(side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        return this.definitions.get(metadata).getIcon(world, x, y, z, side);
    }

    public boolean func_149710_n() {
        return this.hasTESR;
    }

    public final ItemStack get(T type) {
        return new ItemStack((Block)this, 1, type.getMeta());
    }
}

