/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.apiculture.AlvearyBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.multiblock.AlvearyMultiblockSizeLimits;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.core.access.EnumAccess;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlvearyController
extends RectangularMultiblockControllerBase
implements IAlvearyControllerInternal,
IClimateControlled {
    private final InventoryBeeHousing inventory;
    private final IBeekeepingLogic beekeepingLogic;
    private float tempChange = 0.0f;
    private float humidChange = 0.0f;
    private final Set<IBeeModifier> beeModifiers = new HashSet<IBeeModifier>();
    private final Set<IBeeListener> beeListeners = new HashSet<IBeeListener>();
    private final Set<IAlvearyComponent.Climatiser> climatisers = new HashSet<IAlvearyComponent.Climatiser>();
    private final Set<IAlvearyComponent.Active> activeComponents = new HashSet<IAlvearyComponent.Active>();
    private int breedingProgressPercent = 0;

    public AlvearyController(World world) {
        super(world, AlvearyMultiblockSizeLimits.instance);
        this.inventory = new InventoryBeeHousing(9, this.getAccessHandler());
        this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
        this.beeModifiers.add(new AlvearyBeeModifier());
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return this.beeListeners;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return this.beeModifiers;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IAlvearyComponent) {
            if (newPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)newPart;
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.add(beeModifier);
            }
            if (newPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)newPart;
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.add(beeListener);
            }
            if (newPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.add((IAlvearyComponent.Climatiser)newPart);
            }
            if (newPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.add((IAlvearyComponent.Active)newPart);
            }
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IAlvearyComponent) {
            if (oldPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)oldPart;
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.remove(beeModifier);
            }
            if (oldPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)oldPart;
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.remove(beeListener);
            }
            if (oldPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.remove(oldPart);
            }
            if (oldPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.remove(oldPart);
            }
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        super.isMachineWhole();
        ChunkCoordinates maximumCoord = this.getMaximumCoord();
        ChunkCoordinates minimumCoord = this.getMinimumCoord();
        int slabY = maximumCoord.field_71572_b + 1;
        for (int slabX = minimumCoord.field_71574_a; slabX <= maximumCoord.field_71574_a; ++slabX) {
            for (int slabZ = minimumCoord.field_71573_c; slabZ <= maximumCoord.field_71573_c; ++slabZ) {
                Block block = this.worldObj.func_147439_a(slabX, slabY, slabZ);
                if (!BlockUtil.isWoodSlabBlock(block)) {
                    throw new MultiblockValidationException(StatCollector.func_74838_a((String)"for.multiblock.alveary.error.needSlabs"));
                }
                int meta = this.worldObj.func_72805_g(slabX, slabY, slabZ);
                if ((meta & 8) == 0) continue;
                throw new MultiblockValidationException(StatCollector.func_74838_a((String)"for.multiblock.alveary.error.needSlabs"));
            }
        }
        int airY = maximumCoord.field_71572_b;
        for (int airX = minimumCoord.field_71574_a - 1; airX <= maximumCoord.field_71574_a + 1; ++airX) {
            for (int airZ = minimumCoord.field_71573_c - 1; airZ <= maximumCoord.field_71573_c + 1; ++airZ) {
                Block block;
                if (this.isCoordInMultiblock(airX, airY, airZ) || !(block = this.worldObj.func_147439_a(airX, airY, airZ)).func_149662_c()) continue;
                throw new MultiblockValidationException(StatCollector.func_74838_a((String)"for.multiblock.alveary.error.needSpace"));
            }
        }
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (level == 2 && !(part instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(StatCollector.func_74838_a((String)"for.multiblock.alveary.error.needPlainOnTop"));
        }
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(StatCollector.func_74838_a((String)"for.multiblock.alveary.error.needPlainInterior"));
        }
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        boolean canWork = this.beekeepingLogic.canWork();
        if (canWork) {
            this.beekeepingLogic.doWork();
        }
        for (IAlvearyComponent.Climatiser climatiser : this.climatisers) {
            climatiser.changeClimate(tickCount, this);
        }
        this.tempChange = AlvearyController.equalizeChange(this.tempChange);
        this.humidChange = AlvearyController.equalizeChange(this.humidChange);
        return canWork;
    }

    private static float equalizeChange(float change) {
        if (change == 0.0f) {
            return 0.0f;
        }
        if ((change *= 0.95f) <= 0.001f && change >= -0.001f) {
            change = 0.0f;
        }
        return change;
    }

    @Override
    protected void updateClient(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateClient(tickCount);
        }
        if (this.beekeepingLogic.canDoBeeFX() && this.updateOnInterval(2)) {
            this.beekeepingLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                ChunkCoordinates center = this.getCenterCoord();
                float fxX = (float)center.field_71574_a + 0.5f;
                float fxY = (float)center.field_71572_b + 1.0f;
                float fxZ = (float)center.field_71573_c + 0.5f;
                float distanceFromCenter = 1.6f;
                float leftRightSpreadFromCenter = distanceFromCenter * (this.worldObj.field_73012_v.nextFloat() - 0.5f);
                float upSpread = this.worldObj.field_73012_v.nextFloat() * 0.8f;
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX - distanceFromCenter, fxY += upSpread, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + distanceFromCenter, fxY, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ - distanceFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ + distanceFromCenter);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("TempChange", this.tempChange);
        data.func_74776_a("HumidChange", this.humidChange);
        this.beekeepingLogic.writeToNBT(data);
        this.inventory.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tempChange = data.func_74760_g("TempChange");
        this.humidChange = data.func_74760_g("HumidChange");
        this.beekeepingLogic.readFromNBT(data);
        this.inventory.readFromNBT(data);
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
        this.beekeepingLogic.syncToClient();
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        ChunkCoordinates coord = this.getCenterCoord();
        return new ChunkCoordinates(coord.field_71574_a, coord.field_71572_b + 1, coord.field_71573_c);
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        ChunkCoordinates coord = this.getCenterCoord();
        return Vec3.func_72443_a((double)((double)coord.field_71574_a + 0.5), (double)((double)coord.field_71572_b + 1.5), (double)((double)coord.field_71573_c + 0.5));
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            for (IMultiblockComponent part : this.connectedParts) {
                if (!(part instanceof TileEntity)) continue;
                TileEntity tile = (TileEntity)part;
                this.worldObj.func_147459_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145838_q());
            }
            this.func_70296_d();
        }
    }

    @Override
    public float getExactTemperature() {
        ChunkCoordinates coords = this.getReferenceCoord();
        return this.getBiome().func_150564_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().field_76751_G + this.humidChange;
    }

    @Override
    public EnumTemperature getTemperature() {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(this);
        BiomeGenBase biome = this.getBiome();
        if ((beeModifier.isHellish() || BiomeHelper.isBiomeHellish(biome)) && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public BiomeGenBase getBiome() {
        ChunkCoordinates coords = this.getReferenceCoord();
        return this.worldObj.func_72807_a(coords.field_71574_a, coords.field_71573_c);
    }

    @Override
    public int getBlockLightValue() {
        ChunkCoordinates topCenter = this.getTopCenterCoord();
        return this.worldObj.func_72957_l(topCenter.field_71574_a, topCenter.field_71572_b + 1, topCenter.field_71573_c);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        ChunkCoordinates topCenter = this.getTopCenterCoord();
        return this.worldObj.func_72937_j(topCenter.field_71574_a, topCenter.field_71572_b + 2, topCenter.field_71573_c);
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        ChunkCoordinates coordinates = this.getCoordinates();
        float temperature = this.getBiome().func_150564_a(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c);
        this.tempChange += change;
        this.tempChange = Math.max(boundaryDown - temperature, this.tempChange);
        this.tempChange = Math.min(boundaryUp - temperature, this.tempChange);
        this.tempChange = change > 0.0f && this.tempChange < 0.0f || change < 0.0f && this.tempChange > 0.0f ? 0.0f : this.tempChange;
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        float humidity = this.getBiome().field_76751_G;
        this.humidChange += change;
        this.humidChange = Math.max(boundaryDown - humidity, this.humidChange);
        this.humidChange = Math.min(boundaryUp - humidity, this.humidChange);
        this.humidChange = change > 0.0f && this.humidChange < 0.0f || change < 0.0f && this.humidChange > 0.0f ? 0.0f : this.humidChange;
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beekeepingLogic.getBeeProgressPercent());
        data.writeVarInt(Math.round(this.tempChange * 100.0f));
        data.writeVarInt(Math.round(this.humidChange * 100.0f));
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
        this.tempChange = (float)data.readVarInt() / 100.0f;
        this.humidChange = (float)data.readVarInt() / 100.0f;
    }
}

