/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmableBasic;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBasicFruit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableBasicFruit
implements IFarmableBasic {
    private final Block block;
    private final int matureMeta;

    public FarmableBasicFruit(Block block, int matureMeta) {
        this.block = block;
        this.matureMeta = matureMeta;
    }

    @Override
    public boolean isSapling(Block block, int meta) {
        return this.block == block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this.block) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.matureMeta) {
            return null;
        }
        return new CropBasicFruit(world, this.block, this.matureMeta, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.func_147465_d(x, y, z, this.block, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

